/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dotnet.types;

import com.ibm.wala.dotnet.Constants;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import java.util.Map;
import java.util.Set;

public class CLRTypeReference {
    private static final Map<String, PrimitiveTypeInfo> primitiveTypes = HashMapFactory.make();
    public static final ClassLoaderReference systemLoader = new ClassLoaderReference(Constants.systemName, Constants.langName, null);
    public static final TypeReference Void = CLRTypeReference.record("Void", -1, true);
    public static final TypeReference Boolean = CLRTypeReference.record("Boolean", 1);
    public static final TypeReference Char = CLRTypeReference.record("Char", 16);
    public static final TypeReference Int8 = CLRTypeReference.record("SByte", 8);
    public static final TypeReference UInt8 = CLRTypeReference.record("Byte", 8);
    public static final TypeReference Int16 = CLRTypeReference.record("Int16", 16);
    public static final TypeReference UInt16 = CLRTypeReference.record("UInt16", 16);
    public static final TypeReference Int32 = CLRTypeReference.record("Int32", 32);
    public static final TypeReference UInt32 = CLRTypeReference.record("UInt32", 32);
    public static final TypeReference Int64 = CLRTypeReference.record("Int64", 64);
    public static final TypeReference UInt64 = CLRTypeReference.record("UInt64", 64);
    public static final TypeReference Float32 = CLRTypeReference.record("Single", 32);
    public static final TypeReference Float64 = CLRTypeReference.record("Double", 64);
    public static final TypeReference IntPtr = CLRTypeReference.record("IntPtr", -1);
    public static final TypeReference UIntPtr = CLRTypeReference.record("UIntPtr", -1);
    public static final TypeReference TypedByRef = CLRTypeReference.record("TypedReference", -1);
    public static final TypeReference SystemObject = TypeReference.findOrCreate((ClassLoaderReference)systemLoader, (String)"LSystem/Object");
    public static final TypeReference SystemException = TypeReference.findOrCreate((ClassLoaderReference)systemLoader, (String)"LSystem/Exception");
    public static final TypeReference SystemString = TypeReference.findOrCreate((ClassLoaderReference)systemLoader, (String)"LSystem/String");
    public static final TypeReference SystemType = TypeReference.findOrCreate((ClassLoaderReference)systemLoader, (String)"LSystem/Type");
    public static final TypeReference SystemReflectionFieldInfo = TypeReference.findOrCreate((ClassLoaderReference)systemLoader, (String)"LSystem/Reflection/FieldInfo");
    public static final TypeReference SystemReflectionMethodBase = TypeReference.findOrCreate((ClassLoaderReference)systemLoader, (String)"LSystem/Reflection/MethodBase");
    public static final TypeReference ArithmeticException = TypeReference.findOrCreate((ClassLoaderReference)systemLoader, (String)"LSystem/ArithmeticException");
    public static final TypeReference ArrayTypeMismatchException = TypeReference.findOrCreate((ClassLoaderReference)systemLoader, (String)"LSystem/ArrayTypeMismatchException");
    public static final TypeReference DivideByZeroException = TypeReference.findOrCreate((ClassLoaderReference)systemLoader, (String)"LSystem/DivideByZeroException");
    public static final TypeReference FieldAccessException = TypeReference.findOrCreate((ClassLoaderReference)systemLoader, (String)"LSystem/FieldAccessException");
    public static final TypeReference IndexOutOfRangeException = TypeReference.findOrCreate((ClassLoaderReference)systemLoader, (String)"LSystem/IndexOutOfRangeException");
    public static final TypeReference InvalidCastException = TypeReference.findOrCreate((ClassLoaderReference)systemLoader, (String)"LSystem/InvalidCastException");
    public static final TypeReference InvalidOperationException = TypeReference.findOrCreate((ClassLoaderReference)systemLoader, (String)"LSystem/InvalidOperationException");
    public static final TypeReference MethodAccessException = TypeReference.findOrCreate((ClassLoaderReference)systemLoader, (String)"LSystem/MethodAccessException");
    public static final TypeReference MissingFieldException = TypeReference.findOrCreate((ClassLoaderReference)systemLoader, (String)"LSystem/MissingFieldException");
    public static final TypeReference MissingMethodException = TypeReference.findOrCreate((ClassLoaderReference)systemLoader, (String)"LSystem/MissingMethodException");
    public static final TypeReference NullReferenceException = TypeReference.findOrCreate((ClassLoaderReference)systemLoader, (String)"LSystem/NullReferenceException");
    public static final TypeReference OutOfMemoryException = TypeReference.findOrCreate((ClassLoaderReference)systemLoader, (String)"LSystem/OutOfMemoryException");
    public static final TypeReference OverflowException = TypeReference.findOrCreate((ClassLoaderReference)systemLoader, (String)"LSystem/OverflowException");
    public static final TypeReference SecurityException = TypeReference.findOrCreate((ClassLoaderReference)systemLoader, (String)"LSystem/Security/SecurityException");
    public static final TypeReference TypeLoadException = TypeReference.findOrCreate((ClassLoaderReference)systemLoader, (String)"LSystem/TypeLoadException");

    private static final TypeReference record(String systemName, int size) {
        return CLRTypeReference.record(systemName, size, false);
    }

    private static final TypeReference record(String systemName, int size, boolean isNonPointerMachineType) {
        TypeName n = TypeName.string2TypeName((String)("PSystem/" + systemName));
        TypeReference ref = TypeReference.makePrimitive((ClassLoaderReference)systemLoader, (TypeName)n);
        return CLRTypeReference.record(systemName, size, isNonPointerMachineType, ref);
    }

    private static final TypeReference record(String systemName, int size, boolean isNonPointerMachineType, TypeReference ref) {
        PrimitiveTypeInfo info = new PrimitiveTypeInfo(ref, systemName, size, isNonPointerMachineType);
        primitiveTypes.put("System/" + systemName, info);
        return ref;
    }

    public static final TypeReference getPrimitive(String name) {
        assert (primitiveTypes.get(name) != null) : name;
        return CLRTypeReference.primitiveTypes.get((Object)name).ref;
    }

    public static final Set<String> getAllPrimitives() {
        return primitiveTypes.keySet();
    }

    public static final PrimitiveTypeInfo getPrimitiveInfo(String name) {
        return primitiveTypes.get(name);
    }

    public static boolean isPrimitive(TypeReference ref) {
        String name = ref.getName().getClassName().toString();
        String pkg = null;
        if (ref.getName().getPackage() != null) {
            pkg = ref.getName().getPackage().toString();
        }
        return pkg == null && !ref.getName().toString().startsWith("L") && name.startsWith("P");
    }

    public static class PrimitiveTypeInfo {
        final TypeReference ref;
        final String systemName;
        final int size;
        final boolean nonPointerMachineType;

        private PrimitiveTypeInfo(TypeReference ref, String systemName, int size, boolean isNonPointerMachineType) {
            this.ref = ref;
            this.systemName = systemName;
            this.size = size;
            this.nonPointerMachineType = isNonPointerMachineType;
        }

        public TypeReference getRef() {
            return this.ref;
        }

        public String getSystemName() {
            return this.systemName;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isNonPointerMachineType() {
            return this.nonPointerMachineType;
        }
    }
}

