/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.eclipse;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.dir.CrawlingStrategy;
import com.ibm.appscan.discovery.eclipse.Messages;
import com.ibm.appscan.internal.discovery.eclipse.EclipseRunner;
import com.ibm.appscan.internal.discovery.eclipse.ProjectStrategy;
import java.io.File;
import java.util.Properties;
import java.util.Set;

public class WorkspaceStrategy
extends CrawlingStrategy {
    private File m_workspace;
    private boolean m_hasEclipse;

    public WorkspaceStrategy() {
    }

    WorkspaceStrategy(File directory) {
        this.init(directory, null);
    }

    public void init(File directory, IStrategyFactoryRegistry registry) {
        this.m_workspace = directory;
        this.m_hasEclipse = new File(CommonCore.getDirectoryLocator().getConfig(), "eclipse.properties").exists();
    }

    public String getName() {
        return this.m_workspace.getName();
    }

    public String getType() {
        return Messages.getMessage("workspace", new Object[0]);
    }

    public String getPath() {
        return this.m_workspace.getPath();
    }

    public String getStrategyClass() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void findScanTargets(IScanTargetProxy proxy, IProgress progress) {
        if (!this.m_hasEclipse) {
            return;
        }
        Properties props = null;
        try {
            props = new EclipseRunner(this.m_workspace).run();
        }
        catch (AppScanException e) {
            proxy.getErrorManager().reportError(Messages.getMessage("workspace.read.error", this.m_workspace.getAbsolutePath()), (Throwable)e);
        }
        if (props != null && props.getProperty("projects") != null) {
            String[] projects;
            for (String project : projects = props.getProperty("projects").split(";")) {
                if (project.trim().isEmpty()) continue;
                proxy.newScanTarget((ScanTargetStrategy)new ProjectStrategy(this.m_workspace, project));
            }
        }
    }

    protected Set<IScanFile> findScanFiles(IScanTargetMinProxy proxy, IProgress progress) {
        if (!this.m_hasEclipse) {
            proxy.getLogManager().log(new Message(2, Messages.getMessage("eclipse.not.found", this.m_workspace.getAbsolutePath())));
            return super.findScanFiles(proxy, progress);
        }
        return null;
    }

    protected File getCrawlRoot(IScanTargetMinProxy proxy) {
        return this.m_workspace;
    }
}

