/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.method;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.Messages;
import com.ibm.appscan.vdb.VdbArtifact;
import com.ibm.appscan.vdb.annotation.VdbAnnotation;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.markup.Alias;
import com.ibm.appscan.vdb.method.markup.Parameter;
import com.ibm.appscan.vdb.method.markup.Property;
import com.ibm.appscan.vdb.method.markup.Taint;
import com.ibm.appscan.vdb.method.markup.ao.ActionObject;
import com.ibm.appscan.vdb.method.markup.ao.Option;
import com.ibm.appscan.vdb.method.markup.ao.Sink;
import com.ibm.appscan.vdb.method.markup.ao.Source;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.provider.VdbProvider;
import com.ibm.appscan.vdb.rule.Rule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Method
extends VdbArtifact
implements Comparable<Method>,
Serializable {
    private static final long serialVersionUID = 1287670747144749726L;
    private static Property m_const;
    private String m_sig = null;
    private String m_shortname = null;
    private ArrayList<String> m_method_parts;
    private ArrayList<String> m_args;
    private String m_methodArgString = null;
    protected ArrayList<String> m_dateTypes = new ArrayList();
    private ArrayList<Rule> m_applyRuleName = new ArrayList();
    private String m_id = null;
    private String m_info_id;
    private ArrayList<String> m_comments;
    private Parameter m_writes_through;
    private Alias m_alias;
    private ArrayList<String> m_ClasHierachyChain = null;
    private ArrayList<String> m_classInterfaces = null;
    private List<VdbAnnotation> m_method_annotations;
    private List<VdbAnnotation> m_class_annotations;
    private HashMap<String, List<VdbAnnotation>> m_arg_annotations;
    private ArrayList<ActionObject> m_all_aos;
    private ArrayList<ActionObject> m_simple_aos;
    private ArrayList<ActionObject> m_sinkrules;
    private ArrayList<ActionObject> m_sources;
    private ArrayList<ActionObject> m_obt;
    private ArrayList<Property> m_all_properties;
    private ArrayList<Property> m_properties;
    private ArrayList<Property> m_mechs;
    private ArrayList<Property> m_techs;
    private ArrayList<Taint> m_taints;
    private boolean m_is_call_back;

    public String getClassNameFqdn() {
        StringBuilder ret = new StringBuilder();
        if (this.getPackageName() != null && this.getPackageName().length() > 0) {
            ret.append(this.getPackageName());
            ret.append(".");
        }
        if (this.getClassName() != null && this.getClassName().length() > 0) {
            ret.append(this.getClassName());
        }
        return ret.toString();
    }

    public boolean isExternalSytheticApi() {
        return this.getSignature().contains("external_taint") || this.getSignature().contains("external_source") || this.getSignature().contains("automatic_callback_source");
    }

    public Method(String signature, Language.LANGUAGE lang) throws BadMarkupException {
        this.setSignature(signature);
        this.setLang(lang);
        m_const = new Property("Attribute.Modifier.Constructor");
    }

    public Method(Method source) throws BadMarkupException {
        this.replace(source);
        m_const = new Property("Attribute.Modifier.Constructor");
    }

    public String getFqdnClassName() {
        if (this.getPackageName() == null) {
            return this.getClassName();
        }
        StringBuilder str = new StringBuilder();
        str.append(this.getPackageName());
        str.append(".");
        str.append(this.getClassName());
        return str.toString();
    }

    public static String getPackage(String sig) throws BadMarkupException {
        String[] _token = sig.split("\\.");
        int _tokenWithMethodName = 0;
        for (int i = 0; i < sig.split("\\.").length; ++i) {
            if (!_token[i].contains("(")) continue;
            _tokenWithMethodName = i;
            break;
        }
        StringBuffer _buf = new StringBuffer();
        for (int i = 0; i < _tokenWithMethodName - 1; ++i) {
            _buf.append(_token[i]);
            _buf.append(".");
        }
        if (_buf.length() > 0) {
            _buf.deleteCharAt(_buf.length() - 1);
            return _buf.toString();
        }
        return null;
    }

    protected abstract Pattern getPatternMatch();

    public static String getClass(String sig) throws BadMarkupException {
        String[] _token = sig.split("\\.");
        int _tokenWithMethodName = 0;
        for (int i = 0; i < _token.length; ++i) {
            if (!_token[i].contains("(")) continue;
            _tokenWithMethodName = i;
            break;
        }
        if (_tokenWithMethodName == 0) {
            return null;
        }
        return _token[_tokenWithMethodName - 1];
    }

    public String getMethodName(String sig) throws BadMarkupException {
        Matcher matcher = this.getPatternMatch().matcher(sig);
        if (!matcher.matches()) {
            throw new BadMarkupException("The signature must follow the format package.class.sig(args):return", new Object[0]);
        }
        String[] _token = sig.split("\\.");
        int _tokenWithMethodName = 0;
        for (int i = 0; i < sig.split("\\.").length; ++i) {
            if (!_token[i].contains("(")) continue;
            _tokenWithMethodName = i;
            break;
        }
        return _token[_tokenWithMethodName].substring(0, _token[_tokenWithMethodName].indexOf("("));
    }

    public String getSignature() {
        return this.m_sig;
    }

    public void setSignature(String sig) throws BadMarkupException {
        Matcher matcher = this.getPatternMatch().matcher(sig);
        if (!(sig.contains("automatic_callback_source") || sig.contains("external") || matcher.matches())) {
            throw new BadMarkupException(Messages.getMessage("method.bad.signature", sig, this.getPatternMatch().toString()), new Object[0]);
        }
        this.m_sig = sig;
        this.m_methodArgString = null;
        this.m_method_parts = null;
        this.m_args = null;
    }

    public ArrayList<String> getMethodParts() {
        if (this.m_method_parts == null) {
            this.m_method_parts = new ArrayList();
            this.m_method_parts = this.getMethodNameParts();
        }
        return this.m_method_parts;
    }

    public String getSimpleMethodName() {
        StringBuffer sig = new StringBuffer();
        int map = 0;
        block5: for (char c : this.getMethodName().toCharArray()) {
            switch (c) {
                case '<': {
                    ++map;
                    continue block5;
                }
                case '>': {
                    --map;
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ':': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case '~': {
                    continue block5;
                }
                default: {
                    if (map != 0) continue block5;
                    sig.append(c);
                }
            }
        }
        return sig.toString();
    }

    protected ArrayList<String> getMethodNameParts() {
        ArrayList<String> ret = new ArrayList<String>();
        String signature = this.getSimpleMethodName();
        if (signature.equals("getGET")) {
            ret.add("get");
            ret.add("get");
            return ret;
        }
        if (signature.equals("getPOST")) {
            ret.add("get");
            ret.add("post");
            return ret;
        }
        if (signature.contains(":")) {
            if (signature.contains(":")) {
                for (String n : signature.split(":")) {
                    if (n.split("(?<=.)(?<=.)(?=\\p{Lu})").length > 0) {
                        for (String part : n.split("(?<=.)(?<=.)(?=\\p{Lu})")) {
                            ret.add(part.toLowerCase());
                        }
                        continue;
                    }
                    ret.add(n.toLowerCase());
                }
            }
        } else if (signature.split("(?<=.)(?<=.)(?=\\p{Lu})").length > 0) {
            for (String part : signature.split("(?<=.)(?<=.)(?=\\p{Lu})")) {
                ret.add(part.toLowerCase());
            }
        } else {
            ret.add(signature.toLowerCase());
        }
        return ret;
    }

    public String getMethodName() {
        if (this.m_shortname == null) {
            this.m_shortname = this.m_sig.substring(0, this.m_sig.indexOf("("));
        }
        if (this.m_shortname.contains(".")) {
            this.m_shortname = this.m_shortname.substring(this.m_shortname.lastIndexOf(".") + 1);
        }
        return this.m_shortname;
    }

    protected void setMethodName(String sig) {
        this.m_shortname = sig;
    }

    public String getArgString() {
        if (this.m_methodArgString == null) {
            this.m_methodArgString = this.getSignature().indexOf("(") == -1 || this.getSignature().indexOf(")") == -1 ? "" : this.getSignature().substring(this.getSignature().indexOf("(") + 1, this.getSignature().indexOf(")"));
        }
        return this.m_methodArgString;
    }

    public ArrayList<String> getArgs() {
        return this.getArgs(this.getArgString());
    }

    public ArrayList<String> getArgs(String argString) {
        if (this.m_args == null) {
            this.m_args = Method.getNormalizedArgs(argString);
        }
        return this.m_args;
    }

    public String getSimpleArgString(int index) throws VDBException {
        if (index > this.getArgs().size() - 1) {
            return "none";
        }
        return this.getSimpleArg(this.getArgs().get(index));
    }

    public String getSimpleReturn() throws VDBException {
        return this.getSimpleArg(this.getReturn());
    }

    public String getSimpleArg(String arg) throws VDBException {
        StringBuffer str = new StringBuffer();
        int map = 0;
        if (arg.toLowerCase().contains("void") && arg.contains("*")) {
            return arg;
        }
        block5: for (char c : arg.toCharArray()) {
            switch (c) {
                case '<': {
                    ++map;
                    continue block5;
                }
                case '>': {
                    --map;
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '-': 
                case '[': 
                case ']': 
                case '^': 
                case '_': {
                    continue block5;
                }
                default: {
                    if (map != 0) continue block5;
                    str.append(c);
                }
            }
        }
        arg = str.toString().toLowerCase();
        Object object = VdbProvider.getStringsToRemove().iterator();
        while (object.hasNext()) {
            String s = (String)object.next();
            if (!arg.startsWith(s)) continue;
            arg = arg.substring(s.length());
        }
        for (String s : VdbProvider.getStringsToRemove()) {
            if (!arg.startsWith(s)) continue;
            arg = arg.substring(s.length());
        }
        if (arg.contains(".")) {
            arg = arg.substring(arg.lastIndexOf(".") + 1);
        }
        if (arg.contains("+")) {
            arg = arg.substring(arg.lastIndexOf("+") + 1);
        }
        if (arg.contains("$")) {
            arg = arg.substring(0, arg.indexOf("$"));
        }
        arg = VdbProvider.isStreamType(arg) ? "stream" : (VdbProvider.isNumber(arg) ? "number" : (VdbProvider.isByteType(arg) ? "byte" : (VdbProvider.isString(arg) ? "string" : (VdbProvider.isBoolean(arg) ? "boolean" : (arg.equals("") || VdbProvider.isObjectType(arg) ? "object" : (VdbProvider.isVoid(arg) ? "void" : (VdbProvider.isTimeDateType(arg) ? "date" : (VdbProvider.isThreadType(arg) ? "thread" : (arg.equals("valist") ? "..." : (VdbProvider.isListType(arg) ? "listtype" : (arg.contains("*") ? "handle" : (VdbProvider.isUrl(arg) ? "url" : "object"))))))))))));
        return arg;
    }

    protected static ArrayList<String> getNormalizedArgs(String argString) {
        ArrayList<String> ret = new ArrayList<String>();
        if (argString != null) {
            if (argString.indexOf("(^)") > -1 || argString.indexOf("(*)") > -1 || argString.indexOf("<") > -1) {
                boolean inArg = true;
                boolean inBlock = false;
                boolean inBlockArgs = false;
                boolean foundBlockCarret = false;
                int inGeneric = 0;
                StringBuffer arg = new StringBuffer(argString.length());
                block9: for (char c : argString.toCharArray()) {
                    switch (c) {
                        case '<': {
                            ++inGeneric;
                            arg.append(c);
                            continue block9;
                        }
                        case '>': {
                            --inGeneric;
                            arg.append(c);
                            continue block9;
                        }
                        case '(': {
                            inArg = false;
                            inBlock = true;
                            if (foundBlockCarret) {
                                inBlockArgs = true;
                            }
                            arg.append(c);
                            continue block9;
                        }
                        case '^': {
                            foundBlockCarret = true;
                            arg.append(c);
                            continue block9;
                        }
                        case '*': {
                            foundBlockCarret = true;
                            arg.append(c);
                            continue block9;
                        }
                        case ')': {
                            if (!inBlock) continue block9;
                            arg.append(c);
                            if (!inBlockArgs) continue block9;
                            inBlock = false;
                            inBlockArgs = false;
                            foundBlockCarret = false;
                            inArg = true;
                            continue block9;
                        }
                        case ';': {
                            if (!inBlock && inGeneric == 0) {
                                ret.add(arg.toString());
                                arg.setLength(0);
                                inArg = true;
                                inBlockArgs = false;
                                foundBlockCarret = false;
                                continue block9;
                            }
                            arg.append(c);
                            continue block9;
                        }
                        default: {
                            if (!inArg && !inBlock) continue block9;
                            arg.append(c);
                        }
                    }
                }
                if (arg.length() > 0) {
                    ret.add(arg.toString());
                }
            } else if (argString.indexOf(";") > -1) {
                for (String arg : argString.split(";")) {
                    if (arg.indexOf(", ") > -1) {
                        for (String a2 : arg.split(", ")) {
                            ret.add(a2);
                        }
                        continue;
                    }
                    ret.add(arg);
                }
            } else if (argString.length() > 0) {
                ret.add(argString);
            }
        }
        return ret;
    }

    public ArrayList<Rule> getRules() {
        return this.m_applyRuleName;
    }

    public void addRule(Rule r) {
        this.m_applyRuleName.add(r);
    }

    public String getReturn() {
        return this.getSignature().substring(this.getSignature().lastIndexOf(":") + 1);
    }

    public boolean addActionObject(ActionObject ao) throws BadMarkupException {
        if (ao.isValid()) {
            if (this.getAllActionObjects().contains(ao)) {
                return true;
            }
            if (ao.isReturn() && !this.isReturn()) {
                ao.setReturn(false);
            }
            if (ao.getParameter() != null) {
                try {
                    if (!ao.getParameter().workForArgs(this)) {
                        throw new BadMarkupException("AO parameters {0} do not work for {1}", ao.getParameter(), this.getSignature());
                    }
                }
                catch (VDBException e) {
                    if (e instanceof BadMarkupException) {
                        throw (BadMarkupException)e;
                    }
                    throw new BadMarkupException(e);
                }
            }
            if (ao.isSimpleType()) {
                this.getSimpleActionObjects().add(ao);
                Collections.sort(this.getSimpleActionObjects());
            } else if (ao.isOptionBasedTester()) {
                this.getOptionBaseTesters().add(ao);
                Collections.sort(this.getOptionBaseTesters());
            } else if (ao.isSink()) {
                for (ActionObject sink : this.getSinks()) {
                    if (sink.getSeverity() != ao.getSeverity() || sink.getAoType() != ao.getAoType() || !sink.getVulnerability().equals(ao.getVulnerability()) || !sink.getParameter().canBeMerged(ao.getParameter())) continue;
                    sink.getParameter().merge(ao.getParameter());
                    return true;
                }
                this.getSinks().add(ao);
                Collections.sort(this.getSinks());
            } else if (ao.isSource()) {
                for (ActionObject source : this.getSources()) {
                    if (!source.getParameter().canBeMerged(ao.getParameter())) continue;
                    if (ao.isReturn()) {
                        source.setReturn(ao.isReturn());
                    }
                    source.getParameter().merge(ao.getParameter());
                    return true;
                }
                this.getSources().add(ao);
                Collections.sort(this.getSources());
            }
            this.getAllActionObjects().add(ao);
            Collections.sort(this.getAllActionObjects());
            return true;
        }
        throw new BadMarkupException("Did not add AO {0} to method {1}. Unknown error", ao.toString(), this.getSignature());
    }

    public boolean addActionObject(String vuln, VDBEnums.AO_TYPE type, VDBEnums.SEVERITY sev) throws BadMarkupException {
        ActionObject ao = new ActionObject(vuln, type, sev);
        return this.addActionObject(ao);
    }

    public boolean addSink(String vuln, VDBEnums.SEVERITY sev, String param) throws BadMarkupException {
        Sink s = new Sink(vuln, sev, param);
        ((ActionObject)s).isValid();
        return this.addActionObject(s);
    }

    public boolean addSource(String param, boolean rtn) throws BadMarkupException {
        Source s = new Source(param, rtn);
        return this.addActionObject(s);
    }

    public boolean addOptionBasedTester(VDBEnums.OPTION_NAME name, String value, String param, VDBEnums.OPTION_OPERATOR operator, VDBEnums.OPTION_CONFIDENCE min, VDBEnums.OPTION_CONFIDENCE max, String vuln, VDBEnums.SEVERITY sev) throws BadMarkupException {
        ActionObject ao = new ActionObject();
        ao.setVulnerability(vuln);
        ao.setAoType(VDBEnums.AO_TYPE.OptionBasedTester);
        ao.setSeverity(sev);
        Option o = new Option();
        o.setOptionName(name);
        o.setOptionOperator(operator);
        o.setOptionValue(value);
        o.setParameter(param);
        o.setMaxCon(max);
        o.setMinCon(min);
        ao.addOption(o);
        return this.addActionObject(ao);
    }

    public boolean deleteActionObject(ActionObject ao) {
        if (this.getAllActionObjects().contains(ao)) {
            this.getAllActionObjects().remove(ao);
            if (ao.isSimpleType()) {
                this.getSimpleActionObjects().remove(ao);
            } else if (ao.isOptionBasedTester()) {
                this.getOptionBaseTesters().remove(ao);
            } else if (ao.isSink()) {
                this.getSinks().remove(ao);
            } else if (ao.isSource()) {
                this.getSources().remove(ao);
            }
            this.clearRules();
            return true;
        }
        return false;
    }

    public boolean deleteAllActionObjects() {
        if (this.getAllActionObjects().size() > 0) {
            this.getAllActionObjects().clear();
            this.getSimpleActionObjects().clear();
            this.getOptionBaseTesters().clear();
            this.getSinks().clear();
            this.getSources().clear();
            return true;
        }
        return false;
    }

    public ArrayList<ActionObject> getAllActionObjects() {
        if (this.m_all_aos == null) {
            this.m_all_aos = new ArrayList(1);
        }
        return this.m_all_aos;
    }

    public ArrayList<ActionObject> getSimpleActionObjects() {
        if (this.m_simple_aos == null) {
            this.m_simple_aos = new ArrayList(1);
        }
        return this.m_simple_aos;
    }

    public ArrayList<ActionObject> getOptionBaseTesters() {
        if (this.m_obt == null) {
            this.m_obt = new ArrayList(1);
        }
        return this.m_obt;
    }

    public ArrayList<ActionObject> getSinks() {
        if (this.m_sinkrules == null) {
            this.m_sinkrules = new ArrayList(1);
        }
        return this.m_sinkrules;
    }

    public ArrayList<ActionObject> getSources() {
        if (this.m_sources == null) {
            this.m_sources = new ArrayList(1);
        }
        return this.m_sources;
    }

    public boolean addProperty(String property) throws BadMarkupException {
        Property p = new Property(property);
        return this.addProperty(p);
    }

    public boolean addMechanism(String property) throws BadMarkupException {
        return this.addProperty(property);
    }

    public boolean addTechnology(String property) throws BadMarkupException {
        return this.addProperty(property);
    }

    public boolean addProperty(Property property) throws BadMarkupException {
        if (!this.getAllProperties().contains(property)) {
            this.getAllProperties().add(property);
            try {
                if (property.isMech()) {
                    this.getMechanisms().add(property);
                    Collections.sort(this.getMechanisms());
                } else if (property.isTech()) {
                    this.getTechnologies().add(property);
                    Collections.sort(this.getTechnologies());
                } else {
                    this.getProperties().add(property);
                    Collections.sort(this.getProperties());
                }
            }
            catch (VDBGeneralException e) {
                throw new BadMarkupException(e);
            }
            Collections.sort(this.getAllProperties());
            return true;
        }
        return false;
    }

    public boolean setNotValidationRoutineFlag() throws BadMarkupException {
        return this.addProperty("Attribute.Validation.None");
    }

    public boolean deleteProperty(String prop) throws BadMarkupException {
        Property p = new Property(prop);
        return this.deleteProperty(p);
    }

    public boolean deleteProperty(Property prop) throws BadMarkupException {
        if (this.getAllProperties().contains(prop)) {
            this.getAllProperties().remove(prop);
            try {
                if (prop.isMech()) {
                    this.getMechanisms().remove(prop);
                } else if (prop.isTech()) {
                    this.getTechnologies().remove(prop);
                } else {
                    this.getProperties().remove(prop);
                }
            }
            catch (VDBGeneralException e) {
                throw new BadMarkupException(e);
            }
            return true;
        }
        return false;
    }

    public boolean deleteAllProperties() {
        if (this.getAllProperties().size() > 0) {
            this.getAllProperties().clear();
            this.getProperties().clear();
            this.getTechnologies().clear();
            this.getMechanisms().clear();
            return true;
        }
        return false;
    }

    public ArrayList<Property> getAllProperties() {
        if (this.m_all_properties == null) {
            this.m_all_properties = new ArrayList(3);
        }
        return this.m_all_properties;
    }

    public ArrayList<Property> getProperties() {
        if (this.m_properties == null) {
            this.m_properties = new ArrayList(2);
        }
        return this.m_properties;
    }

    public ArrayList<Property> getMechanisms() {
        if (this.m_mechs == null) {
            this.m_mechs = new ArrayList(2);
        }
        return this.m_mechs;
    }

    public ArrayList<Property> getTechnologies() {
        if (this.m_techs == null) {
            this.m_techs = new ArrayList(2);
        }
        return this.m_techs;
    }

    public boolean addTaint(String source, String dst, boolean isRtn) throws BadMarkupException {
        Taint t = new Taint(source, dst, isRtn);
        return this.addTaint(t);
    }

    public boolean addTaint(Taint t) throws BadMarkupException {
        if (!t.isValidForMethod(this)) {
            return false;
        }
        if (!this.getTaints().contains(t)) {
            if (this.isNotSusceptibleToTaint()) {
                if (!t.isNotSusceptibleToTaint()) {
                    this.getTaints().clear();
                    this.getTaints().add(t);
                    return true;
                }
                return false;
            }
            if (this.getTaints().size() > 0 && t.isNotSusceptibleToTaint()) {
                return false;
            }
            this.getTaints().add(t);
            return true;
        }
        return false;
    }

    public boolean deleteTaint(String src_param, String dst_param, boolean isRtn) throws BadMarkupException {
        Taint t = new Taint(src_param, dst_param, isRtn);
        return this.deleteTaint(t);
    }

    private boolean deleteTaint(Taint taint) {
        if (this.getTaints().contains(taint)) {
            this.getTaints().remove(taint);
            return true;
        }
        return false;
    }

    public boolean deleteAllTaints() {
        if (this.getTaints().size() > 0) {
            this.getTaints().clear();
            return true;
        }
        return false;
    }

    public void deleteComments() {
        this.m_comments = null;
    }

    public ArrayList<Taint> getTaints() {
        if (this.m_taints == null) {
            this.m_taints = new ArrayList(1);
        }
        return this.m_taints;
    }

    public boolean isNotSusceptibleToTaint() {
        return this.getTaints().size() == 1 && this.getTaints().get(0).getSourceParam().isNone() && this.getTaints().get(0).getDstParam().isNone() && !this.getTaints().get(0).isReturn();
    }

    public boolean setNotSusceptibleToTaint() throws BadMarkupException {
        return this.addTaint("none", "none", false);
    }

    public boolean setTaintForAll() throws BadMarkupException {
        return this.addTaint("all", "all", true);
    }

    public boolean setCallBack(boolean isCallBack) {
        if (this.m_is_call_back != isCallBack) {
            this.m_is_call_back = isCallBack;
            return true;
        }
        return false;
    }

    public boolean setWritesThrough(String param) throws BadMarkupException {
        this.m_writes_through = new Parameter(param);
        return true;
    }

    public Parameter getWritesThrough() {
        return this.m_writes_through;
    }

    public boolean setAlias(String parameter, boolean rtn) throws BadMarkupException {
        this.m_alias = new Alias(parameter, rtn);
        return true;
    }

    public Alias getAlias() {
        return this.m_alias;
    }

    public boolean isCallBack() {
        return this.m_is_call_back;
    }

    public boolean isLikeliHoodHigh() throws BadMarkupException {
        return this.getProperties().contains(new Property("Attribute.LikeliHood.High"));
    }

    public boolean isLikeliHoodLow() throws BadMarkupException {
        return this.getProperties().contains(new Property("Attribute.LikeliHood.Low"));
    }

    @Override
    public void reset() {
        this.m_args = null;
        this.m_is_call_back = false;
        this.m_all_aos = null;
        this.m_simple_aos = null;
        this.m_obt = null;
        this.m_sinkrules = null;
        this.m_sources = null;
        this.m_all_properties = null;
        this.m_properties = null;
        this.m_techs = null;
        this.m_mechs = null;
        this.m_taints = null;
    }

    public void addMethodAnnotation(VdbAnnotation a) {
        if (this.m_method_annotations == null) {
            this.m_method_annotations = new ArrayList<VdbAnnotation>();
        }
        this.m_method_annotations.add(a);
    }

    public List<VdbAnnotation> getMethodAnnotations() {
        if (this.m_method_annotations == null) {
            this.m_method_annotations = new ArrayList<VdbAnnotation>();
        }
        return this.m_method_annotations;
    }

    public void setMethodAnnotation(List<VdbAnnotation> method_annotations) {
        this.m_method_annotations = method_annotations;
    }

    public void addClassAnnotation(VdbAnnotation a) {
        if (this.m_class_annotations == null) {
            this.m_class_annotations = new ArrayList<VdbAnnotation>();
        }
        this.m_class_annotations.add(a);
    }

    public List<VdbAnnotation> getClassAnnotations() {
        if (this.m_class_annotations == null) {
            this.m_class_annotations = new ArrayList<VdbAnnotation>();
        }
        return this.m_class_annotations;
    }

    public void setClassAnnotations(List<VdbAnnotation> class_annotations) {
        this.m_class_annotations = class_annotations;
    }

    public boolean addArgAnnotation(String arg, VdbAnnotation a) {
        if (this.m_arg_annotations == null) {
            this.m_arg_annotations = new HashMap();
        }
        if (this.getArgs().contains(arg)) {
            if (!this.m_arg_annotations.containsKey(arg)) {
                this.m_arg_annotations.put(arg, new ArrayList());
            }
            this.m_arg_annotations.get(arg).add(a);
            return true;
        }
        return false;
    }

    public HashMap<String, List<VdbAnnotation>> getArgAnnotations() {
        if (this.m_arg_annotations == null) {
            this.m_arg_annotations = new HashMap();
        }
        return this.m_arg_annotations;
    }

    public void setArgAnnotations(HashMap<String, List<VdbAnnotation>> arg_annotations) {
        this.m_arg_annotations = arg_annotations;
    }

    @Override
    public void replace(VdbArtifact artifact) throws BadMarkupException {
        if (artifact instanceof Method) {
            Method m = (Method)artifact;
            this.reset();
            this.setSignature(m.getSignature());
            this.setPackageName(m.getPackageName());
            this.setFramework(m.getFramework());
            this.setClassName(m.getClassName());
            this.setLang(m.getLang());
            this.merge(m);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof Method) {
            Method m = (Method)o;
            if (this.getSignature().equals(m.getSignature())) {
                if (!this.compareLists(this.getTaints(), m.getTaints())) {
                    return false;
                }
                if (!this.compareLists(this.getAllActionObjects(), m.getAllActionObjects())) {
                    return false;
                }
                if (!this.compareLists(this.getAllProperties(), m.getAllProperties())) {
                    return false;
                }
                return !this.isCallBack() || m.isCallBack();
            }
            return false;
        }
        return super.equals(o);
    }

    private boolean compareLists(ArrayList<?> thisElem, ArrayList<?> targetElem) {
        VdbArtifact tee;
        VdbArtifact ee;
        boolean equal = true;
        for (Object e : thisElem) {
            equal = false;
            ee = (VdbArtifact)e;
            for (Object te : targetElem) {
                tee = (VdbArtifact)te;
                if (!ee.equals(tee)) continue;
                equal = true;
                break;
            }
            if (equal) continue;
            return false;
        }
        for (Object e : targetElem) {
            equal = false;
            ee = (VdbArtifact)e;
            for (Object te : thisElem) {
                tee = (VdbArtifact)te;
                if (!ee.equals(tee)) continue;
                equal = true;
                break;
            }
            if (equal) continue;
            return false;
        }
        return equal;
    }

    public boolean isMarkedUp() {
        if (this.getAllActionObjects().size() > 0 || this.getMechanisms().size() > 0 || this.getTechnologies().size() > 0 || this.getTaints().size() > 0 || this.isCallBack()) {
            return true;
        }
        if (this.getProperties().size() > 0) {
            for (Property p : this.getProperties()) {
                if (p.getPropertyId() == 1883 || p.getPropertyId() == 1884) {
                    return true;
                }
                if (p.getPropertyId() != 1099 || this.getTaints().size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean merge(VdbArtifact artifact) throws BadMarkupException {
        if (artifact instanceof Method) {
            Method m = (Method)artifact;
            this.setId(m.getId());
            this.setClassName(m.getClassName());
            this.setFramework(m.getFramework());
            this.setPackageName(m.getPackageName());
            this.setInfoId(m.getInfoId());
            for (Property p : m.getAllProperties()) {
                this.addProperty(new Property(p.getProperty()));
            }
            if (m.isMarkedUp()) {
                for (ActionObject ao : m.getAllActionObjects()) {
                    this.addActionObject(new ActionObject(ao));
                }
                for (Taint t : m.getTaints()) {
                    this.addTaint(new Taint(t));
                }
                this.setCallBack(m.isCallBack());
                return true;
            }
        }
        return false;
    }

    @Override
    public int compareTo(Method o) {
        return this.getSignature().compareToIgnoreCase(o.getSignature());
    }

    public boolean isStatic() {
        Property p;
        try {
            p = new Property("Attribute.Modifier.Static");
        }
        catch (BadMarkupException e) {
            return false;
        }
        if (this.getProperties().contains(p)) {
            return true;
        }
        return this.getMethodName().contains("+") && this.getMethodName().contains(":");
    }

    public void setStatic(boolean isStatic) {
        try {
            Property p = new Property("Attribute.Modifier.Static");
            this.getAllProperties().add(p);
            this.getProperties().add(p);
        }
        catch (BadMarkupException badMarkupException) {
            // empty catch block
        }
    }

    public boolean isConstructor() {
        if (this.getProperties().contains(m_const)) {
            return true;
        }
        return this.isConstructor_();
    }

    protected abstract boolean isConstructor_();

    public boolean isGetter() {
        if (this.isStatic()) {
            return false;
        }
        if (this.getArgs(this.getArgString()).size() > 0) {
            return false;
        }
        return this.isGetter_();
    }

    public boolean isDefined() throws BadMarkupException {
        Property p = new Property("Attribute.Modifier.Defined");
        return this.getAllProperties().contains(p);
    }

    public boolean isMember() throws BadMarkupException {
        Property p = new Property("Attribute.Modifier.Member");
        return this.getAllProperties().contains(p);
    }

    public void setMember() throws BadMarkupException {
        this.addProperty("Attribute.Modifier.Member");
    }

    protected abstract boolean isGetter_();

    public boolean isSetter() {
        if (this.isStatic()) {
            return false;
        }
        return this.isSetter_();
    }

    protected abstract boolean isSetter_();

    public boolean isNcf() {
        return this.getPackageName() == null || this.getPackageName().length() <= 0 || this.getClassName() == null || this.getClassName().length() <= 0;
    }

    public boolean isWebTechMech() {
        if (this.getSignature().toLowerCase().contains("servlet") || this.getSignature().toLowerCase().contains("http") || this.getSignature().toLowerCase().contains("html") || this.getSignature().toLowerCase().contains("web") || this.getMethodName().contains("GET") || this.getMethodName().contains("POST") || this.getMethodName().contains("SESSION") || this.getMethodName().contains("COOKIE")) {
            return true;
        }
        for (Property p : this.getAllProperties()) {
            if (p.getProperty().contains("Communications")) {
                return true;
            }
            if (p.getProperty().contains("HTTP")) {
                return true;
            }
            if (p.getProperty().contains("URL")) {
                return true;
            }
            if (!p.getProperty().contains("SSL")) continue;
            return true;
        }
        for (ActionObject ao : this.getAllActionObjects()) {
            if (ao.getVulnerability().contains("Injection")) {
                return true;
            }
            if (ao.getVulnerability().contains("CrossSite")) {
                return true;
            }
            if (ao.getVulnerability().contains("Browser")) {
                return true;
            }
            if (ao.getVulnerability().contains("Upload")) {
                return true;
            }
            if (ao.getVulnerability().contains("JSON")) {
                return true;
            }
            if (ao.getVulnerability().contains("URL")) {
                return true;
            }
            if (ao.getVulnerability().contains("Socket")) {
                return true;
            }
            if (!ao.getVulnerability().contains("Stream")) continue;
            return true;
        }
        return false;
    }

    public boolean isFileTechMech() {
        if (this.getMethodName().contains("FILE")) {
            return true;
        }
        for (Property p : this.getAllProperties()) {
            if (!p.getProperty().contains("FileSystem") && !p.getProperty().contains("IO") && !p.getProperty().contains("Storage") && !this.isDbTechMech()) continue;
            return true;
        }
        for (ActionObject ao : this.getAllActionObjects()) {
            if (ao.getVulnerability().contains("File")) {
                return true;
            }
            if (!ao.getVulnerability().contains("Path")) continue;
            return true;
        }
        return false;
    }

    public boolean isDbTechMech() {
        if (this.getSignature().toLowerCase().contains("sql")) {
            return true;
        }
        if (this.getSignature().toLowerCase().contains("db")) {
            return true;
        }
        if (this.getSignature().toLowerCase().contains("database")) {
            return true;
        }
        if (this.getMethodName().contains("DataRow")) {
            return true;
        }
        for (Property p : this.getAllProperties()) {
            if (!p.getProperty().contains("DataBase")) continue;
            return true;
        }
        for (ActionObject ao : this.getAllActionObjects()) {
            if (ao.getVulnerability().contains("DB")) {
                return true;
            }
            if (ao.getVulnerability().contains("SQL")) {
                return true;
            }
            if (!ao.getVulnerability().contains("SecondOrder")) continue;
            return true;
        }
        return false;
    }

    public boolean isDbExecute() {
        if (this.getSignature().toLowerCase().contains("execute")) {
            return true;
        }
        return this.getSignature().toLowerCase().contains("prepare");
    }

    public void setId(String id) {
        this.m_id = id;
    }

    public String getId() {
        return this.m_id;
    }

    public void setInfoId(String id) {
        this.m_info_id = id;
    }

    public String getInfoId() {
        return this.m_info_id;
    }

    public void addClassHierachyChain(String classHierachyChain) {
        this.getClassHierachyChain().add(classHierachyChain);
    }

    public ArrayList<String> getClassHierachyChain() {
        if (this.m_ClasHierachyChain == null) {
            this.m_ClasHierachyChain = new ArrayList();
        }
        return this.m_ClasHierachyChain;
    }

    public void addClassInterfaces(String classInterfaces) {
        this.getClassInterfaces().add(classInterfaces);
    }

    public ArrayList<String> getClassInterfaces() {
        if (this.m_classInterfaces == null) {
            this.m_classInterfaces = new ArrayList();
        }
        return this.m_classInterfaces;
    }

    public String getMethodId() {
        if (this.getPackageName() != null && this.getPackageName().length() > 0) {
            return this.getPackageName();
        }
        if (this.getClassName() != null && this.getClassName().length() > 0) {
            return this.getClassName();
        }
        return "nonClassFuncs";
    }

    public boolean isInDB() {
        return this.getId() != null;
    }

    public boolean isPrivate() throws BadMarkupException {
        return this.getAllProperties().contains(new Property("Attribute.Modifier.Private"));
    }

    public boolean isPackageProtected() throws BadMarkupException {
        return this.getAllProperties().contains(new Property("Attribute.Modifier.PackageProtected"));
    }

    public void updateIds(Method target) throws BadMarkupException {
        boolean reset;
        boolean bl = reset = target == null;
        if (reset) {
            this.setId(null);
            this.setInfoId(null);
        } else {
            this.setId(target.getId());
            this.setInfoId(target.getInfoId());
        }
        this.updateActionObjects(target, reset);
    }

    private void updateActionObjects(Method target, boolean reset) throws BadMarkupException {
        block0: for (ActionObject ao : this.getAllActionObjects()) {
            if (!reset) {
                for (ActionObject tao : target.getAllActionObjects()) {
                    if (!ao.equals(tao)) continue;
                    ao.setId(tao.getId());
                    continue block0;
                }
                continue;
            }
            ao.setId(null);
        }
    }

    public boolean isTaintPropagaor() {
        for (Taint t : this.getTaints()) {
            if (t.isNotSusceptibleToTaint()) continue;
            return true;
        }
        return false;
    }

    public boolean isReturn() {
        return !this.isReturnVoid() && !this.isReturnBoolean() && !this.isReturnNumber();
    }

    public boolean isReturnNumber() {
        if (this.getReturn().toLowerCase().endsWith("int")) {
            return true;
        }
        return this.getReturn().toLowerCase().endsWith("long");
    }

    public boolean isReturnBoolean() {
        return this.getReturn().toLowerCase().contains("bool");
    }

    public boolean isReturnVoid() {
        return this.getReturn().toLowerCase().contains("void");
    }

    private void clearRules() {
        if (!this.isMarkedUp()) {
            this.getRules().clear();
        }
        if (this.getTechnologies().size() == 0 && this.getMechanisms().size() == 0) {
            this.setInfoId(null);
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append(this.getSignature());
        str.append(System.getProperty("line.separator"));
        str.append("\tid:" + this.getId());
        str.append(System.getProperty("line.separator"));
        str.append("\tPackage:" + this.getPackageName());
        str.append(System.getProperty("line.separator"));
        str.append("\tClass:" + this.getClassName());
        str.append(System.getProperty("line.separator"));
        str.append("\tArgs:" + this.getArgString());
        str.append(System.getProperty("line.separator"));
        for (Taint t : this.getTaints()) {
            str.append("\tTaint: " + t.toString());
            str.append(System.getProperty("line.separator"));
        }
        for (ActionObject ao : this.getAllActionObjects()) {
            str.append("\t: AO:" + ao.toString());
            str.append(System.getProperty("line.separator"));
        }
        for (Property p : this.getAllProperties()) {
            str.append("\tProp:" + p.getProperty());
            str.append(System.getProperty("line.separator"));
        }
        str.append(System.getProperty("line.separator"));
        for (String comment : this.getComments()) {
            str.append(comment);
            str.append(System.getProperty("line.separator"));
        }
        if (this.getWritesThrough() != null) {
            str.append("\tWrites Through:" + this.getWritesThrough().toString());
            str.append(System.getProperty("line.separator"));
        }
        if (this.getAlias() != null) {
            str.append(System.getProperty("line.separator"));
            str.append("\tStores Writeable Alias:" + this.getAlias().getParameter().toString() + ", return:" + (this.getAlias().isReturn() ? "true" : "false"));
            str.append(System.getProperty("line.separator"));
        }
        if (this.getClassAnnotations().size() > 0) {
            str.append("\tClass Annotations:");
            str.append(System.getProperty("line.separator"));
            this.addAnnotationDetail(this.getClassAnnotations(), str);
        }
        if (this.getMethodAnnotations().size() > 0) {
            str.append("\tMethod Annotations:");
            str.append(System.getProperty("line.separator"));
            this.addAnnotationDetail(this.getClassAnnotations(), str);
        }
        if (this.getArgAnnotations().keySet().size() > 0) {
            for (String key : this.getArgAnnotations().keySet()) {
                str.append("\tArg Annotations for ");
                str.append(key);
                str.append(":");
                str.append(System.getProperty("line.separator"));
                this.addAnnotationDetail(this.getArgAnnotations().get(key), str);
            }
        }
        if (this.getComments().size() > 0) {
            str.append("\tComments:");
            str.append(System.getProperty("line.separator"));
            for (String c : this.getComments()) {
                str.append(c);
                str.append(System.getProperty("line.separator"));
            }
        }
        return str.toString();
    }

    private void addAnnotationDetail(List<VdbAnnotation> annotations, StringBuffer str) {
        for (VdbAnnotation a : annotations) {
            str.append("\t\t" + a.getName());
            str.append(System.getProperty("line.separator"));
            for (String key : a.getArgs().keySet()) {
                str.append("\t\t\t" + key + ":" + a.getArgs().get(key));
                str.append(System.getProperty("line.separator"));
            }
        }
    }

    public void addComment(String comment) {
        this.getComments().add(comment);
    }

    public ArrayList<String> getComments() {
        if (this.m_comments == null) {
            this.m_comments = new ArrayList();
        }
        return this.m_comments;
    }
}

