/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.method;

import com.ibm.appscan.assessment.model.Finding;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.VdbArtifact;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.method.markup.valid.Descriptor;
import com.ibm.appscan.vdb.misc.VDBConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.regex.Matcher;

public class ValidationRoutine
extends VdbArtifact
implements Comparable<ValidationRoutine> {
    private Matcher m_matcher;
    private String m_signature;
    private HashMap<String, Descriptor> m_descriptors;

    public ValidationRoutine(String signature, Language.LANGUAGE lang) throws BadMarkupException {
        this.setSignature(signature);
        this.setLang(lang);
    }

    public void setSignature(String sig) throws BadMarkupException {
        this.m_matcher = VDBConstants.SIGNATURE_PATTERN.matcher(sig);
        if (!this.m_matcher.matches()) {
            throw new BadMarkupException("The signature must follow the format sig(args):return", new Object[0]);
        }
        this.m_signature = sig;
    }

    public String getSignature() {
        return this.m_signature;
    }

    public HashMap<String, Descriptor> getDescriptorMap() {
        if (this.m_descriptors == null) {
            this.m_descriptors = new HashMap();
        }
        return this.m_descriptors;
    }

    public Collection<Descriptor> getDescriptors() {
        return this.getDescriptorMap().values();
    }

    public boolean addDescriptor(String name) {
        if (this.getDescriptorMap().containsKey(name)) {
            return false;
        }
        Descriptor d = new Descriptor(name);
        this.getDescriptorMap().put(d.getDescriptorName(), d);
        return true;
    }

    public boolean addDescriptor(Descriptor d) throws BadMarkupException {
        if (this.getDescriptorMap().containsKey(d.getDescriptorName())) {
            return this.getDescriptorMap().get(d.getDescriptorName()).merge(d);
        }
        this.getDescriptorMap().put(d.getDescriptorName(), d);
        return true;
    }

    public boolean deleteDescriptor(String name) {
        if (this.getDescriptorMap().containsKey(name)) {
            this.getDescriptorMap().remove(name);
            return true;
        }
        return false;
    }

    public Descriptor getDescriptor(String name) {
        return this.getDescriptorMap().get(name);
    }

    @Override
    public void reset() {
        this.m_descriptors = null;
    }

    @Override
    public void replace(VdbArtifact artifact) throws BadMarkupException {
        this.reset();
        if (artifact instanceof ValidationRoutine) {
            this.merge(artifact);
        }
    }

    @Override
    public int compareTo(ValidationRoutine v) {
        if (this.getSignature().compareToIgnoreCase(v.getSignature()) != 0) {
            return this.getSignature().compareToIgnoreCase(v.getSignature());
        }
        if (this.getDescriptors().size() > v.getDescriptors().size()) {
            return 1;
        }
        if (this.getDescriptors().size() < v.getDescriptors().size()) {
            return -1;
        }
        if (this.getDescriptors().size() > 0) {
            for (String name : this.getDescriptorMap().keySet()) {
                if (v.getDescriptor(name) == null) {
                    return 1;
                }
                if (this.getDescriptor(name).compareTo(v.getDescriptor(name)) == 0) continue;
                return this.getDescriptor(name).compareTo(v.getDescriptor(name));
            }
            for (String name : v.getDescriptorMap().keySet()) {
                if (this.getDescriptor(name) == null) {
                    return -1;
                }
                if (v.getDescriptor(name).compareTo(this.getDescriptor(name)) == 0) continue;
                return v.getDescriptor(name).compareTo(this.getDescriptor(name));
            }
        }
        return 0;
    }

    public boolean equals(Object o) {
        ValidationRoutine v;
        return o instanceof ValidationRoutine && this.compareTo(v = (ValidationRoutine)o) == 0;
    }

    @Override
    public boolean merge(VdbArtifact artifact) throws BadMarkupException {
        boolean _ret = false;
        if (artifact instanceof ValidationRoutine) {
            ValidationRoutine v = (ValidationRoutine)artifact;
            for (Descriptor d : v.getDescriptors()) {
                if (!this.addDescriptor(d)) continue;
                _ret = true;
            }
        }
        return _ret;
    }

    public boolean validatesFinding(Finding finding) throws VDBException {
        if (finding.getTrace() == null) {
            return false;
        }
        if (finding.getApisInTrace().contains(this.getSignature())) {
            for (Descriptor d : this.getDescriptors()) {
                if (!d.validatesFinding(finding)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("Validation Routine:");
        ret.append(this.getSignature());
        ret.append(System.lineSeparator());
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>(this.getDescriptors());
        Collections.sort(descriptors);
        for (Descriptor d : descriptors) {
            ret.append(d);
        }
        return ret.toString();
    }
}

