/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.method.markup;

import com.ibm.appscan.vdb.VdbArtifact;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.method.markup.MarkupBase;
import com.ibm.appscan.vdb.method.markup.Parameter;
import com.ibm.appscan.vdb.provider.VdbProvider;

public class Taint
extends MarkupBase
implements Comparable<Taint> {
    private Parameter m_sourceParam;
    private Parameter m_dstParam;
    private boolean m_is_return = false;

    public Taint() throws BadMarkupException {
    }

    public Taint(String src_param, String dst_param, boolean isReturn) throws BadMarkupException {
        this.setSourceParam(src_param);
        this.setDstParam(dst_param);
        this.setReturn(isReturn);
        if (!this.isValid()) {
            throw new BadMarkupException("Not Valid", new Object[0]);
        }
    }

    public Taint(Taint t) throws BadMarkupException {
        this.setSourceParam(t.getSourceParam().getGivenParam());
        this.setDstParam(t.getDstParam().getGivenParam());
        this.setReturn(t.isReturn());
    }

    @Override
    public boolean isValid() throws BadMarkupException {
        if (this.getSourceParam() != null && this.getDstParam() != null) {
            return !this.getSourceParam().getGivenParam().equals("none") || !this.getDstParam().getGivenParam().equals("none") || !this.isReturn();
        }
        return false;
    }

    public boolean isValidForMethod(Method m) throws BadMarkupException {
        block5: {
            if ((this.getSourceParam().isThis() || this.getDstParam().isThis()) && m.isStatic()) {
                return false;
            }
            try {
                if (this.getSourceParam().workForArgs(m) && this.getDstParam().workForArgs(m)) {
                    if (this.isReturn() && !VdbProvider.isTaintType(m.getSimpleReturn())) {
                        return false;
                    }
                    break block5;
                }
                return false;
            }
            catch (VDBException e) {
                throw new BadMarkupException(e);
            }
        }
        return true;
    }

    public void setSourceParam(String source_param) throws BadMarkupException {
        this.m_sourceParam = new Parameter(source_param);
    }

    public Parameter getSourceParam() {
        return this.m_sourceParam;
    }

    public void setDstParam(String dst_param) throws BadMarkupException {
        this.m_dstParam = new Parameter(dst_param);
    }

    public Parameter getDstParam() {
        return this.m_dstParam;
    }

    public void setReturn(boolean isRtn) {
        this.m_is_return = isRtn;
    }

    public boolean isReturn() {
        return this.m_is_return;
    }

    public boolean isNotSusceptibleToTaint() {
        return this.getSourceParam().isNone() && this.getDstParam().isNone() && !this.isReturn();
    }

    public boolean canBeMerged(Taint t) {
        return this.isReturn() == t.isReturn() && this.getSourceParam().canBeMerged(t.getSourceParam()) && this.getDstParam().canBeMerged(t.getDstParam());
    }

    public boolean equals(Object o) {
        Taint t;
        return o instanceof Taint && this.compareTo(t = (Taint)o) == 0;
    }

    @Override
    public int compareTo(Taint o) {
        if (this.getSourceParam().compareTo(o.getSourceParam()) != 0) {
            return this.getSourceParam().compareTo(o.getSourceParam());
        }
        if (this.getDstParam().compareTo(o.getDstParam()) != 0) {
            return this.getDstParam().compareTo(o.getDstParam());
        }
        if (this.isReturn() && !o.isReturn()) {
            return 1;
        }
        if (!this.isReturn() && o.isReturn()) {
            return -1;
        }
        return 0;
    }

    public int compareTo(Taint o, Method m) {
        if (this.getSourceParam().toString(m).compareTo(o.getSourceParam().toString(m)) != 0) {
            return this.getSourceParam().compareTo(o.getSourceParam());
        }
        if (this.getDstParam().toString(m).compareTo(o.getDstParam().toString(m)) != 0) {
            return this.getDstParam().compareTo(o.getDstParam());
        }
        if (this.isReturn() && !o.isReturn()) {
            return 1;
        }
        if (!this.isReturn() && o.isReturn()) {
            return -1;
        }
        return 0;
    }

    public boolean isSuperSet(Taint t) {
        if (this.isNotSusceptibleToTaint() && !t.isNotSusceptibleToTaint()) {
            return false;
        }
        if (!this.getSourceParam().isSuperSet(t.getSourceParam())) {
            return false;
        }
        if (!this.getDstParam().isSuperSet(t.getDstParam())) {
            return false;
        }
        return this.isReturn() || !t.isReturn();
    }

    @Override
    public void reset() {
        this.m_sourceParam = null;
        this.m_dstParam = null;
        this.m_is_return = false;
    }

    @Override
    public void replace(VdbArtifact artifact) throws BadMarkupException {
        if (artifact instanceof Taint) {
            Taint t = (Taint)artifact;
            this.setSourceParam(t.getSourceParam().toString());
            this.setDstParam(t.getDstParam().toString());
            this.setReturn(t.isReturn());
        }
    }

    @Override
    public boolean merge(VdbArtifact artifact) throws BadMarkupException {
        boolean _ret = false;
        if (artifact instanceof Taint) {
            Taint t = (Taint)artifact;
            if (this.getSourceParam() == null) {
                this.setSourceParam(t.getSourceParam().toString());
                this.setDstParam(t.getDstParam().toString());
                this.setReturn(t.isReturn());
                _ret = true;
            } else if (this.canBeMerged(t)) {
                this.getDstParam().merge(t.getDstParam());
                this.getSourceParam().merge(t.getSourceParam());
                _ret = true;
            }
        }
        return _ret;
    }

    public String toString() {
        if (this.isNotSusceptibleToTaint()) {
            return "dnp";
        }
        return "TAINT: Source:" + this.getSourceParam().toString() + ", Dest:" + this.getDstParam().toString() + ", Return:" + this.isReturn();
    }

    public String toString(Method m) {
        if (this.isNotSusceptibleToTaint()) {
            return "dnp";
        }
        return "TAINT: Source:" + this.getSourceParam().toString(m) + ", Dest:" + this.getDstParam().toString(m) + ", Return:" + this.isReturn();
    }
}

