/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.method.markup.valid;

import com.ibm.appscan.vdb.VdbArtifact;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.method.markup.MarkupBase;
import com.ibm.appscan.vdb.method.markup.valid.DescriptorSink;
import com.ibm.appscan.vdb.misc.VDBConstants;
import java.util.regex.Matcher;

public abstract class DescriptorSignatureBase
extends MarkupBase
implements Comparable<DescriptorSignatureBase> {
    private Matcher m_matcher;
    private String m_signature;

    public void setSignature(String sig) throws BadMarkupException {
        this.m_matcher = VDBConstants.SIGNATURE_PATTERN.matcher(sig);
        if (!this.m_matcher.matches()) {
            throw new BadMarkupException("The signaturefor the descriptor sink must follow the format sig(args):return", new Object[0]);
        }
        this.m_signature = sig;
    }

    public String getSignature() {
        return this.m_signature;
    }

    @Override
    public void reset() {
        this.m_signature = null;
    }

    @Override
    public void replace(VdbArtifact artifact) throws BadMarkupException {
        if (artifact instanceof DescriptorSink) {
            DescriptorSink s = (DescriptorSink)artifact;
            this.setSignature(s.getSignature());
        }
    }

    @Override
    public boolean isValid() throws BadMarkupException {
        this.m_matcher = VDBConstants.SIGNATURE_PATTERN.matcher(this.getSignature());
        return this.m_matcher.matches();
    }

    @Override
    public int compareTo(DescriptorSignatureBase o) {
        return this.getSignature().compareToIgnoreCase(o.getSignature());
    }

    public boolean equals(Object obj) {
        DescriptorSignatureBase s = (DescriptorSignatureBase)obj;
        return this.compareTo(s) == 0;
    }

    @Override
    public boolean merge(VdbArtifact artifact) throws BadMarkupException {
        return false;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.getSignature());
        return ret.toString();
    }
}

