/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.provider;

import com.ibm.appscan.assessment.model.Finding;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.vdb.cache.BaseVdbCache;
import com.ibm.appscan.vdb.cache.CacheProvider;
import com.ibm.appscan.vdb.data.Vdb;
import com.ibm.appscan.vdb.data.VdbClass;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.method.ValidationRoutine;
import com.ibm.appscan.vdb.method.markup.Property;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.provider.QueryRuleProvider;
import com.ibm.appscan.vdb.provider.RuleProvider;
import com.ibm.appscan.vdb.provider.data.AuditListProvider;
import com.ibm.appscan.vdb.provider.data.DataProvider;
import com.ibm.appscan.vdb.provider.data.file.CPPDataProvider;
import com.ibm.appscan.vdb.provider.data.file.DotNetFileDataProvider;
import com.ibm.appscan.vdb.provider.data.file.FileAuditListProvider;
import com.ibm.appscan.vdb.provider.data.file.FileDataProvider;
import com.ibm.appscan.vdb.provider.data.file.PhpFileDataProvider;
import com.ibm.appscan.vdb.provider.data.file.load.VdbReader;
import com.ibm.appscan.vdb.provider.method.MethodProvider;
import com.ibm.appscan.vdb.provider.method.audit.AuditProvider;
import com.ibm.appscan.vdb.provider.property.BasePropertyProvider;
import com.ibm.appscan.vdb.provider.property.PropertyFilterProvider;
import com.ibm.appscan.vdb.provider.property.RestPropertyProvider;
import com.ibm.appscan.vdb.provider.property.VdbPropertyProvider;
import com.ibm.appscan.vdb.provider.rest.BaseMarkupRestClient;
import com.ibm.appscan.vdb.provider.rest.RestProvider;
import com.ibm.security.annotation.SuppressSecurityTrace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Set;

public class VdbProvider {
    private static VdbProvider s_vdb_provider = new VdbProvider();
    private HashMap<Language.LANGUAGE, DataProvider> s_data_providers = new HashMap();
    private HashMap<Language.LANGUAGE, AuditListProvider> s_audit_list_providers = new HashMap();
    private HashMap<Language.LANGUAGE, RuleProvider> s_rule_providers = new HashMap();
    private HashMap<Language.LANGUAGE, RuleProvider> s_query_rule_providers = new HashMap();
    private HashMap<Language.LANGUAGE, AuditProvider> s_audit_providers = new HashMap();
    private boolean m_is_rest = false;
    private BasePropertyProvider m_file_property_provider;
    private BasePropertyProvider m_rest_property_provider;
    private PropertyFilterProvider m_property_filter_provider;
    private HashMap<String, String> m_string_types;
    private HashMap<String, String> m_number_types;
    private HashMap<String, String> m_boolean_types;
    private HashMap<String, String> m_void_types;
    private HashMap<String, String> m_url_types;
    private HashMap<String, String> m_time_date_types;
    private HashMap<String, String> m_byte_types;
    private HashMap<String, String> m_object_types;
    private HashMap<String, String> m_thread_types;
    private HashMap<String, String> m_list_types;
    private HashMap<String, String> m_getter_types;
    private HashMap<String, String> m_setter_types;
    private HashMap<String, String> m_char_to_remove_types;
    private HashMap<String, String> m_string_to_remove_types;
    private HashMap<String, String> m_stream_types;

    private VdbProvider() {
    }

    private static VdbProvider getInstance() {
        if (s_vdb_provider == null) {
            throw new RuntimeException("Singleton instance not available");
        }
        return s_vdb_provider;
    }

    private static BaseVdbCache getCache(VDBEnums.BUCKET b, Language.LANGUAGE lang) {
        return CacheProvider.getCache(lang, b);
    }

    private static BaseMarkupRestClient getRestClient(VDBEnums.BUCKET b, Language.LANGUAGE lang) {
        if (b == VDBEnums.BUCKET.FACTORY) {
            return RestProvider.getFactoryRestClient(lang);
        }
        if (b == VDBEnums.BUCKET.AUTO) {
            return RestProvider.getAutoRestClient(lang);
        }
        if (b == VDBEnums.BUCKET.IGNORE) {
            return RestProvider.getIgnoreRestClient(lang);
        }
        if (b == VDBEnums.BUCKET.MERGE) {
            return RestProvider.getMergeRestClient(lang);
        }
        if (b == VDBEnums.BUCKET.MISSING) {
            return RestProvider.getMissingRestClient(lang);
        }
        return RestProvider.getNewRestClient(lang);
    }

    public static void saveVdb(Vdb v) throws VDBGeneralException {
        VdbProvider.saveVdb(v, VDBEnums.BUCKET.FACTORY);
    }

    public static void saveVdb(Vdb v, VDBEnums.BUCKET b) throws VDBGeneralException {
        if (VdbProvider.getInstance().m_is_rest) {
            VdbProvider.getRestClient(b, v.getLang()).uploadVdb(v);
        } else {
            VdbProvider.getCache(b, v.getLang()).saveVdb(v);
        }
    }

    public static void saveVdb(Vdb v, File f) throws VDBGeneralException {
        VdbProvider.getCache(VDBEnums.BUCKET.FACTORY, v.getLang()).getMethodProvider().saveSingleVdb(v, f);
    }

    public static void addMethod(Method m) throws VDBGeneralException {
        VdbProvider.addMethod(m, VDBEnums.BUCKET.FACTORY);
    }

    public static void forceClear() {
        s_vdb_provider = new VdbProvider();
    }

    public static void addMethod(Method m, VDBEnums.BUCKET b) throws VDBGeneralException {
        Vdb v = new Vdb(m.getLang());
        try {
            v.addMethod(m);
        }
        catch (BadMarkupException e) {
            throw new VDBGeneralException(e);
        }
        VdbProvider.saveVdb(v, b);
    }

    public static void addClass(VdbClass c) throws VDBGeneralException {
        VdbProvider.addClass(c, VDBEnums.BUCKET.FACTORY);
    }

    public static void addClass(VdbClass c, VDBEnums.BUCKET b) throws VDBGeneralException {
        Vdb v = new Vdb(c.getLang());
        try {
            v.addClassVdb(c);
        }
        catch (BadMarkupException e) {
            throw new VDBGeneralException(e);
        }
        VdbProvider.saveVdb(v, b);
    }

    public static boolean deleteMethod(Method m) throws VDBGeneralException {
        return VdbProvider.deleteMethod(m, VDBEnums.BUCKET.FACTORY);
    }

    public static boolean deleteMethod(Method m, VDBEnums.BUCKET b) throws VDBGeneralException {
        if (VdbProvider.getInstance().m_is_rest) {
            return VdbProvider.getRestClient(b, m.getLang()).deleteMethod(m);
        }
        return VdbProvider.getCache(b, m.getLang()).deleteMethod(m);
    }

    public static Vdb getPackageVdb(Language.LANGUAGE lang, String package_name) throws VDBGeneralException {
        return VdbProvider.getPackageVdb(lang, package_name, VDBEnums.BUCKET.FACTORY);
    }

    public static Vdb getPackageVdb(Language.LANGUAGE lang, String package_name, VDBEnums.BUCKET b) throws VDBGeneralException {
        if (VdbProvider.getInstance().m_is_rest) {
            return VdbProvider.getRestClient(b, lang).getPackageVdb(package_name);
        }
        return VdbProvider.getCache(b, lang).getVdb(package_name);
    }

    public static Vdb getNonClassFuncsVdb(Language.LANGUAGE lang) throws VDBGeneralException {
        return VdbProvider.getNonClassFuncsVdb(lang, VDBEnums.BUCKET.FACTORY);
    }

    public static Vdb getNonClassFuncsVdb(Language.LANGUAGE lang, VDBEnums.BUCKET b) throws VDBGeneralException {
        if (VdbProvider.getInstance().m_is_rest) {
            return VdbProvider.getRestClient(b, lang).getNonClassFuncsVdb();
        }
        return VdbProvider.getCache(b, lang).getNonClassFuncsVdb();
    }

    public static Vdb getMethod(String package_name, String method_name, Language.LANGUAGE lang) throws VDBGeneralException {
        return VdbProvider.getMethod(package_name, method_name, lang, VDBEnums.BUCKET.FACTORY);
    }

    public static Vdb getMethod(String package_name, String method_name, Language.LANGUAGE lang, VDBEnums.BUCKET b) throws VDBGeneralException {
        if (VdbProvider.getInstance().m_is_rest) {
            return VdbProvider.getRestClient(b, lang).getMethod(package_name, method_name);
        }
        Vdb v = new Vdb(lang);
        Method m = VdbProvider.getCache(b, lang).getVdb(package_name).getMethod(method_name);
        if (m != null) {
            try {
                v.addMethod(m);
            }
            catch (BadMarkupException e) {
                throw new VDBGeneralException(e);
            }
            return v;
        }
        return null;
    }

    public static boolean isNumeric(String param) {
        if (!Character.isDigit(param.charAt(0)) && param.charAt(0) != '-') {
            return false;
        }
        for (char c : param.substring(1).toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static void clearBucket(VDBEnums.BUCKET b) throws VDBGeneralException {
        for (Language.LANGUAGE l : Language.LANGUAGE.values()) {
            VdbProvider.getCache(b, l).clearLists();
            VdbProvider.getDataProvider(l).clearBucket(b);
        }
    }

    @SuppressSecurityTrace
    public static String getString(String text, Object ... params) {
        String result = null;
        try {
            result = MessageFormat.format(text, params);
        }
        catch (IllegalArgumentException iae) {
            return text;
        }
        return result;
    }

    public static DataProvider getDataProvider(Language.LANGUAGE language) {
        VdbProvider.getInstance();
        if (!VdbProvider.getInstance().s_data_providers.containsKey(language)) {
            if (language == Language.LANGUAGE.DOT_NET) {
                VdbProvider.getInstance().s_data_providers.put(language, new DotNetFileDataProvider());
            } else if (language == Language.LANGUAGE.PHP) {
                VdbProvider.getInstance().s_data_providers.put(language, new PhpFileDataProvider());
            } else if (language == Language.LANGUAGE.C_PLUS_PLUS) {
                VdbProvider.getInstance().s_data_providers.put(language, new CPPDataProvider());
            } else {
                VdbProvider.getInstance().s_data_providers.put(language, new FileDataProvider(language));
            }
        }
        return VdbProvider.getInstance().s_data_providers.get(language);
    }

    public static AuditListProvider getAuditListProvider(Language.LANGUAGE language) {
        VdbProvider.getInstance();
        if (!VdbProvider.getInstance().s_audit_list_providers.containsKey(language)) {
            VdbProvider.getInstance().s_audit_list_providers.put(language, new FileAuditListProvider(language));
        }
        return VdbProvider.getInstance().s_audit_list_providers.get(language);
    }

    public static RuleProvider getRuleProvider(Language.LANGUAGE language) {
        VdbProvider.getInstance();
        if (!VdbProvider.getInstance().s_rule_providers.containsKey(language)) {
            VdbProvider.getInstance().s_rule_providers.put(language, new RuleProvider(language));
        }
        return VdbProvider.getInstance().s_rule_providers.get(language);
    }

    public static RuleProvider getQuerRuleProvider(Language.LANGUAGE language) {
        VdbProvider.getInstance();
        if (!VdbProvider.getInstance().s_query_rule_providers.containsKey(language)) {
            VdbProvider.getInstance().s_query_rule_providers.put(language, new QueryRuleProvider(language));
        }
        return VdbProvider.getInstance().s_query_rule_providers.get(language);
    }

    public static void setRestMode(boolean enabled) {
        VdbProvider.getInstance().m_is_rest = enabled;
    }

    public static BasePropertyProvider getPropertyProvider() throws VDBGeneralException {
        if (VdbProvider.getInstance().m_is_rest) {
            if (VdbProvider.getInstance().m_rest_property_provider == null) {
                VdbProvider.getInstance().m_rest_property_provider = new RestPropertyProvider();
            }
            return VdbProvider.getInstance().m_rest_property_provider;
        }
        if (VdbProvider.getInstance().m_file_property_provider == null) {
            VdbProvider.getInstance().m_file_property_provider = new VdbPropertyProvider();
        }
        return VdbProvider.getInstance().m_file_property_provider;
    }

    public static PropertyFilterProvider getPropertyFilterProvider(File file) throws VDBGeneralException {
        if (VdbProvider.getInstance().m_property_filter_provider == null) {
            VdbProvider.getInstance().m_property_filter_provider = new PropertyFilterProvider(file);
        }
        return VdbProvider.getInstance().m_property_filter_provider;
    }

    public static AuditProvider getAuditMethodProvider(Language.LANGUAGE language) {
        VdbProvider.getInstance();
        if (!VdbProvider.getInstance().s_audit_providers.containsKey(language)) {
            VdbProvider.getInstance().s_audit_providers.put(language, new AuditProvider(language));
        }
        return VdbProvider.getInstance().s_audit_providers.get(language);
    }

    public static Vdb getVdbFromVdb(Vdb v) throws VDBGeneralException {
        if (VdbProvider.getInstance().m_is_rest) {
            return RestProvider.getFactoryRestClient(v.getLang()).getVdbFromVdb(v);
        }
        Vdb ret = CacheProvider.getCache(v.getLang(), VDBEnums.BUCKET.FACTORY).getVdbFromVdb(v);
        if (ret.getLang() == Language.LANGUAGE.C_PLUS_PLUS) {
            ret = VdbProvider.mergeSecondaryLanguage(ret, Language.LANGUAGE.DOT_NET);
        }
        if (ret.getLang() == Language.LANGUAGE.DOT_NET) {
            ret = VdbProvider.mergeSecondaryLanguage(ret, Language.LANGUAGE.C_PLUS_PLUS);
        }
        return ret;
    }

    private static Vdb mergeSecondaryLanguage(Vdb v, Language.LANGUAGE alternate) throws VDBGeneralException {
        try {
            Vdb net = new Vdb(alternate);
            for (Method m : v.getMethods()) {
                if (m.isMarkedUp()) continue;
                Method temp = MethodProvider.getMethod(m.getSignature(), alternate);
                net.addMethod(temp);
                for (Property p : m.getAllProperties()) {
                    temp.addProperty(p);
                }
            }
            net = VdbProvider.getInstance().m_is_rest ? RestProvider.getFactoryRestClient(alternate).getVdbFromVdb(v) : CacheProvider.getCache(alternate, VDBEnums.BUCKET.FACTORY).getVdbFromVdb(net);
            for (Method m : net.getMethods()) {
                Method vdb_m = v.getMethod(m.getSignature());
                if (vdb_m == null || !m.isMarkedUp()) continue;
                vdb_m.merge(m);
            }
        }
        catch (Exception e) {
            throw new VDBGeneralException(e);
        }
        return v;
    }

    public static Method getAutomaticCallbackSourceMethod(Language.LANGUAGE lang) throws VDBException {
        return VdbProvider.getSingleMethod("<automatic_callback_source>(...):void", lang);
    }

    public static Method getExternalSourceMethod(Language.LANGUAGE lang) throws VDBException {
        return VdbProvider.getSingleMethod("<external_source>(...):void", lang);
    }

    public static String getExternalCallerSignature(Language.LANGUAGE lang) {
        return "<external_caller>():void";
    }

    public static Method getExternalTaintMethod(Language.LANGUAGE lang) throws VDBException {
        if (lang == Language.LANGUAGE.JAVA) {
            return VdbProvider.getSingleMethod("<external_taint>(...):java.lang.String", lang);
        }
        if (lang == Language.LANGUAGE.C_PLUS_PLUS) {
            return VdbProvider.getSingleMethod("<external_taint>(...):LPCSTR", lang);
        }
        if (lang == Language.LANGUAGE.OBJECTIVE_C) {
            return VdbProvider.getSingleMethod("<AppScan>.getClass(char*):objc_class*", lang);
        }
        if (lang == Language.LANGUAGE.PHP) {
            return VdbProvider.getSingleMethod("<external_taint>(...):___Php.String", lang);
        }
        return VdbProvider.getSingleMethod("<external_taint>(...):String", lang);
    }

    public static Method getSingleMethod(String sig, Language.LANGUAGE lang) throws VDBException {
        Vdb ret = VdbProvider.getMethod(lang, sig);
        if (ret.getMethods().size() == 1) {
            return ret.getMethods().get(0);
        }
        return MethodProvider.getMethod(sig, lang);
    }

    public static Vdb getVdb(VDBEnums.BUCKET b, Method m) throws VDBGeneralException {
        return VdbProvider.getVdb(b, m.getLang(), m.getMethodId());
    }

    public static Vdb getVdb(File f) {
        if (f.exists()) {
            try {
                VdbReader r = new VdbReader(new FileInputStream(f));
                r.parse();
                return r.getVdb();
            }
            catch (VDBGeneralException e) {
                e.logException();
            }
            catch (FileNotFoundException e) {
                CommonCore.getLogManager().log(new Message((Throwable)e));
            }
        }
        return null;
    }

    public static Vdb getVdb(VDBEnums.BUCKET b, Language.LANGUAGE lang, String pack) throws VDBGeneralException {
        Vdb ret = null;
        if (VdbProvider.getInstance().m_is_rest) {
            return VdbProvider.getRestClient(b, lang).getPackageVdb(pack);
        }
        ret = VdbProvider.getCache(b, lang).getVdb(pack);
        if (ret == null) {
            VdbProvider.getCache(b, lang).getClassVdb(pack);
        }
        if (ret == null && (ret = VdbProvider.getCache(b, lang).getNonClassFuncsVdb()) != null && ret.getMethod(pack) != null) {
            Vdb ncf = new Vdb(ret.getLang());
            try {
                ncf.addMethod(ret.getMethod(pack));
            }
            catch (BadMarkupException e) {
                throw new VDBGeneralException(e);
            }
            return ncf;
        }
        return ret;
    }

    public static Set<String> getPackages(Language.LANGUAGE lang) throws VDBException {
        return VdbProvider.getPackages(lang, VDBEnums.BUCKET.FACTORY);
    }

    public static Set<String> getPackages(Language.LANGUAGE lang, VDBEnums.BUCKET b) throws VDBException {
        if (VdbProvider.getInstance().m_is_rest) {
            return VdbProvider.getRestClient(b, lang).getPackages();
        }
        return VdbProvider.getCache(b, lang).getPackageList();
    }

    public static HashMap<String, Vdb> getVdbs(VDBEnums.BUCKET b) throws VDBException {
        HashMap<String, Vdb> ret = new HashMap<String, Vdb>();
        for (Language.LANGUAGE l : Language.LANGUAGE.values()) {
            ret.putAll(VdbProvider.getVdbs(l, b));
        }
        return ret;
    }

    public static HashMap<String, Vdb> getVdbs(Language.LANGUAGE l, VDBEnums.BUCKET b) throws VDBException {
        return VdbProvider.getCache(b, l).getVdbs();
    }

    public static Set<String> getClasses(Language.LANGUAGE lang) throws VDBException {
        return VdbProvider.getClasses(lang, VDBEnums.BUCKET.FACTORY);
    }

    public static Set<String> getClasses(Language.LANGUAGE lang, VDBEnums.BUCKET b) throws VDBException {
        if (VdbProvider.getInstance().m_is_rest) {
            return VdbProvider.getRestClient(b, lang).getClasses();
        }
        return CacheProvider.getCache(lang, VDBEnums.BUCKET.FACTORY).getClasses();
    }

    public static Set<String> getMethods(Language.LANGUAGE lang) throws VDBException {
        return VdbProvider.getMethods(lang, VDBEnums.BUCKET.FACTORY);
    }

    @SuppressSecurityTrace
    public static Set<String> getMethods(Language.LANGUAGE lang, VDBEnums.BUCKET b) throws VDBException {
        if (VdbProvider.getInstance().m_is_rest) {
            return VdbProvider.getRestClient(b, lang).getMethods();
        }
        return CacheProvider.getCache(lang, VDBEnums.BUCKET.FACTORY).getMethods();
    }

    public static Set<String> getNonClassFunctions(Language.LANGUAGE lang) throws VDBException {
        return CacheProvider.getCache(lang, VDBEnums.BUCKET.FACTORY).getNonClassFunctionsList();
    }

    public static Set<String> getNonClassFunctions(Language.LANGUAGE lang, VDBEnums.BUCKET b) throws VDBException {
        if (VdbProvider.getInstance().m_is_rest) {
            return VdbProvider.getRestClient(b, lang).getNonClassMethods();
        }
        return CacheProvider.getCache(lang, VDBEnums.BUCKET.FACTORY).getNonClassFunctionsList();
    }

    public static Vdb getVdbFromSignatureLog(Language.LANGUAGE lang, File rules_wizard_file) throws VDBGeneralException {
        return CacheProvider.getCache(lang, VDBEnums.BUCKET.FACTORY).getVdbFromSignatureLog(rules_wizard_file);
    }

    public static String getVdbXml(VDBEnums.BUCKET b, Language.LANGUAGE lang, Vdb ret) throws VDBGeneralException {
        return VdbProvider.getCache(b, lang).getVdbXml(ret);
    }

    public static Vdb getMethod(Language.LANGUAGE lang, String signature) throws VDBException {
        Vdb v = new Vdb(lang);
        Method m = MethodProvider.getMethod(signature, lang);
        v.addMethod(m);
        if (m != null) {
            if (VdbProvider.getInstance().m_is_rest) {
                return VdbProvider.getRestClient(VDBEnums.BUCKET.FACTORY, lang).getVdbFromVdb(v);
            }
            return VdbProvider.getCache(VDBEnums.BUCKET.FACTORY, lang).getVdbFromVdb(v);
        }
        return null;
    }

    public static boolean isTaintType(String arg) throws VDBException {
        return !VdbProvider.isBoolean(arg) && !VdbProvider.isTimeDateType(arg) && !VdbProvider.isVoid(arg);
    }

    public static String getParameterString(Method m) throws VDBException {
        if (VdbProvider.isTaintPossibleArgs(m)) {
            return "default";
        }
        return null;
    }

    public static boolean isTaintPossibleArgs(Method m) throws VDBException {
        for (String arg : m.getArgs()) {
            if (VdbProvider.isBoolean(m.getSimpleArg(arg)) || VdbProvider.isNumber(m.getSimpleArg(arg))) continue;
            return true;
        }
        return false;
    }

    public static boolean isTaintPossibleReturn(Method m) throws VDBException {
        return !VdbProvider.isBoolean(m.getSimpleReturn()) && !VdbProvider.isNumber(m.getSimpleReturn()) && !VdbProvider.isVoid(m.getSimpleReturn());
    }

    public static boolean isTaintPossible(Method m) throws VDBException {
        if (VdbProvider.isTaintPossibleArgs(m)) {
            return true;
        }
        return VdbProvider.isTaintPossibleReturn(m);
    }

    public static boolean isString(String arg) throws VDBException {
        if (VdbProvider.getInstance().m_string_types == null) {
            VdbProvider.getInstance().m_string_types = new HashMap();
            try {
                VdbProvider.copyFileToHash(new File(CommonCore.getDirectoryLocator().getVdb(), "string.types"), VdbProvider.getInstance().m_string_types);
            }
            catch (IOException e) {
                throw new VDBException(e);
            }
        }
        return VdbProvider.getInstance().m_string_types.containsKey(arg.toLowerCase());
    }

    public static boolean isNumber(String arg) throws VDBException {
        if (VdbProvider.getInstance().m_number_types == null) {
            VdbProvider.getInstance().m_number_types = new HashMap();
            try {
                VdbProvider.copyFileToHash(new File(CommonCore.getDirectoryLocator().getVdb(), "number.types"), VdbProvider.getInstance().m_number_types);
            }
            catch (IOException e) {
                throw new VDBException(e);
            }
        }
        return VdbProvider.getInstance().m_number_types.containsKey(arg.toLowerCase());
    }

    public static boolean isBoolean(String arg) throws VDBException {
        if (VdbProvider.getInstance().m_boolean_types == null) {
            VdbProvider.getInstance().m_boolean_types = new HashMap();
            try {
                VdbProvider.copyFileToHash(new File(CommonCore.getDirectoryLocator().getVdb(), "boolean.types"), VdbProvider.getInstance().m_boolean_types);
            }
            catch (IOException e) {
                throw new VDBException(e);
            }
        }
        return VdbProvider.getInstance().m_boolean_types.containsKey(arg.toLowerCase());
    }

    public static boolean isUrl(String arg) throws VDBException {
        if (VdbProvider.getInstance().m_url_types == null) {
            VdbProvider.getInstance().m_url_types = new HashMap();
            try {
                VdbProvider.copyFileToHash(new File(CommonCore.getDirectoryLocator().getVdb(), "url.types"), VdbProvider.getInstance().m_url_types);
            }
            catch (IOException e) {
                throw new VDBException(e);
            }
        }
        return VdbProvider.getInstance().m_url_types.containsKey(arg.toLowerCase());
    }

    public static boolean isVoid(String arg) throws VDBException {
        if (VdbProvider.getInstance().m_void_types == null) {
            VdbProvider.getInstance().m_void_types = new HashMap();
            try {
                VdbProvider.copyFileToHash(new File(CommonCore.getDirectoryLocator().getVdb(), "void.types"), VdbProvider.getInstance().m_void_types);
            }
            catch (IOException e) {
                throw new VDBException(e);
            }
        }
        return VdbProvider.getInstance().m_void_types.containsKey(arg.toLowerCase());
    }

    public static boolean isTimeDateType(String arg) throws VDBException {
        if (VdbProvider.getInstance().m_time_date_types == null) {
            VdbProvider.getInstance().m_time_date_types = new HashMap();
            try {
                VdbProvider.copyFileToHash(new File(CommonCore.getDirectoryLocator().getVdb(), "time.date.types"), VdbProvider.getInstance().m_time_date_types);
            }
            catch (IOException e) {
                throw new VDBException(e);
            }
        }
        return VdbProvider.getInstance().m_time_date_types.containsKey(arg.toLowerCase());
    }

    public static boolean isByteType(String arg) throws VDBException {
        if (VdbProvider.getInstance().m_byte_types == null) {
            VdbProvider.getInstance().m_byte_types = new HashMap();
            try {
                VdbProvider.copyFileToHash(new File(CommonCore.getDirectoryLocator().getVdb(), "byte.types"), VdbProvider.getInstance().m_byte_types);
            }
            catch (IOException e) {
                throw new VDBException(e);
            }
        }
        return VdbProvider.getInstance().m_byte_types.containsKey(arg.toLowerCase());
    }

    public static boolean isObjectType(String arg) throws VDBException {
        if (VdbProvider.getInstance().m_object_types == null) {
            VdbProvider.getInstance().m_object_types = new HashMap();
            try {
                VdbProvider.copyFileToHash(new File(CommonCore.getDirectoryLocator().getVdb(), "object.types"), VdbProvider.getInstance().m_object_types);
            }
            catch (IOException e) {
                throw new VDBException(e);
            }
        }
        return VdbProvider.getInstance().m_object_types.containsKey(arg.toLowerCase().toLowerCase());
    }

    public static boolean isCharToRemove(String arg) throws VDBException {
        if (VdbProvider.getInstance().m_char_to_remove_types == null) {
            VdbProvider.getInstance().m_char_to_remove_types = new HashMap();
            try {
                VdbProvider.copyFileToHash(new File(CommonCore.getDirectoryLocator().getVdb(), "char.to.remove.types"), VdbProvider.getInstance().m_char_to_remove_types);
            }
            catch (IOException e) {
                throw new VDBException(e);
            }
        }
        return VdbProvider.getInstance().m_char_to_remove_types.containsKey(arg.toLowerCase());
    }

    public static boolean isThreadType(String arg) throws VDBException {
        if (VdbProvider.getInstance().m_thread_types == null) {
            VdbProvider.getInstance().m_thread_types = new HashMap();
            try {
                VdbProvider.copyFileToHash(new File(CommonCore.getDirectoryLocator().getVdb(), "thread.types"), VdbProvider.getInstance().m_thread_types);
            }
            catch (IOException e) {
                throw new VDBException(e);
            }
        }
        return VdbProvider.getInstance().m_thread_types.containsKey(arg.toLowerCase());
    }

    public static boolean isListType(String arg) throws VDBException {
        if (VdbProvider.getInstance().m_list_types == null) {
            VdbProvider.getInstance().m_list_types = new HashMap();
            try {
                VdbProvider.copyFileToHash(new File(CommonCore.getDirectoryLocator().getVdb(), "list.types"), VdbProvider.getInstance().m_list_types);
            }
            catch (IOException e) {
                throw new VDBException(e);
            }
        }
        return VdbProvider.getInstance().m_list_types.containsKey(arg.toLowerCase());
    }

    public static boolean isGetterType(Method m) throws VDBException {
        if (VdbProvider.getInstance().m_getter_types == null) {
            VdbProvider.getInstance().m_getter_types = new HashMap();
            try {
                VdbProvider.copyFileToHash(new File(CommonCore.getDirectoryLocator().getVdb(), "getter.types"), VdbProvider.getInstance().m_getter_types);
            }
            catch (IOException e) {
                throw new VDBException(e);
            }
        }
        for (String type : VdbProvider.getInstance().m_getter_types.keySet()) {
            if (!m.getMethodName().startsWith(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSetterType(Method m) throws VDBException {
        if (VdbProvider.getInstance().m_setter_types == null) {
            VdbProvider.getInstance().m_setter_types = new HashMap();
            try {
                VdbProvider.copyFileToHash(new File(CommonCore.getDirectoryLocator().getVdb(), "setter.types"), VdbProvider.getInstance().m_setter_types);
            }
            catch (IOException e) {
                throw new VDBException(e);
            }
        }
        for (String type : VdbProvider.getInstance().m_setter_types.keySet()) {
            if (!m.getMethodName().startsWith(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStreamType(String arg) throws VDBException {
        if (VdbProvider.getInstance().m_stream_types == null) {
            VdbProvider.getInstance().m_stream_types = new HashMap();
            try {
                VdbProvider.copyFileToHash(new File(CommonCore.getDirectoryLocator().getVdb(), "stream.types"), VdbProvider.getInstance().m_stream_types);
            }
            catch (IOException e) {
                throw new VDBException(e);
            }
        }
        return VdbProvider.getInstance().m_stream_types.containsKey(arg.toLowerCase());
    }

    public static Set<String> getStringsToRemove() throws VDBException {
        if (VdbProvider.getInstance().m_string_to_remove_types == null) {
            VdbProvider.getInstance().m_string_to_remove_types = new HashMap();
            try {
                VdbProvider.copyFileToHash(new File(CommonCore.getDirectoryLocator().getVdb(), "string.to.remove.types"), VdbProvider.getInstance().m_string_to_remove_types);
            }
            catch (IOException e) {
                throw new VDBException(e);
            }
        }
        return VdbProvider.getInstance().m_string_to_remove_types.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFileToHash(File f, HashMap<String, String> map) throws IOException {
        if (f.exists()) {
            try (BufferedReader br = null;){
                br = new BufferedReader(new FileReader(f));
                String line = br.readLine();
                while (line != null) {
                    map.put(line.toLowerCase(), line.toLowerCase());
                    line = br.readLine();
                }
            }
        }
    }

    public static boolean findingIsValidated(Finding finding) throws VDBException {
        if (finding.getTrace() == null) {
            return false;
        }
        for (String api : finding.getApisInTrace()) {
            if (VdbProvider.getValidationRoutinesForLanguage(finding.getLanguage()).get(api) == null || VdbProvider.getValidationRoutinesForLanguage(finding.getLanguage()).get(api) == null || !VdbProvider.getValidationRoutinesForLanguage(finding.getLanguage()).get(api).validatesFinding(finding)) continue;
            return true;
        }
        return false;
    }

    public static HashMap<String, ValidationRoutine> getValidationRoutinesForLanguage(Language.LANGUAGE lang) {
        return VdbProvider.getDataProvider(lang).getValidationRoutines();
    }
}

