/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.rule;

import com.ibm.appscan.vdb.exception.BadRuleException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.rule.AndRule;
import com.ibm.appscan.vdb.rule.ApplyRule;
import com.ibm.appscan.vdb.rule.BaseLogicGate;
import com.ibm.appscan.vdb.rule.BaseRule;
import com.ibm.appscan.vdb.rule.BaseRuleMember;
import com.ibm.appscan.vdb.rule.OrRule;
import com.ibm.appscan.vdb.rule.SearchRule;
import com.ibm.appscan.vdb.rule.method.CallBackRule;
import com.ibm.appscan.vdb.rule.method.MethodRule;
import com.ibm.appscan.vdb.rule.method.ao.ActionObjectRule;
import com.ibm.appscan.vdb.rule.method.ao.option.OptionRule;
import com.ibm.appscan.vdb.rule.method.properties.PropertyRule;
import com.ibm.appscan.vdb.rule.method.taint.TaintRule;
import com.ibm.appscan.vdb.rule.special_cases.SpecialCaseRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;

public class Rule
extends BaseRule {
    private VDBEnums.RULE_TYPE m_type = VDBEnums.RULE_TYPE.GENERAL;
    private ArrayList<SearchRule> m_searchGroups;
    private ArrayList<ApplyRule> m_applyGroups;
    private HashMap<String, BaseLogicGate> m_gates = new HashMap();
    private PropertyRule m_property;
    private MethodRule m_method_rule;
    private ActionObjectRule m_ao_rule;
    private OptionRule m_optionBasedTester;
    private TaintRule m_taint_rule;
    private SpecialCaseRule m_special_case;
    private CallBackRule m_call_back;

    public Rule() {
        this.setRuleName(null);
    }

    public Rule(String name) {
        super(name);
    }

    public boolean isMatch(Method m) {
        for (SearchRule g : this.getSearchGroups()) {
            if (!g.isSearchValid() || g.isMatch(m)) continue;
            return false;
        }
        for (BaseLogicGate gate : this.m_gates.values()) {
            if (gate.isMatch(m)) continue;
            return false;
        }
        return true;
    }

    public BaseLogicGate createLogicGate(VDBEnums.RULE_GATE_TYPE type) {
        return this.createLogicGate(null, type);
    }

    public BaseLogicGate createLogicGate(String name, VDBEnums.RULE_GATE_TYPE type) {
        BaseLogicGate gate = type == VDBEnums.RULE_GATE_TYPE.AND ? new AndRule() : new OrRule();
        gate.setRuleName(name);
        if (this.m_gates.containsKey(gate.getRuleName())) {
            gate.setRuleName(gate.getRuleName() + "_" + UUID.randomUUID().toString());
        }
        this.m_gates.put(gate.getRuleName(), gate);
        return gate;
    }

    public boolean isValid() {
        for (SearchRule g : this.getSearchGroups()) {
            if (!g.isSearchValid()) continue;
            return true;
        }
        Iterator<Comparable<BaseRuleMember>> iterator = this.m_gates.values().iterator();
        if (iterator.hasNext()) {
            BaseLogicGate gate = (BaseLogicGate)iterator.next();
            return gate.isValid();
        }
        return false;
    }

    public BaseLogicGate getGate(String name) {
        return this.m_gates.get(name);
    }

    public Collection<BaseLogicGate> getGates() {
        return this.m_gates.values();
    }

    public boolean removeGate(String name) {
        if (this.m_gates.containsKey(name)) {
            this.m_gates.remove(name);
            return true;
        }
        return false;
    }

    public boolean applyRule(Method m) throws BadRuleException {
        boolean changed = false;
        for (ApplyRule g : this.getApplyGroups()) {
            if (!g.isRuleValid() || !g.applyRule(m)) continue;
            changed = true;
        }
        for (BaseLogicGate gate : this.m_gates.values()) {
            if (!gate.applyRule(m)) continue;
            changed = true;
        }
        if (changed && this.addAutoApplyRule()) {
            m.addRule(this);
        }
        return changed;
    }

    protected boolean addAutoApplyRule() {
        return false;
    }

    private ArrayList<SearchRule> getSearchGroups() {
        if (this.m_searchGroups == null) {
            this.m_searchGroups = new ArrayList();
        }
        return this.m_searchGroups;
    }

    protected ArrayList<ApplyRule> getApplyGroups() {
        if (this.m_applyGroups == null) {
            this.m_applyGroups = new ArrayList();
        }
        return this.m_applyGroups;
    }

    public MethodRule getMethodRule() {
        if (this.m_method_rule == null) {
            this.m_method_rule = new MethodRule();
            this.getSearchGroups().add(this.m_method_rule);
        }
        return this.m_method_rule;
    }

    public ActionObjectRule getActionObjectRule() {
        if (this.m_ao_rule == null) {
            this.m_ao_rule = this.getAoRuleType();
            if (this.addApplyToSearch()) {
                this.getSearchGroups().add(this.m_ao_rule);
            }
            this.getApplyGroups().add(this.m_ao_rule);
        }
        return this.m_ao_rule;
    }

    protected ActionObjectRule getAoRuleType() {
        return new ActionObjectRule();
    }

    public OptionRule getOptionRule() {
        if (this.m_optionBasedTester == null) {
            this.m_optionBasedTester = this.getOptionRuleType();
            if (this.addApplyToSearch()) {
                this.getSearchGroups().add(this.m_optionBasedTester);
            }
            this.getApplyGroups().add(this.m_optionBasedTester);
        }
        return this.m_optionBasedTester;
    }

    protected OptionRule getOptionRuleType() {
        return new OptionRule();
    }

    public PropertyRule getPropertyRule() {
        if (this.m_property == null) {
            this.m_property = this.getPropertyRuleType();
            if (this.addApplyToSearch()) {
                this.getSearchGroups().add(this.m_property);
            }
            this.getApplyGroups().add(this.m_property);
        }
        return this.m_property;
    }

    protected PropertyRule getPropertyRuleType() {
        return new PropertyRule();
    }

    public TaintRule getTaintRule() {
        if (this.m_taint_rule == null) {
            this.m_taint_rule = this.getTaintRuleType();
            if (this.addApplyToSearch()) {
                this.getSearchGroups().add(this.m_taint_rule);
            }
            this.getApplyGroups().add(this.m_taint_rule);
        }
        return this.m_taint_rule;
    }

    protected TaintRule getTaintRuleType() {
        return new TaintRule();
    }

    public SpecialCaseRule getSpecialCaseRule() {
        if (this.m_special_case == null) {
            this.m_special_case = new SpecialCaseRule();
            this.getSearchGroups().add(this.m_special_case);
        }
        return this.m_special_case;
    }

    public CallBackRule getCallBackRule() {
        if (this.m_call_back == null) {
            this.m_call_back = this.getCallBackRuleType();
            if (this.addApplyToSearch()) {
                this.getSearchGroups().add(this.m_call_back);
            }
            this.getApplyGroups().add(this.m_call_back);
        }
        return this.m_call_back;
    }

    protected CallBackRule getCallBackRuleType() {
        return new CallBackRule();
    }

    public String getDetailsText() {
        StringBuilder str = new StringBuilder();
        str.append(this.getRuleName() + ":");
        for (SearchRule searchRule : this.getSearchGroups()) {
            str.append(searchRule.getDetailsText());
        }
        for (SearchRule searchRule : this.getApplyGroups()) {
            str.append(searchRule.getDetailsText());
        }
        for (BaseLogicGate baseLogicGate : this.getGates()) {
            str.append(baseLogicGate.getDetailText());
        }
        return str.toString();
    }

    public boolean isDelete() {
        return false;
    }

    public void setType(VDBEnums.RULE_TYPE type) {
        this.m_type = type;
    }

    public VDBEnums.RULE_TYPE getType() {
        return this.m_type;
    }

    protected boolean addApplyToSearch() {
        return false;
    }
}

