/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.rule.method.ao;

import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.BadRuleException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.method.markup.ao.ActionObject;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.provider.EnumProvider;
import com.ibm.appscan.vdb.rule.ApplyRule;
import com.ibm.appscan.vdb.rule.method.ao.AoTypeRule;
import com.ibm.appscan.vdb.rule.method.ao.ParameterRule;
import com.ibm.appscan.vdb.rule.method.ao.ReturnRule;
import com.ibm.appscan.vdb.rule.method.ao.SeverityRule;
import com.ibm.appscan.vdb.rule.method.ao.VulnerabilityRule;

public class ActionObjectRule
extends ApplyRule {
    private SeverityRule m_sev;
    private AoTypeRule m_type;
    private VulnerabilityRule m_vuln;
    private ParameterRule m_parameter;
    private ReturnRule m_return;

    @Override
    public boolean isRuleValid() {
        return this.getAoTypeRule().isRuleValid() || this.getVulnRule().isRuleValid() || this.getSevRule().isRuleValid() || this.getParameterRule().isRuleValid() || this.getReturnRule().isRuleValid();
    }

    protected ActionObject getRuleActionObject() throws BadRuleException {
        try {
            ActionObject ao = new ActionObject();
            ao.setAoType(this.getAoTypeRule().getAoType());
            ao.setVulnerability(this.getVulnRule().getRuleValue());
            ao.setSeverity(this.getSevRule().getSeverity());
            if (this.getParameterRule().isRuleValid()) {
                ao.setParam(this.getParameterRule().getRuleValue());
            }
            if (this.isReturn()) {
                ao.setReturn(this.isReturn());
            }
            ao.isValid();
            return ao;
        }
        catch (BadMarkupException e) {
            throw new BadRuleException(e);
        }
    }

    @Override
    public boolean applyRule(Method m) throws BadRuleException {
        try {
            return this.performApply(m, this.getRuleActionObject());
        }
        catch (BadMarkupException e) {
            return false;
        }
    }

    public void setSeverity(VDBEnums.SEVERITY sev) throws BadRuleException {
        this.getSevRule().setSeverity(sev);
    }

    public VDBEnums.SEVERITY getSeverity() {
        if (this.getSevRule().isRuleValid()) {
            return this.getSevRule().getSeverity();
        }
        return VDBEnums.SEVERITY.DEFAULT;
    }

    public void setAoType(VDBEnums.AO_TYPE type) throws BadRuleException {
        this.getAoTypeRule().setAoType(type);
    }

    public VDBEnums.AO_TYPE getAoType() {
        if (this.getAoTypeRule().isRuleValid()) {
            return this.getAoTypeRule().getAoType();
        }
        return VDBEnums.AO_TYPE.DEFAULT;
    }

    public void setVulnerability(String vuln) throws BadRuleException {
        this.getVulnRule().setRuleValue(vuln);
    }

    public String getVulnerability() {
        return this.getVulnRule().getRuleValue();
    }

    public void setParameter(String param) throws BadRuleException {
        this.getParameterRule().setRuleValue(param);
    }

    public String getParameter() {
        return this.getParameterRule().getRuleValue();
    }

    public void setReturn(boolean isReturn) throws BadRuleException {
        this.getReturnRule().setReturnValue(isReturn);
    }

    public boolean isReturn() {
        return this.getReturnRule().isReturnValue();
    }

    protected boolean performApply(Method m, ActionObject ao) throws BadMarkupException {
        return m.addActionObject(ao);
    }

    @Override
    public String getDetailName() {
        return "Action Object";
    }

    public SeverityRule getSevRule() {
        if (this.m_sev == null) {
            this.m_sev = new SeverityRule();
            this.addBaseRule(this.m_sev);
        }
        return this.m_sev;
    }

    public AoTypeRule getAoTypeRule() {
        if (this.m_type == null) {
            this.m_type = new AoTypeRule();
            this.addBaseRule(this.m_type);
        }
        return this.m_type;
    }

    public VulnerabilityRule getVulnRule() {
        if (this.m_vuln == null) {
            this.m_vuln = new VulnerabilityRule();
            this.addBaseRule(this.m_vuln);
        }
        return this.m_vuln;
    }

    public ParameterRule getParameterRule() {
        if (this.m_parameter == null) {
            this.m_parameter = new ParameterRule();
            this.addBaseRule(this.m_parameter);
        }
        return this.m_parameter;
    }

    public ReturnRule getReturnRule() {
        if (this.m_return == null) {
            this.m_return = new ReturnRule();
            this.addBaseRule(this.m_return);
        }
        return this.m_return;
    }

    @Override
    public boolean allowsContains() {
        return false;
    }

    protected boolean isBasicSearch() {
        return this.getAoTypeRule().isRuleValid() || this.getSevRule().isRuleValid() || this.getVulnRule().isRuleValid() || this.getParameterRule().isRuleValid() || this.getReturnRule().isRuleValid();
    }

    @Override
    protected boolean searchRule(Method m) {
        if (m.getAllActionObjects().size() == 0) {
            return false;
        }
        for (ActionObject ao : m.getAllActionObjects()) {
            if (!this.checkAo(ao)) continue;
            return true;
        }
        return false;
    }

    protected boolean checkAo(ActionObject ao) {
        boolean _ret = false;
        if (this.getAoTypeRule().isRuleValid()) {
            if (this.getAoTypeRule().checkActionObjectValues(this.getRuleOperator(), ao)) {
                _ret = true;
            } else {
                return false;
            }
        }
        if (this.getSevRule().isRuleValid()) {
            if (this.getSevRule().checkActionObjectValues(this.getRuleOperator(), ao)) {
                _ret = true;
            } else {
                return false;
            }
        }
        if (this.getVulnRule().isRuleValid()) {
            if (this.getVulnRule().checkActionObjectValues(this.getRuleOperator(), ao)) {
                _ret = true;
            } else {
                return false;
            }
        }
        if (this.getParameterRule().isRuleValid()) {
            if (this.getParameterRule().checkActionObjectValues(this.getRuleOperator(), ao)) {
                _ret = true;
            } else {
                return false;
            }
        }
        if (this.getReturnRule().isRuleValid()) {
            if (this.getReturnRule().checkActionObjectValues(this.getRuleOperator(), ao)) {
                _ret = true;
            } else {
                return false;
            }
        }
        if (_ret) {
            return true;
        }
        return _ret;
    }

    public void setAoType(String text) throws BadRuleException {
        this.setAoType(EnumProvider.getAoType(text));
    }

    public void setSeverity(String text) throws BadRuleException {
        this.setSeverity(EnumProvider.getSeverity(text));
    }
}

