/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.rule.method.taint;

import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.BadRuleException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.method.markup.Taint;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.rule.ApplyRule;
import com.ibm.appscan.vdb.rule.method.taint.DestinationParameter;
import com.ibm.appscan.vdb.rule.method.taint.ReturnValue;
import com.ibm.appscan.vdb.rule.method.taint.SourceParameter;

public class TaintRule
extends ApplyRule {
    private SourceParameter m_source;
    private DestinationParameter m_dst;
    private ReturnValue m_rtn;

    @Override
    public boolean isSearchValid() {
        return this.getRuleOperator() != VDBEnums.RULE_OPERATOR.NULL && (this.getDst().isRuleValid() || this.getSource().isRuleValid() || this.getReturnRule().isRuleValid());
    }

    @Override
    public boolean searchRule(Method m) {
        if (this.getRuleOperator() == VDBEnums.RULE_OPERATOR.NULL) {
            return true;
        }
        for (Taint t : m.getTaints()) {
            boolean _ret = false;
            if (this.getSource().isRuleValid()) {
                if (this.getSource().checkTaint(this.getRuleOperator(), m, t)) {
                    _ret = true;
                } else {
                    return false;
                }
            }
            if (this.getDst().isRuleValid()) {
                if (this.getDst().checkTaint(this.getRuleOperator(), m, t)) {
                    _ret = true;
                } else {
                    return false;
                }
            }
            if (this.getReturnRule().isRuleValid()) {
                if (this.getReturnRule().checkTaint(this.getRuleOperator(), m, t)) {
                    _ret = true;
                } else {
                    return false;
                }
            }
            if (!_ret) continue;
            return _ret;
        }
        return false;
    }

    @Override
    public String getDetailName() {
        return "Taint";
    }

    private DestinationParameter getDst() {
        if (this.m_dst == null) {
            this.m_dst = new DestinationParameter();
            this.addBaseRule(this.m_dst);
        }
        return this.m_dst;
    }

    public void setDestinationParameter(String param) throws BadRuleException {
        this.getDst().setRuleValue(param);
    }

    public String getDestinationParameter() {
        return this.getDst().getRuleValue();
    }

    private SourceParameter getSource() {
        if (this.m_source == null) {
            this.m_source = new SourceParameter();
            this.addBaseRule(this.m_source);
        }
        return this.m_source;
    }

    public void setSourceParameter(String param) throws BadRuleException {
        this.getSource().setRuleValue(param);
    }

    public String getSourceParameter() {
        return this.getSource().getRuleValue();
    }

    public ReturnValue getReturnRule() {
        if (this.m_rtn == null) {
            this.m_rtn = new ReturnValue();
            this.addBaseRule(this.m_rtn);
        }
        return this.m_rtn;
    }

    public void setReturn(boolean isReturn) throws BadRuleException {
        this.getReturnRule().setReturnValue(isReturn);
    }

    public boolean isReturn() {
        return this.getReturnRule().isReturnValue();
    }

    @Override
    public boolean applyRule(Method m) throws BadRuleException {
        try {
            if (this.m_dst != null && this.m_dst.isRuleValid() || this.m_source != null && this.m_source.isRuleValid() || this.m_rtn != null && this.m_rtn.isRuleValid()) {
                if (this.m_dst == null) {
                    throw new BadRuleException("Destination paramater has not been set");
                }
                if (this.m_source == null) {
                    throw new BadRuleException("Source paramater has not been set");
                }
                if (this.m_rtn == null) {
                    throw new BadRuleException("Return is not set");
                }
            }
            if (m.addTaint(this.getSource().getRuleValue(), this.getDst().getRuleValue(), this.getReturnRule().isReturnValue())) {
                if (!m.isNotSusceptibleToTaint()) {
                    m.addProperty("Attribute.Validation.None");
                }
                return true;
            }
        }
        catch (BadMarkupException bme) {
            return false;
        }
        return false;
    }

    @Override
    public boolean isRuleValid() {
        if (!this.getDst().isRuleValid()) {
            return false;
        }
        return this.getSource().isRuleValid();
    }

    @Override
    public boolean allowsContains() {
        return false;
    }
}

