/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.custom.scanner.sca.data;

import com.hcl.appscan.custom.scanner.sca.data.SCALicense;
import com.hcl.appscan.custom.scanner.sca.data.SCAVulnerability;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class Library {
    private String m_name;
    private String m_technology;
    private String m_version;
    private Map<String, SortedSet<String>> m_locationMap = new HashMap<String, SortedSet<String>>();
    private Collection<SCALicense> m_licenses;
    private Collection<SCAVulnerability> m_vulnerabilities;
    private Set<String> m_processedHashes;

    public Library(String filePath, String version, String hash, JSONObject info) throws JSONException {
        this.m_version = version;
        this.m_licenses = new ArrayList<SCALicense>();
        this.m_vulnerabilities = new ArrayList<SCAVulnerability>();
        this.m_processedHashes = new HashSet<String>();
        this.addFile(filePath, hash);
        this.processLibrary(info, hash);
    }

    public String getName() {
        return this.m_name;
    }

    public String getTechnology() {
        return this.m_technology;
    }

    public List<String> getVulnerableFiles() {
        ArrayList<String> vulnerableFiles = new ArrayList<String>();
        for (SortedSet<String> fileSet : this.m_locationMap.values()) {
            vulnerableFiles.add(fileSet.first());
        }
        return vulnerableFiles;
    }

    public Collection<String> getLocations() {
        return this.m_locationMap.keySet();
    }

    public void addFile(String filePath, String hash) {
        File vulnerableFile = new File(filePath);
        String location = vulnerableFile.getParentFile().getAbsolutePath();
        if (!this.m_processedHashes.contains(hash)) {
            HashMap<String, SortedSet<String>> copy = new HashMap<String, SortedSet<String>>(this.m_locationMap);
            for (String directory : copy.keySet()) {
                if (directory.contains(location)) {
                    this.m_locationMap.put(location, this.m_locationMap.get(directory));
                    this.m_locationMap.remove(directory);
                    continue;
                }
                if (!location.contains(directory)) continue;
                location = directory;
            }
        }
        if (!this.m_locationMap.containsKey(location)) {
            TreeSet files = new TreeSet();
            this.m_locationMap.put(location, files);
        }
        this.m_locationMap.get(location).add(filePath);
        this.m_processedHashes.add(hash);
    }

    public String getVersion() {
        return this.m_version;
    }

    public Collection<SCALicense> getLicenses() {
        return this.m_licenses;
    }

    public Collection<SCAVulnerability> getVulnerabilities() {
        return this.m_vulnerabilities;
    }

    public boolean equals(Object o) {
        if (o instanceof Library) {
            Library comp = (Library)o;
            return this.m_name.equalsIgnoreCase(comp.getName()) && this.m_technology.equalsIgnoreCase(comp.getTechnology()) && this.m_version.equalsIgnoreCase(comp.getVersion());
        }
        return false;
    }

    public int hashCode() {
        return (this.m_name + this.m_technology + this.m_version).hashCode();
    }

    private void processLibrary(JSONObject info, String hash) throws JSONException {
        this.m_name = info.getString("library");
        String string = this.m_technology = info.containsKey((Object)"technology") && !info.isNull("technology") ? info.getString("technology") : "";
        if (info.containsKey((Object)"licenseInfos")) {
            JSONArray licenses = info.getJSONArray("licenseInfos");
            for (JSONObject licenseInfo : licenses) {
                this.m_licenses.add(new SCALicense(this.m_name, licenseInfo, hash, this.m_version, this.m_technology));
            }
        }
        if (info.containsKey((Object)"vulnerabilities")) {
            JSONArray vulnerabilities = info.getJSONArray("vulnerabilities");
            for (JSONObject vulnerability : vulnerabilities) {
                this.m_vulnerabilities.add(new SCAVulnerability(this, vulnerability));
            }
        }
    }
}

