/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.thirdpartylib.dependency.conan;

import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.discovery.thirdpartylib.Messages;
import com.ibm.appscan.discovery.thirdpartylib.dependency.IDependencyCollector;
import com.ibm.appscan.discovery.thirdpartylib.utils.ThirdPartyLibUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConanDependencyCollector
implements IDependencyCollector {
    private File m_conanConfigFile;
    private ILogManager m_log;
    private boolean m_shouldRunTrivy = true;
    private static boolean stopProcessing = false;

    public ConanDependencyCollector(File conanConfigFile, ILogManager logManager) {
        this.m_conanConfigFile = conanConfigFile;
        this.m_log = logManager;
    }

    @Override
    public String getExecutableName() {
        return "conan".toLowerCase();
    }

    @Override
    public String getStagingDirectoryName() {
        return "trivy";
    }

    @Override
    public File getWorkingDirectory() {
        return this.m_conanConfigFile.getParentFile();
    }

    @Override
    public String getToolName() {
        return "conan";
    }

    @Override
    public Map<File, String> getDependencies(File location, String uuid) throws IOException {
        Map<File, String> files = new HashMap<File, String>();
        if (!stopProcessing) {
            File rootconanPy;
            List<File> conanConfigFiles = new ArrayList<File>();
            String outputFile = uuid + "_trivy_cyclon_report.json";
            File rootLocation = ThirdPartyLibUtils.getRootLocation(location);
            conanConfigFiles = ThirdPartyLibUtils.findAllConfigFiles(rootLocation, conanConfigFiles, "conanfile.txt");
            conanConfigFiles = ThirdPartyLibUtils.findAllConfigFiles(rootLocation, conanConfigFiles, "conanfile.py");
            for (File file : conanConfigFiles) {
                File conanLockFile = new File(file.getParentFile(), "conan.lock");
                if (!conanLockFile.isFile()) {
                    if (this.createConanLockFile(file)) {
                        this.m_log.log(new Message(1, Messages.getMessage("created.conan.lock.file", new File(file.getParent()))));
                        continue;
                    }
                    this.m_log.log(new Message(1, Messages.getMessage("conan.lock.file.creation.failed", new File(file.getParent()))));
                    continue;
                }
                this.m_log.log(new Message(1, Messages.getMessage("conan.lock.file.exists", new File(file.getParent()))));
            }
            ThirdPartyLibUtils.createTrivyStagingDir(location, this.m_log);
            File rootconanTxt = new File(rootLocation, "conanfile.txt");
            if (rootconanTxt.isFile()) {
                this.m_conanConfigFile = rootconanTxt;
            }
            if ((rootconanPy = new File(rootLocation, "conanfile.py")).isFile()) {
                this.m_conanConfigFile = rootconanPy;
            }
            files = ThirdPartyLibUtils.runTrivyAndCollectOutputFile(location, outputFile, this.m_conanConfigFile, this.m_shouldRunTrivy, this.m_log);
            stopProcessing = true;
            this.m_shouldRunTrivy = true;
        }
        return files;
    }

    private void createConanPrfile(File file) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("profile");
        args.add("detect");
        try {
            this.run(this.getExecutableName(), args, null, file.getParentFile());
        }
        catch (IOException e) {
            this.m_log.log((Exception)e);
        }
    }

    private boolean createConanLockFile(File file) {
        this.createConanPrfile(file);
        ArrayList<String> args = new ArrayList<String>();
        args.add("lock");
        args.add("create");
        args.add("\"" + file.getAbsolutePath() + "\"");
        try {
            this.run(this.getExecutableName(), args, null, file.getParentFile());
        }
        catch (IOException e) {
            this.m_log.log((Exception)e);
        }
        return new File(file.getParentFile(), "conan.lock").isFile();
    }

    @Override
    public boolean shouldProcessDependencies() {
        return true;
    }
}

