/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.thirdpartylib.dependency.dotnet;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.FileUtil;
import com.ibm.appscan.discovery.thirdpartylib.Messages;
import com.ibm.appscan.discovery.thirdpartylib.dependency.IDependencyCollector;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DotNetDependencyCollector
implements IDependencyCollector {
    private File m_config_file;
    private ILogManager m_log;

    public DotNetDependencyCollector(File config_file, ILogManager logManager) {
        this.m_config_file = config_file;
        this.m_log = logManager;
    }

    @Override
    public String getExecutableName() {
        return "dotnet";
    }

    @Override
    public String getStagingDirectoryName() {
        return this.getExecutableName();
    }

    @Override
    public File getWorkingDirectory() {
        return this.m_config_file.getParentFile();
    }

    @Override
    public String getToolName() {
        return this.getExecutableName();
    }

    @Override
    public boolean shouldSkipToolCheck() {
        return true;
    }

    @Override
    public Map<File, String> getDependencies(File dotNetStagingDir, String uuid) throws IOException {
        Map<Object, Object> files = null;
        files = new HashMap();
        if (!dotNetStagingDir.isDirectory() && !dotNetStagingDir.mkdirs()) {
            this.m_log.log(new Message(1, Messages.getMessage("staging.creation.error", new Object[0])));
            throw new IOException(Messages.getMessage("staging.creation.error", new Object[0]));
        }
        files = this.collectAllConfigFiles(dotNetStagingDir, uuid, true);
        if (files != null) {
            return files;
        }
        if (this.isToolInstalled()) {
            this.runDotNetRestoreAndBuild();
            files = this.collectAllConfigFiles(dotNetStagingDir, uuid, true);
            if (files != null) {
                return files;
            }
        } else {
            this.m_log.log(new Message(1, Messages.getMessage("command.not.found", this.getExecutableName())));
        }
        if (this.configFileExists("packages.config", null)) {
            return this.collectConfigFile(dotNetStagingDir, uuid, "packages.config", "_packages.config", null);
        }
        return this.collectProjectFile(dotNetStagingDir, uuid);
    }

    private Map<File, String> collectAllConfigFiles(File dotNetStagingDir, String uuid, boolean checkPaketInstall) {
        if (this.configFileExists("project.assets.json", "obj")) {
            return this.collectConfigFile(dotNetStagingDir, uuid, "project.assets.json", "_project.assets.json", "obj");
        }
        if (this.configFileExists("packages.lock.json", null)) {
            return this.collectConfigFile(dotNetStagingDir, uuid, "packages.lock.json", "_packages.lock.json", null);
        }
        if (checkPaketInstall && this.configFileExists("paket.dependencies", null) && this.isPaketInstalled()) {
            this.runPaketInstallAndRestore();
        }
        if (this.configFileExists("paket.lock", null)) {
            return this.collectConfigFile(dotNetStagingDir, uuid, "paket.lock", "_paket.lock", null);
        }
        return null;
    }

    private boolean configFileExists(String configFileName, String subDirectoryName) {
        File currentDirectory = this.m_config_file.getParentFile();
        if (subDirectoryName != null) {
            currentDirectory = new File(currentDirectory, subDirectoryName);
        }
        return new File(currentDirectory, configFileName).isFile();
    }

    private Map<File, String> collectConfigFile(File dotNetStagingDir, String uuid, String fileToCollect, String stagingCollectedFilename, String subDirectoryName) {
        File currentDirectory = null;
        HashMap<File, String> files = new HashMap<File, String>();
        currentDirectory = subDirectoryName != null ? new File(this.m_config_file.getParentFile(), subDirectoryName) : this.m_config_file.getParentFile();
        File configFile = new File(currentDirectory, fileToCollect);
        File stagingCopyName = new File(dotNetStagingDir, uuid + stagingCollectedFilename);
        try {
            this.logAndPrintMessage(new Message(1, Messages.getMessage("processing.config.start", configFile)));
            Files.copy(configFile.toPath(), stagingCopyName.toPath(), StandardCopyOption.REPLACE_EXISTING);
            files.put(stagingCopyName, configFile.getAbsolutePath());
        }
        catch (IOException e) {
            this.m_log.log((Exception)e);
        }
        return files;
    }

    private Map<File, String> collectProjectFile(File dotNetStagingDir, String uuid) {
        if (this.m_config_file.toString().toLowerCase().endsWith("sln")) {
            return null;
        }
        HashMap<File, String> files = new HashMap<File, String>();
        File projectFileStagingCopy = new File(dotNetStagingDir, uuid + "_" + FileUtil.getFileExtension((File)this.m_config_file));
        try {
            Files.copy(this.m_config_file.toPath(), projectFileStagingCopy.toPath(), StandardCopyOption.REPLACE_EXISTING);
            files.put(projectFileStagingCopy, this.m_config_file.getAbsolutePath());
        }
        catch (IOException e) {
            this.m_log.log((Exception)e);
        }
        return files;
    }

    private void runDotNetRestoreAndBuild() {
        ArrayList<String> args = new ArrayList<String>();
        args = new ArrayList();
        args.add(" restore");
        try {
            this.run(args, null);
        }
        catch (IOException e) {
            this.m_log.log((Exception)e);
        }
        args = new ArrayList();
        args.add(" build");
        try {
            this.run(args, null);
        }
        catch (IOException e) {
            this.m_log.log((Exception)e);
        }
    }

    private void runPaketInstallAndRestore() {
        ArrayList<String> args = new ArrayList<String>();
        args = new ArrayList();
        args.add(" install");
        try {
            this.run("paket", args, null);
        }
        catch (IOException e) {
            this.m_log.log((Exception)e);
        }
        args = new ArrayList();
        args.add(" restore");
        try {
            this.run("paket", args, null);
        }
        catch (IOException e) {
            this.m_log.log((Exception)e);
        }
    }

    private boolean isPaketInstalled() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--version");
        try {
            if (this.run("paket", args, null) != 0) {
                this.m_log.log(new Message(1, Messages.getMessage("command.not.found", "paket")));
                return false;
            }
        }
        catch (IOException e) {
            this.m_log.log((Exception)e);
            return false;
        }
        return true;
    }

    private void logAndPrintMessage(Message message) {
        CommonCore.getIOConsole().println(message);
        this.m_log.log(message);
    }

    private boolean dirContainsProjFile() {
        FilenameFilter filter;
        final String[] extensions = new String[]{"csproj", "vbproj", "vcxproj"};
        File currentDirectory = this.m_config_file.getParentFile();
        File[] files = currentDirectory.listFiles(filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                for (String ext : extensions) {
                    if (!name.toLowerCase().endsWith(ext.toLowerCase())) continue;
                    return true;
                }
                return false;
            }
        });
        return files != null && files.length > 0;
    }

    @Override
    public boolean shouldProcessDependencies() {
        if (this.m_config_file.toString().toLowerCase().endsWith("sln")) {
            return !this.dirContainsProjFile();
        }
        return true;
    }
}

