/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.thirdpartylib;

import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTarget;
import com.ibm.appscan.common.model.SaveLocation;
import com.ibm.appscan.common.model.xml.IModelXMLConstants;
import com.ibm.appscan.common.model.xml.ModelWriter;
import com.ibm.appscan.common.utils.PathUtil;
import com.ibm.appscan.common.xml.DOMWriter;
import com.ibm.appscan.internal.discovery.thirdpartylib.ScanFilesMap;
import com.ibm.appscan.internal.discovery.thirdpartylib.ThirdPartyLibScanTarget;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.xml.transform.TransformerException;

public class ConfigInfoWriter
extends ModelWriter
implements IModelXMLConstants {
    private File m_scanHome = null;
    private ScanFilesMap m_configScanFiles = null;
    private boolean m_hasErrors = false;
    private DOMWriter m_writer = null;

    public ConfigInfoWriter(ScanFilesMap configScanFiles) {
        this.m_configScanFiles = configScanFiles;
    }

    protected void initWriters(File directory) throws IOException {
        try {
            this.m_writer = new DOMWriter(this.getWorkingDirectory(), ".configinfo", this.m_builder);
            this.m_writer.beginElement("Target");
            this.m_writer.setAttribute("path", "ThirdPartyLib");
            this.m_writer.setAttribute("working_directory", ".");
            this.m_writer.setAttribute("name", "ThirdPartyLib");
            this.m_writer.setAttribute("type", "thirdpartylib");
            this.m_writer.setAttribute("strategy", ThirdPartyLibScanTarget.class.getName());
            this.m_writer.setAttribute("language_type", "thirdpartylib");
            this.writeConfigScanFiles();
        }
        catch (IOException e) {
            this.m_hasErrors = true;
            throw e;
        }
    }

    private void writeConfigScanFiles() {
        File workingDirectory = this.getWorkingDirectory();
        for (Map.Entry entry : this.m_configScanFiles.entrySet()) {
            Collection files = (Collection)entry.getValue();
            for (IScanFile file : files) {
                if (file.isExcluded()) continue;
                this.m_writer.beginElement("ScanFile");
                String filePath = file.getFile().getPath();
                String analysisPath = this.extractStagingPath(filePath);
                this.m_writer.setAttribute("analysis_path", analysisPath);
                String sourcePath = file.getSourcePath();
                if (sourcePath != null) {
                    this.m_writer.setAttribute("src_path", PathUtil.makeRelative((File)this.m_scanHome, (File)workingDirectory, (String)sourcePath));
                    File sourcePathFile = new File(sourcePath);
                    if (!sourcePathFile.isAbsolute() && this.m_scanHome != null) {
                        sourcePathFile = new File(this.m_scanHome, sourcePath);
                    }
                    try {
                        this.m_writer.setAttribute("abs_path", sourcePathFile.getCanonicalPath());
                    }
                    catch (IOException e) {
                        this.m_writer.setAttribute("abs_path", sourcePathFile.getAbsolutePath());
                    }
                }
                this.m_writer.endElement();
            }
        }
    }

    public void visit(IScan scan) {
        SaveLocation location = scan.getSaveLocation();
        if (location != null) {
            this.m_scanHome = location.getWorkLocation();
        }
    }

    public void visit(IScanTarget target) {
    }

    public void postVisit(IScanTarget target) {
    }

    public void write() throws TransformerException {
        if (this.m_writer != null) {
            this.m_writer.endElement();
            this.m_writer.write(this.m_transformer);
        }
    }

    public boolean hasErrors() {
        return this.m_hasErrors;
    }

    private String extractStagingPath(String path) {
        String stagingPatternWin;
        String windowsPath;
        if (path == null) {
            return "";
        }
        String normalizedPath = path.replace('\\', '/');
        String STAGING_DIR = "staging";
        String stagingPattern = "/staging/";
        int stagingIndex = normalizedPath.indexOf(stagingPattern);
        if (stagingIndex >= 0) {
            return "staging" + normalizedPath.substring(stagingIndex + stagingPattern.length() - 1);
        }
        if (normalizedPath.endsWith("/staging")) {
            return "staging";
        }
        String[] pathComponents = normalizedPath.split("/");
        for (int i = 0; i < pathComponents.length; ++i) {
            if (!"staging".equals(pathComponents[i]) || i >= pathComponents.length - 1) continue;
            StringBuilder result = new StringBuilder("staging");
            for (int j = i + 1; j < pathComponents.length; ++j) {
                result.append("/").append(pathComponents[j]);
            }
            return result.toString();
        }
        if (System.getProperty("os.name").toLowerCase().contains("win") && (stagingIndex = (windowsPath = path.replace('/', '\\')).indexOf(stagingPatternWin = "\\staging\\")) >= 0) {
            String result = "staging" + windowsPath.substring(stagingIndex + stagingPatternWin.length() - 1);
            return result.replace('\\', '/');
        }
        String result = normalizedPath;
        if (new File(path).isAbsolute()) {
            result = new File(path).getName();
        }
        return PathUtil.replaceBackslashes((String)result);
    }
}

