/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.cloud.auth.commands;

import com.ibm.appscan.cli.cloud.auth.Messages;
import com.ibm.appscan.cli.cloud.auth.handlers.LoginHandler;
import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.common.components.Command;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.SystemUtil;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public abstract class LoginCommand
extends Command {
    protected LoginHandler m_handler = new LoginHandler();
    private static final String HTTPS = "https://";
    private static final String HTTP = "http://";

    public LoginCommand() {
    }

    public LoginCommand(String[] args) {
        super(args);
    }

    protected abstract void execute(String var1, char[] var2, boolean var3, boolean var4, String var5);

    public void execute() {
        CommandLine cmd = this.getCommandLine();
        if (cmd == null) {
            return;
        }
        String username = null;
        String server = null;
        char[] password = null;
        boolean acceptssl = false;
        boolean persist = true;
        if (cmd.hasOption("u")) {
            username = cmd.getOptionValue("u");
        }
        if (cmd.hasOption("P")) {
            password = cmd.getOptionValue("P").toCharArray();
        }
        if (cmd.hasOption("service_url")) {
            server = cmd.getOptionValue("service_url");
            try {
                server = this.checkServiceURLProtocol(server);
                new URL(server);
            }
            catch (MalformedURLException e) {
                CommonCLICore.getIOConsole().print(new Message(4, Messages.getMessage("invalid.service.url", new Object[0])));
                System.exit(-1);
            }
        }
        if (cmd.hasOption("acceptssl")) {
            acceptssl = true;
        }
        this.execute(username, password, persist, acceptssl, server);
    }

    private String checkServiceURLProtocol(String service_url) {
        if (!service_url.toLowerCase().startsWith(HTTPS) && !service_url.toLowerCase().startsWith(HTTP)) {
            service_url = HTTPS + service_url;
        }
        return service_url;
    }

    protected Options buildOptions() {
        Options options = new Options();
        OptionBuilder.withArgName((String)this.getUsernameName());
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)this.getUsernameDesc());
        options.addOption(OptionBuilder.create((String)"u"));
        OptionBuilder.withArgName((String)this.getPasswordName());
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)this.getPasswordDesc());
        options.addOption(OptionBuilder.create((String)"P"));
        OptionBuilder.withArgName((String)this.getServiceUrlName());
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)this.getServiceUrlDesc());
        options.addOption(OptionBuilder.create((String)"service_url"));
        OptionBuilder.withDescription((String)Messages.getMessage("command.login.persist.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"persist"));
        if (SystemUtil.isDevelopment()) {
            OptionBuilder.withDescription((String)Messages.getMessage("command.login.acceptssl.description", new Object[0]));
            options.addOption(OptionBuilder.create((String)"acceptssl"));
        }
        return options;
    }

    protected String getUsernameName() {
        return Messages.getMessage("command.login.username.name", new Object[0]);
    }

    protected String getUsernameDesc() {
        return Messages.getMessage("command.login.username.description", new Object[0]);
    }

    protected String getPasswordName() {
        return Messages.getMessage("command.login.password.name", new Object[0]);
    }

    protected String getPasswordDesc() {
        return Messages.getMessage("command.login.password.description", new Object[0]);
    }

    protected String getServiceUrlName() {
        return Messages.getMessage("command.login.serviceurl.name", new Object[0]);
    }

    protected String getServiceUrlDesc() {
        return Messages.getMessage("command.login.serviceurl.description", new Object[0]);
    }
}

