/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.cg.util;

import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.DefaultIRFactory;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.IRFactory;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Pair;
import java.lang.ref.SoftReference;
import java.util.Map;

public class TaintAnalysisCache {
    private final Map<CGNode, SoftReference<DefUse>> defUseCache = HashMapFactory.make();
    private final Map<CGNode, SoftReference<IR>> irCache = HashMapFactory.make();
    private final IRFactory<IMethod> irFactory = new DefaultIRFactory();
    private final Map<Pair<IMethod, Context>, IR> backwardsIRCache = HashMapFactory.make();
    private static TaintAnalysisCache soleInstance;
    public static CallGraph cg;
    private static boolean isBoundedToCallGraph;

    public static void setCallGraph(CallGraph callGraph) {
        cg = callGraph;
        isBoundedToCallGraph = true;
    }

    private TaintAnalysisCache() {
    }

    public static void reset() {
        soleInstance = new TaintAnalysisCache();
    }

    public static TaintAnalysisCache soleInstance() {
        if (!isBoundedToCallGraph) {
            throw new IllegalStateException("TaintAnalysisCache not initialized.  No CallGraph has been provided.");
        }
        if (soleInstance == null) {
            soleInstance = new TaintAnalysisCache();
        }
        return soleInstance;
    }

    public DefUse getDefUse(IMethod m) {
        CGNode n = this.getNode(m);
        return this.getDefUse(n);
    }

    public DefUse getDefUse(IMethod m, Context c) {
        CGNode n = cg.getNode(m, c);
        return this.getDefUse(n);
    }

    public DefUse getDefUse(CGNode n) {
        IR ir;
        SoftReference<DefUse> duSoftRef = this.defUseCache.get(n);
        if ((duSoftRef == null || duSoftRef.get() == null) && (ir = this.getIR(n)) != null) {
            DefUse du = new DefUse(ir);
            duSoftRef = new SoftReference<DefUse>(du);
            this.defUseCache.put(n, duSoftRef);
        }
        return duSoftRef == null ? null : duSoftRef.get();
    }

    public IR getBackwardsIR(IMethod m, Context c) {
        Pair key = Pair.make((Object)m, (Object)c);
        if (this.backwardsIRCache.containsKey(key)) {
            return this.backwardsIRCache.get(key);
        }
        DefaultIRFactory irFactory = new DefaultIRFactory();
        IR ir = irFactory.makeIR(m, c, SSAOptions.defaultOptions());
        if (ir != null) {
            this.backwardsIRCache.put((Pair<IMethod, Context>)key, ir);
        }
        return ir;
    }

    public IR getIR(IMethod m) {
        CGNode n = this.getNode(m);
        SoftReference<IR> irSoftRef = this.irCache.get(n);
        if (!(irSoftRef != null && irSoftRef.get() != null || m == null || m.isAbstract() || m.isNative())) {
            IR ir = n == null ? this.irFactory.makeIR(m, (Context)Everywhere.EVERYWHERE, SSAOptions.defaultOptions()) : n.getIR();
            SoftReference<IR> softReference = irSoftRef = ir == null ? null : new SoftReference<IR>(ir);
            if (irSoftRef != null) {
                this.irCache.put(n, irSoftRef);
            }
        }
        IR result = irSoftRef == null ? null : irSoftRef.get();
        return result;
    }

    public IR getIR(CGNode n) {
        IMethod m;
        if (n == null) {
            return null;
        }
        SoftReference<IR> irSoftRef = this.irCache.get(n);
        if (!(irSoftRef != null && irSoftRef.get() != null || (m = n.getMethod()).isAbstract() || m.isNative())) {
            IR ir = n.getIR();
            SoftReference<IR> softReference = irSoftRef = ir == null ? null : new SoftReference<IR>(ir);
            if (irSoftRef != null) {
                this.irCache.put(n, irSoftRef);
            }
        }
        IR result = irSoftRef == null ? null : irSoftRef.get();
        return result;
    }

    public IR getIR(IMethod m, Context c) {
        return this.getIR(cg.getNode(m, c));
    }

    private CGNode getNode(IMethod m) {
        return cg.getNode(m, (Context)Everywhere.EVERYWHERE);
    }

    public void invalidateAll() {
        this.irCache.clear();
        this.defUseCache.clear();
    }

    public void invalidate(IMethod m) {
        CGNode n = this.getNode(m);
        this.irCache.remove(n);
        this.defUseCache.remove(n);
    }

    static {
        isBoundedToCallGraph = false;
    }
}

