/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.core;

import com.ibm.wala.andromeda.cg.util.TaintAnalysisCache;
import com.ibm.wala.andromeda.core.IPropagationWitness;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeBTMethod;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.util.intset.IntSet;

public class BasicPropagationWitness
implements IPropagationWitness {
    private static final int INVALID_LINE_NUMBER = Integer.MIN_VALUE;
    private int lineNumber = Integer.MIN_VALUE;
    private final IMethod method;
    private final Context context;
    private final SSAInstruction instruction;

    public BasicPropagationWitness(IMethod method, Context context, SSAInstruction instruction) {
        assert (method != null);
        assert (instruction != null);
        assert (context != null);
        this.method = method;
        this.context = context;
        this.instruction = instruction;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PROPAGATION WITNESS: ");
        sb.append(this.instruction);
        sb.append(" @ ");
        sb.append(this.method);
        sb.append(" - ");
        sb.append(this.context);
        return sb.toString();
    }

    @Override
    public SSAInstruction getInstruction() {
        return this.instruction;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.instruction == null ? 0 : this.instruction.hashCode());
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicPropagationWitness other = (BasicPropagationWitness)obj;
        if (this.instruction == null ? other.instruction != null : !this.instruction.equals((Object)other.instruction)) {
            return false;
        }
        return !(this.method == null ? other.method != null : !this.method.equals(other.method));
    }

    @Override
    public int getLineNumber() {
        if (this.lineNumber == Integer.MIN_VALUE) {
            this.lineNumber = -1;
            IR ir = TaintAnalysisCache.soleInstance().getIR(this.method, this.context);
            if (ir == null) {
                ir = TaintAnalysisCache.soleInstance().getBackwardsIR(this.method, this.context);
            }
            if (ir != null) {
                if (this.instruction instanceof SSAAbstractInvokeInstruction) {
                    CallSiteReference site = ((SSAAbstractInvokeInstruction)this.instruction).getCallSite();
                    IntSet is = ir.getCallInstructionIndices(site);
                    if (is != null && is.size() == 1) {
                        int ii = is.intIterator().next();
                        if (this.method instanceof ShrikeBTMethod) {
                            try {
                                int bcIndex = ((ShrikeBTMethod)this.method).getBytecodeIndex(ii);
                                this.lineNumber = this.method.getLineNumber(bcIndex);
                            }
                            catch (InvalidClassFileException invalidClassFileException) {}
                        }
                    }
                } else {
                    int instrIndex = -1;
                    SSAInstruction[] allInstructions = ir.getInstructions();
                    for (int index = 0; index < allInstructions.length; ++index) {
                        if (!this.instruction.equals((Object)allInstructions[index])) continue;
                        instrIndex = index;
                        break;
                    }
                    if (instrIndex > -1 && this.method instanceof ShrikeBTMethod) {
                        try {
                            int bcIndex = ((ShrikeBTMethod)this.method).getBytecodeIndex(instrIndex);
                            this.lineNumber = this.method.getLineNumber(bcIndex);
                        }
                        catch (InvalidClassFileException invalidClassFileException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return this.lineNumber;
    }

    @Override
    public IMethod getMethod() {
        return this.method;
    }

    @Override
    public Context getContext() {
        return this.context;
    }
}

