/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.incremental;

import com.ibm.wala.andromeda.cg.util.TaintAnalysisCache;
import com.ibm.wala.andromeda.core.IPropagationWitness;
import com.ibm.wala.andromeda.core.RawAnalysisResult;
import com.ibm.wala.andromeda.core.TaintGraphUtils;
import com.ibm.wala.andromeda.core.Variable;
import com.ibm.wala.andromeda.core.ViolationVariable;
import com.ibm.wala.andromeda.harness.JspServices;
import com.ibm.wala.andromeda.harness.TaintResult;
import com.ibm.wala.andromeda.harness.TaintRule;
import com.ibm.wala.andromeda.incremental.IRawTaintResult;
import com.ibm.wala.andromeda.incremental.NoFlowTaintResult;
import com.ibm.wala.andromeda.rules.FlowStep;
import com.ibm.wala.andromeda.rules.IRawTaintRule;
import com.ibm.wala.andromeda.rules.ITaintResult;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SinkOnlyTaintResult
implements IRawTaintResult {
    private static final long serialVersionUID = 1L;
    private final RawAnalysisResult analysisResult;
    private final Predicate<Variable> sourceFilter;
    private final ViolationVariable sinkVariable;
    private final FlowStep callToSinkStep;
    private final IPropagationWitness callToSink;
    private final TaintRule rule;
    private final JspServices jspServices;

    public SinkOnlyTaintResult(RawAnalysisResult analysisResult, Predicate<Variable> sourceFilter, ViolationVariable sinkVariable, IPropagationWitness callToSink, TaintRule rule, JspServices jspServices) {
        this.analysisResult = analysisResult;
        this.sourceFilter = sourceFilter;
        this.sinkVariable = sinkVariable;
        this.callToSink = callToSink;
        this.jspServices = jspServices;
        TaintResult.CreateFlowStepRetVal createFlowStepResult = TaintResult.createFlowStep(this.callToSink.getMethod(), this.callToSink.getContext(), this.callToSink.getInstruction(), this.callToSink.getLineNumber(), this.jspServices);
        assert (createFlowStepResult.flowStepCreated);
        this.callToSinkStep = createFlowStepResult.fs;
        this.rule = rule;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SINK-ONLY TAINT RESULT: ");
        sb.append(this.callToSinkStep);
        return sb.toString();
    }

    public Set<ITaintResult> refine() {
        Set<Variable> reachableSources = TaintGraphUtils.findBackwardsReachableSources(this.analysisResult.getPropagationGraph(), this.sourceFilter, this.sinkVariable);
        HashSet result = HashSetFactory.make();
        for (Variable sourceVar : reachableSources) {
            IMethod sourceMethod = sourceVar.getMethod();
            SSAInstruction sourceDef = TaintAnalysisCache.soleInstance().getDefUse(sourceMethod, sourceVar.getContext()).getDef(sourceVar.getVarID());
            assert (sourceDef instanceof SSAAbstractInvokeInstruction);
            SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)sourceDef;
            if (!this.rule.acceptsSource(invoke.getDeclaredTarget())) continue;
            TaintResult.CreateFlowStepRetVal createFlowStepResult = TaintResult.createFlowStep(sourceVar.getMethod(), sourceVar.getContext(), sourceDef, 1, this.jspServices);
            if (!createFlowStepResult.flowStepCreated) continue;
            FlowStep callToSourceStep = createFlowStepResult.fs;
            result.add(new NoFlowTaintResult(this.analysisResult, sourceVar, callToSourceStep, this.sinkVariable, this.callToSinkStep, this.rule, this.jspServices));
        }
        return result;
    }

    @Override
    public String getFileName() {
        return this.callToSinkStep.getFileName();
    }

    @Override
    public List<FlowStep> getFlow() {
        return new ArrayList<FlowStep>(Collections.singleton(this.callToSinkStep));
    }

    @Override
    public String getLibraryCallPoint() {
        return this.callToSinkStep.getDescriptor();
    }

    @Override
    public int getLineNo() {
        return this.callToSinkStep.getLineNumber();
    }

    @Override
    public IRawTaintRule getRule() {
        return this.rule.getDeclarativeRule();
    }

    @Override
    public String getSink() {
        SSAAbstractInvokeInstruction sinkCall = (SSAAbstractInvokeInstruction)this.callToSink.getInstruction();
        return sinkCall.getDeclaredTarget().getName().toString();
    }

    @Override
    public String getSource() {
        return null;
    }

    @Override
    public String toSimpleString() {
        return this.toString();
    }
}

