/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.incremental;

import com.ibm.wala.andromeda.cg.util.TaintAnalysisCache;
import com.ibm.wala.andromeda.core.Variable;
import com.ibm.wala.andromeda.lang.ILanguageSpecificServicesForFastanalysis;
import com.ibm.wala.andromeda.modular.SigSinkId;
import com.ibm.wala.andromeda.modular.SigSourceId;
import com.ibm.wala.andromeda.util.logging.DebugOutput;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SummaryCache {
    private final Map<IMethod, TaintRelationSet> methodSummaries = HashMapFactory.make();
    private final Set<IMethod> volatileMethods = HashSetFactory.make();
    private static SummaryCache soleInstance;

    public static SummaryCache soleInstance() {
        if (soleInstance == null) {
            soleInstance = new SummaryCache();
        }
        return soleInstance;
    }

    public void clear() {
        this.methodSummaries.clear();
        this.volatileMethods.clear();
    }

    public void markAsVolatile(IMethod m) {
        this.volatileMethods.add(m);
    }

    public void markAsNonvolatile(IMethod m) {
        this.volatileMethods.remove(m);
    }

    public void invalidate(IMethod m) {
        this.methodSummaries.remove(m);
    }

    public void invalidateAll() {
        this.methodSummaries.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IMethod m : this.methodSummaries.keySet()) {
            String methodToString = m.toString();
            sb.append(methodToString);
            for (int index = 0; index < methodToString.length(); ++index) {
                sb.append('-');
            }
            sb.append("\n");
            for (TaintRelation relation : this.methodSummaries.get(m)) {
                System.out.println(relation);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public Set<TaintRelation> getSummary(Variable v) {
        Set<TaintRelation> summary;
        HashSet result = HashSetFactory.make();
        if (!this.volatileMethods.contains(v.getMethod()) && (summary = this.getMethodSummary(v.getMethod())) != null) {
            for (TaintRelation relation : summary) {
                if (relation.matchesPrecondition(v)) {
                    result.add(relation);
                }
                if (!relation.matchesPostcondition(v)) continue;
                result.add(relation);
            }
        }
        return result;
    }

    public boolean hasPreconditionSummary(Variable v) {
        Set<TaintRelation> summary;
        if (!this.volatileMethods.contains(v.getMethod()) && (summary = this.getMethodSummary(v.getMethod())) != null) {
            for (TaintRelation relation : summary) {
                if (!relation.matchesPrecondition(v)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasPostconditionSummary(Variable v) {
        Set<TaintRelation> summary;
        if (!this.volatileMethods.contains(v.getMethod()) && (summary = this.getMethodSummary(v.getMethod())) != null) {
            for (TaintRelation relation : summary) {
                if (!relation.matchesPostcondition(v)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSummary(Variable v) {
        return !this.volatileMethods.contains(v.getMethod()) && (this.hasPreconditionSummary(v) || this.hasPostconditionSummary(v));
    }

    public Set<UnconditionalCauseRelation> getUnconditionalCauseRelations(IMethod m) {
        Set<TaintRelation> relations;
        HashSet result = HashSetFactory.make();
        if (!this.volatileMethods.contains(m) && (relations = this.getMethodSummary(m)) != null) {
            for (TaintRelation tr : relations) {
                if (tr.getKind() != TaintRelation.Kind.UNCONDITIONAL_CAUSE) continue;
                assert (tr instanceof UnconditionalCauseRelation);
                result.add((UnconditionalCauseRelation)tr);
            }
        }
        return result;
    }

    public Set<UnconditionalEffectRelation> getUnconditionalEffectRelations(IMethod m) {
        Set<TaintRelation> relations;
        HashSet result = HashSetFactory.make();
        if (!this.volatileMethods.contains(m) && (relations = this.getMethodSummary(m)) != null) {
            for (TaintRelation tr : relations) {
                if (tr.getKind() != TaintRelation.Kind.UNCONDITIONAL_EFFECT) continue;
                assert (tr instanceof UnconditionalEffectRelation);
                result.add((UnconditionalEffectRelation)tr);
            }
        }
        return result;
    }

    public Set<TaintFact> getUnconditionalSummarizedEffects(IMethod m) {
        Set<TaintRelation> relations;
        HashSet result = HashSetFactory.make();
        if (!this.volatileMethods.contains(m) && (relations = this.getMethodSummary(m)) != null) {
            for (TaintRelation tr : relations) {
                if (tr.getKind() != TaintRelation.Kind.UNCONDITIONAL_CAUSE) continue;
                result.add(tr.getPostcondition());
            }
        }
        return result;
    }

    public Set<TaintRelation> getMethodSummary(IMethod m) {
        if (this.volatileMethods.contains(m)) {
            return null;
        }
        return this.methodSummaries.get(m);
    }

    public void summarizeUnconditionalConstraintForReturn(Variable unconditionalCause, IMethod m, List<FieldReference> accessPath, ILanguageSpecificServicesForFastanalysis lang_services) {
        TaintRelationSet taintRelations = this.findOrCreateTRS(m, lang_services);
        taintRelations.add(UnconditionalCauseRelation.create(unconditionalCause, new TaintFact(-1, accessPath), lang_services));
    }

    public void summarizeConditionalConstraintForReturn(IMethod m, int fromParamIndex, List<FieldReference> fromAccessPath, List<FieldReference> toAccessPath, ILanguageSpecificServicesForFastanalysis lang_services) {
        TaintRelationSet taintRelations = this.findOrCreateTRS(m, lang_services);
        taintRelations.add(ConditionalTaintRelation.create(new TaintFact(fromParamIndex, fromAccessPath), new TaintFact(-1, toAccessPath), m.getClassHierarchy(), lang_services));
    }

    public void summarizeUnconditionalConstraintForSideEffect(Variable unconditionalCause, IMethod m, int paramIndex, List<FieldReference> accessPath, ILanguageSpecificServicesForFastanalysis lang_services) {
        TaintRelationSet taintRelations = this.findOrCreateTRS(m, lang_services);
        taintRelations.add(UnconditionalCauseRelation.create(unconditionalCause, new TaintFact(paramIndex, accessPath), lang_services));
    }

    public void summarizeConditionalConstraintForSideEffect(IMethod m, int fromParamIndex, List<FieldReference> fromAccessPath, int toParamIndex, List<FieldReference> toAccessPath, ILanguageSpecificServicesForFastanalysis lang_services) {
        TaintRelationSet taintRelations = this.findOrCreateTRS(m, lang_services);
        taintRelations.add(ConditionalTaintRelation.create(new TaintFact(fromParamIndex, fromAccessPath), new TaintFact(toParamIndex, toAccessPath), m.getClassHierarchy(), lang_services));
    }

    private TaintRelationSet findOrCreateTRS(IMethod m, ILanguageSpecificServicesForFastanalysis lang_services) {
        TaintRelationSet taintRelations = this.methodSummaries.get(m);
        if (taintRelations == null) {
            taintRelations = new TaintRelationSet(m.getClassHierarchy(), lang_services);
            this.methodSummaries.put(m, taintRelations);
        }
        return taintRelations;
    }

    public static class TaintFact {
        private final int parameterIndex;
        private final List<FieldReference> accessPath;

        private TaintFact(int parameterIndex, List<FieldReference> accessPath) {
            this.accessPath = accessPath;
            this.parameterIndex = parameterIndex;
        }

        public static TaintFact extractReturnFact(IMethod m, List<FieldReference> accessPath) {
            return new TaintFact(-1, accessPath);
        }

        public static TaintFact extractTaintFact(Variable v) {
            if (v.getVarID() == -1) {
                return TaintFact.extractReturnFact(v.getMethod(), v.getAccessPath());
            }
            if (Variable.isReturnValue(v)) {
                return new TaintFact(-1, v.getAccessPath());
            }
            return new TaintFact(v.getVarID(), v.getAccessPath());
        }

        public int getParameterIndex() {
            return this.parameterIndex;
        }

        public List<FieldReference> getAccessPath() {
            return this.accessPath;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.parameterIndex == -1 ? "ret" : "v" + String.valueOf(this.parameterIndex));
            if (this.accessPath != null) {
                sb.append('.');
                sb.append(this.prettyPrint(this.accessPath));
            }
            return sb.toString();
        }

        private String prettyPrint(List<FieldReference> accessPath) {
            StringBuilder sb = new StringBuilder();
            if (accessPath != null) {
                for (int index = 0; index < accessPath.size(); ++index) {
                    FieldReference fr = accessPath.get(index);
                    if (fr.equals((Object)Variable.DOT_STAR)) {
                        sb.append('*');
                    } else {
                        sb.append(accessPath.get(index).getName().toString());
                    }
                    if (index >= accessPath.size() - 1) continue;
                    sb.append('.');
                }
            }
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.accessPath == null ? 0 : this.accessPath.hashCode());
            result = 31 * result + this.parameterIndex;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TaintFact other = (TaintFact)obj;
            if (this.accessPath == null ? other.accessPath != null : !this.accessPath.equals(other.accessPath)) {
                return false;
            }
            return this.parameterIndex == other.parameterIndex;
        }

        public boolean hasSideEffects() {
            return this.parameterIndex != -1;
        }
    }

    public static class ConditionalTaintRelation
    extends TaintRelation {
        private final TaintFact precondition;
        private final TaintFact postcondition;
        private final IClassHierarchy cha;
        private final ILanguageSpecificServicesForFastanalysis langServices;

        public static ConditionalTaintRelation create(TaintFact precondition, TaintFact postcondition, IClassHierarchy cha, ILanguageSpecificServicesForFastanalysis lang_services) {
            return new ConditionalTaintRelation(precondition, postcondition, cha, lang_services);
        }

        private ConditionalTaintRelation(TaintFact precondition, TaintFact postcondition, IClassHierarchy cha, ILanguageSpecificServicesForFastanalysis lang_services) {
            this.cha = cha;
            this.precondition = precondition;
            this.postcondition = postcondition;
            this.langServices = lang_services;
        }

        @Override
        public boolean matchesPrecondition(Variable v) {
            TaintFact f = TaintFact.extractTaintFact(v);
            return f == null ? false : this.precondition.equals(f);
        }

        @Override
        public boolean matchesPostcondition(Variable v) {
            TaintFact f = TaintFact.extractTaintFact(v);
            return f == null ? false : this.postcondition.equals(f);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cha == null ? 0 : this.cha.hashCode());
            result = 31 * result + (this.postcondition == null ? 0 : this.postcondition.hashCode());
            result = 31 * result + (this.precondition == null ? 0 : this.precondition.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConditionalTaintRelation other = (ConditionalTaintRelation)obj;
            if (this.cha == null ? other.cha != null : !this.cha.equals(other.cha)) {
                return false;
            }
            if (this.postcondition == null ? other.postcondition != null : !this.postcondition.equals(other.postcondition)) {
                return false;
            }
            return !(this.precondition == null ? other.precondition != null : !this.precondition.equals(other.precondition));
        }

        @Override
        public TaintFact getPostcondition() {
            return this.postcondition;
        }

        @Override
        public TaintFact getPrecondition() {
            return this.precondition;
        }

        @Override
        public Pair<Variable, Variable> instantiate(IMethod binding) {
            Variable cause = Variable.failOrCreate(binding, this.precondition.getParameterIndex(), this.precondition.getAccessPath(), this.langServices);
            Variable effect = Variable.failOrCreate(binding, this.postcondition.getParameterIndex(), this.postcondition.getAccessPath(), this.langServices);
            return Pair.make((Object)cause, (Object)effect);
        }

        @Override
        public TaintRelation.Kind getKind() {
            return TaintRelation.Kind.CONDITIONAL;
        }

        @Override
        public Set<Pair<Variable, Variable>> apply(IMethod m, CallSiteReference site) {
            SSAAbstractInvokeInstruction[] calls;
            HashSet result = HashSetFactory.make();
            IR ir = TaintAnalysisCache.soleInstance().getIR(m);
            for (SSAAbstractInvokeInstruction call : calls = ir.getCalls(site)) {
                try {
                    int actualPreVarID = call.getUse(this.precondition.getParameterIndex() - 1);
                    int actualPostVarID = this.postcondition.getParameterIndex() == -1 ? call.getDef() : call.getUse(this.postcondition.getParameterIndex() - 1);
                    result.add(Pair.make((Object)Variable.failOrCreate(m, actualPreVarID, this.precondition.getAccessPath(), this.langServices), (Object)Variable.failOrCreate(m, actualPostVarID, this.postcondition.getAccessPath(), this.langServices)));
                }
                catch (NullPointerException npe) {
                    DebugOutput.println((String)"Null Pointer Exception in Summary Cache");
                    DebugOutput.println((String)npe.toString());
                    DebugOutput.println((String)npe.getStackTrace().toString());
                }
            }
            return result;
        }

        @Override
        public Set<Pair<Variable, Variable>> apply(IMethod m, Context c, CallSiteReference site) {
            SSAAbstractInvokeInstruction[] calls;
            HashSet result = HashSetFactory.make();
            IR ir = TaintAnalysisCache.soleInstance().getIR(m, c);
            for (SSAAbstractInvokeInstruction call : calls = ir.getCalls(site)) {
                try {
                    int actualPreVarID = call.getUse(this.precondition.getParameterIndex() - 1);
                    int actualPostVarID = this.postcondition.getParameterIndex() == -1 ? call.getDef() : call.getUse(this.postcondition.getParameterIndex() - 1);
                    result.add(Pair.make((Object)Variable.failOrCreate(m, c, actualPreVarID, this.precondition.getAccessPath(), this.langServices), (Object)Variable.failOrCreate(m, c, actualPostVarID, this.postcondition.getAccessPath(), this.langServices)));
                }
                catch (NullPointerException npe) {
                    DebugOutput.println((String)"Null Pointer Exception in Summary Cache");
                    DebugOutput.println((String)npe.toString());
                    DebugOutput.println((String)npe.getStackTrace().toString());
                }
            }
            return result;
        }
    }

    public static class UnconditionalEffectRelation
    extends TaintRelation {
        private final TaintFact precondition;
        private final Variable unconditionalEffect;
        private final ILanguageSpecificServicesForFastanalysis langServices;

        public static UnconditionalEffectRelation create(TaintFact precondition, Variable unconditionalEffect, ILanguageSpecificServicesForFastanalysis lang_services) {
            return new UnconditionalEffectRelation(precondition, unconditionalEffect, lang_services);
        }

        private UnconditionalEffectRelation(TaintFact precondition, Variable unconditionalEffect, ILanguageSpecificServicesForFastanalysis lang_services) {
            this.precondition = precondition;
            this.unconditionalEffect = unconditionalEffect;
            this.langServices = lang_services;
        }

        @Override
        public boolean matchesPrecondition(Variable v) {
            TaintFact f = TaintFact.extractTaintFact(v);
            return f == null ? false : f.equals(this.precondition);
        }

        @Override
        public boolean matchesPostcondition(Variable v) {
            return v.equals(this.unconditionalEffect);
        }

        public Variable getUnconditionalEffect() {
            return this.unconditionalEffect;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.precondition == null ? 0 : this.precondition.hashCode());
            result = 31 * result + (this.unconditionalEffect == null ? 0 : this.unconditionalEffect.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnconditionalEffectRelation other = (UnconditionalEffectRelation)obj;
            if (this.precondition == null ? other.precondition != null : !this.precondition.equals(other.precondition)) {
                return false;
            }
            return !(this.unconditionalEffect == null ? other.unconditionalEffect != null : !this.unconditionalEffect.equals(other.unconditionalEffect));
        }

        @Override
        public TaintFact getPrecondition() {
            return this.precondition;
        }

        @Override
        public TaintFact getPostcondition() {
            return null;
        }

        @Override
        public Pair<Variable, Variable> instantiate(IMethod binding) {
            Variable precondVar = Variable.failOrCreate(binding, this.precondition.getParameterIndex(), this.precondition.getAccessPath(), this.langServices);
            return Pair.make((Object)precondVar, (Object)this.unconditionalEffect);
        }

        @Override
        public TaintRelation.Kind getKind() {
            return TaintRelation.Kind.UNCONDITIONAL_EFFECT;
        }

        @Override
        public Set<Pair<Variable, Variable>> apply(IMethod m, CallSiteReference site) {
            SSAAbstractInvokeInstruction[] calls;
            HashSet result = HashSetFactory.make();
            IR ir = TaintAnalysisCache.soleInstance().getIR(m);
            for (SSAAbstractInvokeInstruction call : calls = ir.getCalls(site)) {
                try {
                    int actualVarID = this.precondition.getParameterIndex() == -1 ? call.getDef() : call.getUse(this.precondition.getParameterIndex() - 1);
                    result.add(Pair.make((Object)Variable.failOrCreate(m, actualVarID, this.precondition.getAccessPath(), this.langServices), (Object)this.unconditionalEffect));
                }
                catch (NullPointerException npe) {
                    DebugOutput.println((String)"Null Pointer Exception in Summary Cache");
                    DebugOutput.println((String)npe.toString());
                    DebugOutput.println((String)npe.getStackTrace().toString());
                }
            }
            return result;
        }

        @Override
        public Set<Pair<Variable, Variable>> apply(IMethod m, Context c, CallSiteReference site) {
            SSAAbstractInvokeInstruction[] calls;
            HashSet result = HashSetFactory.make();
            IR ir = TaintAnalysisCache.soleInstance().getIR(m, c);
            for (SSAAbstractInvokeInstruction call : calls = ir.getCalls(site)) {
                try {
                    int actualVarID = this.precondition.getParameterIndex() == -1 ? call.getDef() : call.getUse(this.precondition.getParameterIndex() - 1);
                    result.add(Pair.make((Object)Variable.failOrCreate(m, c, actualVarID, this.precondition.getAccessPath(), this.langServices), (Object)this.unconditionalEffect));
                }
                catch (NullPointerException npe) {
                    DebugOutput.println((String)"Null Pointer Exception in Summary Cache");
                    DebugOutput.println((String)npe.toString());
                    DebugOutput.println((String)npe.getStackTrace().toString());
                }
            }
            return result;
        }

        public Object getSinkId() {
            return new SigSinkId(this.unconditionalEffect.getMethod().getSignature());
        }
    }

    public static class UnconditionalCauseRelation
    extends TaintRelation {
        private final TaintFact postcondition;
        private final Variable unconditionalCause;
        private final ILanguageSpecificServicesForFastanalysis langServices;

        public static UnconditionalCauseRelation create(Variable unconditionalCause, TaintFact postcondition, ILanguageSpecificServicesForFastanalysis lang_services) {
            return new UnconditionalCauseRelation(unconditionalCause, postcondition, lang_services);
        }

        private UnconditionalCauseRelation(Variable unconditionalCause, TaintFact postcondition, ILanguageSpecificServicesForFastanalysis lang_services) {
            this.unconditionalCause = unconditionalCause;
            this.postcondition = postcondition;
            this.langServices = lang_services;
        }

        @Override
        public boolean matchesPrecondition(Variable v) {
            return this.unconditionalCause.equals(v);
        }

        @Override
        public boolean matchesPostcondition(Variable v) {
            TaintFact f = TaintFact.extractTaintFact(v);
            return f == null ? false : f.equals(this.postcondition);
        }

        public Variable getUnconditionalCause() {
            return this.unconditionalCause;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.postcondition == null ? 0 : this.postcondition.hashCode());
            result = 31 * result + (this.unconditionalCause == null ? 0 : this.unconditionalCause.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnconditionalCauseRelation other = (UnconditionalCauseRelation)obj;
            if (this.postcondition == null ? other.postcondition != null : !this.postcondition.equals(other.postcondition)) {
                return false;
            }
            return !(this.unconditionalCause == null ? other.unconditionalCause != null : !this.unconditionalCause.equals(other.unconditionalCause));
        }

        @Override
        public TaintFact getPrecondition() {
            return null;
        }

        @Override
        public TaintFact getPostcondition() {
            return this.postcondition;
        }

        @Override
        public Pair<Variable, Variable> instantiate(IMethod binding) {
            Variable postcondVar = Variable.failOrCreate(binding, this.postcondition.getParameterIndex(), this.postcondition.getAccessPath(), this.langServices);
            return Pair.make((Object)this.unconditionalCause, (Object)postcondVar);
        }

        @Override
        public TaintRelation.Kind getKind() {
            return TaintRelation.Kind.UNCONDITIONAL_CAUSE;
        }

        @Override
        public Set<Pair<Variable, Variable>> apply(IMethod m, CallSiteReference site) {
            SSAAbstractInvokeInstruction[] calls;
            HashSet result = HashSetFactory.make();
            IR ir = TaintAnalysisCache.soleInstance().getIR(m);
            for (SSAAbstractInvokeInstruction call : calls = ir.getCalls(site)) {
                try {
                    int actualVarID = this.postcondition.getParameterIndex() == -1 ? call.getDef() : call.getUse(this.postcondition.getParameterIndex() - 1);
                    result.add(Pair.make((Object)this.unconditionalCause, (Object)Variable.failOrCreate(m, actualVarID, this.postcondition.getAccessPath(), this.langServices)));
                }
                catch (NullPointerException npe) {
                    DebugOutput.println((String)"Null Pointer Exception in Summary Cache");
                    DebugOutput.println((String)npe.toString());
                    DebugOutput.println((String)npe.getStackTrace().toString());
                }
            }
            return result;
        }

        @Override
        public Set<Pair<Variable, Variable>> apply(IMethod m, Context c, CallSiteReference site) {
            SSAAbstractInvokeInstruction[] calls;
            HashSet result = HashSetFactory.make();
            IR ir = TaintAnalysisCache.soleInstance().getIR(m, c);
            for (SSAAbstractInvokeInstruction call : calls = ir.getCalls(site)) {
                try {
                    int actualVarID = this.postcondition.getParameterIndex() == -1 ? call.getDef() : call.getUse(this.postcondition.getParameterIndex() - 1);
                    result.add(Pair.make((Object)this.unconditionalCause, (Object)Variable.failOrCreate(m, c, actualVarID, this.postcondition.getAccessPath(), this.langServices)));
                }
                catch (NullPointerException npe) {
                    DebugOutput.println((String)"Null Pointer Exception in Summary Cache");
                    DebugOutput.println((String)npe.toString());
                    DebugOutput.println((String)npe.getStackTrace().toString());
                }
            }
            return result;
        }

        public Object getSourceId() {
            return new SigSourceId(this.unconditionalCause.getMethod().getSignature());
        }
    }

    public static class TaintRelationSet
    extends HashSet<TaintRelation> {
        private static final long serialVersionUID = 1L;
        private final IClassHierarchy cha;
        ILanguageSpecificServicesForFastanalysis langServices;

        public TaintRelationSet(IClassHierarchy cha, ILanguageSpecificServicesForFastanalysis lang_services) {
            this.cha = cha;
            this.langServices = lang_services;
        }

        @Override
        public boolean add(TaintRelation tr) {
            List postAP;
            TaintFact pre = tr.getPrecondition();
            TaintFact post = tr.getPostcondition();
            List preAP = pre == null ? null : pre.accessPath;
            List list = postAP = post == null ? null : post.accessPath;
            if (pre != null && post != null && pre.getParameterIndex() == post.getParameterIndex() && Variable.isSubsumedBy(preAP, postAP, this.cha)) {
                return false;
            }
            if (this.isEmpty() && !Variable.isSubsumedBy(preAP, postAP, this.cha)) {
                return super.add(tr);
            }
            HashSet<TaintRelation> redundantTRs = new HashSet<TaintRelation>();
            HashSet<ConditionalTaintRelation> crossTRs = new HashSet<ConditionalTaintRelation>();
            for (TaintRelation existing : this) {
                ConditionalTaintRelation newTR;
                List existingPostAP;
                int existingPostID;
                TaintFact existingPre = existing.getPrecondition();
                TaintFact existingPost = existing.getPostcondition();
                int preID = pre == null ? 0 : pre.getParameterIndex();
                int postID = post == null ? 0 : post.getParameterIndex();
                int existingPreID = existingPre == null ? 0 : existingPre.getParameterIndex();
                int n = existingPostID = existingPost == null ? 0 : existingPost.getParameterIndex();
                if (preID != existingPreID || postID != existingPostID) continue;
                List existingPreAP = existingPre == null ? null : existingPre.accessPath;
                List list2 = existingPostAP = existingPost == null ? null : existingPost.accessPath;
                if (Variable.isSubsumedBy(existingPreAP, preAP, this.cha) && Variable.isSubsumedBy(existingPostAP, postAP, this.cha)) {
                    return false;
                }
                if (Variable.isSubsumedBy(preAP, existingPreAP, this.cha) && Variable.isSubsumedBy(postAP, existingPostAP, this.cha)) {
                    redundantTRs.add(existing);
                    continue;
                }
                if (Variable.isSubsumedBy(existingPreAP, preAP, this.cha) && Variable.isSubsumedBy(postAP, existingPostAP, this.cha)) {
                    newTR = ConditionalTaintRelation.create(existingPre, post, this.cha, this.langServices);
                    redundantTRs.add(existing);
                    crossTRs.add(newTR);
                    continue;
                }
                if (!Variable.isSubsumedBy(preAP, existingPreAP, this.cha) || !Variable.isSubsumedBy(existingPostAP, postAP, this.cha)) continue;
                newTR = ConditionalTaintRelation.create(pre, existingPost, this.cha, this.langServices);
                redundantTRs.add(existing);
                crossTRs.add(newTR);
            }
            this.removeAll(redundantTRs);
            boolean somethingAdded = this.addAll((Collection<? extends TaintRelation>)crossTRs);
            if (somethingAdded) {
                return true;
            }
            return super.add(tr);
        }

        @Override
        public boolean addAll(Collection<? extends TaintRelation> c) {
            boolean result = false;
            if (c != null) {
                for (TaintRelation taintRelation : c) {
                    result |= this.add(taintRelation);
                }
            }
            return result;
        }
    }

    public static abstract class TaintRelation {
        public abstract boolean matchesPrecondition(Variable var1);

        public abstract boolean matchesPostcondition(Variable var1);

        public abstract TaintFact getPrecondition();

        public abstract TaintFact getPostcondition();

        public abstract Pair<Variable, Variable> instantiate(IMethod var1);

        public abstract Set<Pair<Variable, Variable>> apply(IMethod var1, CallSiteReference var2);

        public abstract Set<Pair<Variable, Variable>> apply(IMethod var1, Context var2, CallSiteReference var3);

        public boolean hasSideEffects() {
            TaintFact postcondition = this.getPostcondition();
            return postcondition == null ? false : postcondition.hasSideEffects();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getKind().getDisplayName());
            sb.append("\nPRE-CONDITION:\n");
            sb.append(this.getPrecondition() == null ? "NONE" : this.getPrecondition());
            sb.append("\n");
            sb.append("POST-CONDITION:\n");
            sb.append(this.getPostcondition());
            sb.append("\n");
            return sb.toString();
        }

        public abstract Kind getKind();

        public static enum Kind {
            CONDITIONAL("*CONDITIONAL TAINT RELATION*"),
            UNCONDITIONAL_CAUSE("*UNCONDITIONAL CAUSE TAINT RELATION*"),
            UNCONDITIONAL_EFFECT("*UNCONDITIONAL EFFECT TAINT RELATION*");

            private final String displayName;

            private Kind(String displayName) {
                this.displayName = displayName;
            }

            public String getDisplayName() {
                return this.displayName;
            }
        }
    }
}

