/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.lang;

import com.ibm.wala.andromeda.cg.EntrypointLocator;
import com.ibm.wala.andromeda.cg.IEntrypointLocator;
import com.ibm.wala.andromeda.lang.ILangServices;
import com.ibm.wala.andromeda.lang.WebServiceUtils;
import com.ibm.wala.andromeda.util.SignatureUtil;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.CodeScanner;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.dotnet.loader.AssemblyClassLoader;
import com.ibm.wala.dotnet.loader.AssemblyModule;
import com.ibm.wala.dotnet.loader.CLRLanguage;
import com.ibm.wala.dotnet.loader.CLRMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.rta.CallSite;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class DotNetServices
implements ILangServices {
    private static final Set<String> dotNetFrameworkLibraries = HashSetFactory.make();
    private static final String EVENT_SELECTOR = "(LSystem/Object;LSystem/EventArgs;)Pvoid;";
    private static final String LSYSTEM_WEB_UI_USER_CONTROL = "LSystem/Web/UI/UserControl";
    private static final String SYSTEM_WEB_UI_PAGE = "LSystem/Web/UI/Page";
    private static final String DotNetLangStringName = "LSystem/String";

    @Override
    public String getOfflineSpecificationFile() {
        return "dat/offline.dotnet.dat";
    }

    @Override
    public Language getLanguage() {
        return CLRLanguage.lang;
    }

    @Override
    public boolean doClearAllCaches() {
        return false;
    }

    @Override
    public boolean doUseTypeInference() {
        return true;
    }

    @Override
    public IEntrypointLocator getEntrypointLocator(final IClassHierarchy cha) {
        final IClass uiPageClass = SignatureUtil.findClass((IClassHierarchy)cha, (String)SYSTEM_WEB_UI_PAGE);
        final IClass uiUserControlClass = SignatureUtil.findClass((IClassHierarchy)cha, (String)LSYSTEM_WEB_UI_USER_CONTROL);
        final HashSet classInitializers = HashSetFactory.make();
        Predicate<IClass> classCandidates = new Predicate<IClass>(){

            public boolean test(IClass o) {
                IMethod init = o.getClassInitializer();
                if (init != null) {
                    classInitializers.add(init);
                }
                return cha.getScope().isApplicationLoader(o.getClassLoader()) && (uiPageClass != null && cha.isAssignableFrom(uiPageClass, o) || uiUserControlClass != null && cha.isAssignableFrom(uiUserControlClass, o) || WebServiceUtils.isWebService(o));
            }
        };
        Predicate<IMethod> methodCandidates = new Predicate<IMethod>(){

            public boolean test(IMethod o) {
                assert (o instanceof CLRMethod);
                return DotNetServices.isEventHandler(o) || WebServiceUtils.isWebMethod(o) || classInitializers.contains(o);
            }
        };
        return EntrypointLocator.makeLocator(classCandidates, methodCandidates, cha);
    }

    private static boolean isEventHandler(IMethod m) {
        return m.getDescriptor().toString().equals(EVENT_SELECTOR);
    }

    @Override
    public boolean doAllowLooseResolution() {
        return false;
    }

    @Override
    public String resolveSourceFile(String clsName) {
        return "???";
    }

    @Override
    public boolean mayLeadToSource(IMethod m) {
        if (m.getClassHierarchy().getScope().isApplicationLoader(m.getDeclaringClass().getClassLoader())) {
            return true;
        }
        assert (m.getDeclaringClass().getClassLoader() instanceof AssemblyClassLoader);
        AssemblyClassLoader loader = (AssemblyClassLoader)m.getDeclaringClass().getClassLoader();
        AssemblyModule assembly = loader.getAssembly();
        return !dotNetFrameworkLibraries.contains(assembly.getFile().getName().toLowerCase());
    }

    @Override
    public boolean doClearSSACache() {
        return true;
    }

    @Override
    public Collection<FieldReference> getFieldsRead(CGNode n) {
        Collection result = null;
        try {
            result = CodeScanner.getFieldsRead((IMethod)n.getMethod());
        }
        catch (InvalidClassFileException invalidClassFileException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public Collection<CallSiteReference> getCallSiteRefs(CGNode n) {
        Collection result = null;
        try {
            result = CodeScanner.getCallSites((IMethod)n.getMethod());
        }
        catch (InvalidClassFileException invalidClassFileException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public boolean isStringish(IClass c) {
        if (c == null) {
            throw new IllegalArgumentException("C is null");
        }
        boolean res = c.getReference().getName().toString().equals(DotNetLangStringName);
        return res;
    }

    public Set<String> getTargetNames(CallGraph cg, CallSite cs, SSAAbstractInvokeInstruction invoke) {
        Assertions.UNREACHABLE((String)"Only in JS for now");
        return null;
    }

    static {
        dotNetFrameworkLibraries.add("accessibility.dll");
        dotNetFrameworkLibraries.add("adonetdiag.dll");
        dotNetFrameworkLibraries.add("alink.dll");
        dotNetFrameworkLibraries.add("aspnet_filter.dll");
        dotNetFrameworkLibraries.add("aspnet_isapi.dll");
        dotNetFrameworkLibraries.add("aspnet_perf.dll");
        dotNetFrameworkLibraries.add("aspnet_rc.dll");
        dotNetFrameworkLibraries.add("custommarshalers.dll");
        dotNetFrameworkLibraries.add("diasymreader.dll");
        dotNetFrameworkLibraries.add("eventlogmessages.dll");
        dotNetFrameworkLibraries.add("fusion.dll");
        dotNetFrameworkLibraries.add("ieexecremote.dll");
        dotNetFrameworkLibraries.add("iehost.dll");
        dotNetFrameworkLibraries.add("iiehost.dll");
        dotNetFrameworkLibraries.add("microsoft.build.conversion.dll");
        dotNetFrameworkLibraries.add("microsoft.build.engine.dll");
        dotNetFrameworkLibraries.add("microsoft.build.framework.dll");
        dotNetFrameworkLibraries.add("microsoft.build.tasks.dll");
        dotNetFrameworkLibraries.add("microsoft.build.utilities.dll");
        dotNetFrameworkLibraries.add("microsoft.build.visualjsharp.dll");
        dotNetFrameworkLibraries.add("microsoft.compactframework.build.tasks.dll");
        dotNetFrameworkLibraries.add("microsoft.jscript.dll");
        dotNetFrameworkLibraries.add("microsoft.visualbasic.compatibility.data.dll");
        dotNetFrameworkLibraries.add("microsoft.visualbasic.compatibility.dll");
        dotNetFrameworkLibraries.add("microsoft.visualbasic.dll");
        dotNetFrameworkLibraries.add("microsoft.visualbasic.vsa.dll");
        dotNetFrameworkLibraries.add("microsoft.vsa.dll");
        dotNetFrameworkLibraries.add("microsoft.vsa.vb.codedomprocessor.dll");
        dotNetFrameworkLibraries.add("microsoft_vsavb.dll");
        dotNetFrameworkLibraries.add("mscordacwks.dll");
        dotNetFrameworkLibraries.add("mscordbc.dll");
        dotNetFrameworkLibraries.add("mscordbi.dll");
        dotNetFrameworkLibraries.add("mscorie.dll");
        dotNetFrameworkLibraries.add("mscorjit.dll");
        dotNetFrameworkLibraries.add("mscorld.dll");
        dotNetFrameworkLibraries.add("mscorlib.dll");
        dotNetFrameworkLibraries.add("mscorpe.dll");
        dotNetFrameworkLibraries.add("mscorrc.dll");
        dotNetFrameworkLibraries.add("mscorsec.dll");
        dotNetFrameworkLibraries.add("mscorsn.dll");
        dotNetFrameworkLibraries.add("mscorsvc.dll");
        dotNetFrameworkLibraries.add("mscortim.dll");
        dotNetFrameworkLibraries.add("mscorwks.dll");
        dotNetFrameworkLibraries.add("normalization.dll");
        dotNetFrameworkLibraries.add("perfcounter.dll");
        dotNetFrameworkLibraries.add("sbscmp20_mscorlib.dll");
        dotNetFrameworkLibraries.add("shfusion.dll");
        dotNetFrameworkLibraries.add("shfusres.dll");
        dotNetFrameworkLibraries.add("sysglobl.dll");
        dotNetFrameworkLibraries.add("system.configuration.dll");
        dotNetFrameworkLibraries.add("system.configuration.install.dll");
        dotNetFrameworkLibraries.add("system.data.dll");
        dotNetFrameworkLibraries.add("system.data.oracleclient.dll");
        dotNetFrameworkLibraries.add("system.data.sqlxml.dll");
        dotNetFrameworkLibraries.add("system.deployment.dll");
        dotNetFrameworkLibraries.add("system.design.dll");
        dotNetFrameworkLibraries.add("system.directoryservices.dll");
        dotNetFrameworkLibraries.add("system.directoryservices.protocols.dll");
        dotNetFrameworkLibraries.add("system.dll");
        dotNetFrameworkLibraries.add("system.drawing.design.dll");
        dotNetFrameworkLibraries.add("system.drawing.dll");
        dotNetFrameworkLibraries.add("system.enterpriseservices.dll");
        dotNetFrameworkLibraries.add("system.enterpriseservices.thunk.dll");
        dotNetFrameworkLibraries.add("system.enterpriseservices.wrapper.dll");
        dotNetFrameworkLibraries.add("system.management.dll");
        dotNetFrameworkLibraries.add("system.messaging.dll");
        dotNetFrameworkLibraries.add("system.runtime.remoting.dll");
        dotNetFrameworkLibraries.add("system.runtime.serialization.formatters.soap.dll");
        dotNetFrameworkLibraries.add("system.security.dll");
        dotNetFrameworkLibraries.add("system.serviceprocess.dll");
        dotNetFrameworkLibraries.add("system.transactions.dll");
        dotNetFrameworkLibraries.add("system.web.dll");
        dotNetFrameworkLibraries.add("system.web.mobile.dll");
        dotNetFrameworkLibraries.add("system.web.regularexpressions.dll");
        dotNetFrameworkLibraries.add("system.web.services.dll");
        dotNetFrameworkLibraries.add("system.windows.forms.dll");
        dotNetFrameworkLibraries.add("system.xml.dll");
        dotNetFrameworkLibraries.add("windowsbase.dll");
        dotNetFrameworkLibraries.add("system.io.log.dll");
        dotNetFrameworkLibraries.add("system.data.entity.dll");
        dotNetFrameworkLibraries.add("system.data.services.design.dll");
        dotNetFrameworkLibraries.add("system.data.services.client.dll");
        dotNetFrameworkLibraries.add("system.servicemodel.web.dll");
        dotNetFrameworkLibraries.add("microsoft.transactions.bridge.dll");
        dotNetFrameworkLibraries.add("system.identitymodel.selectors.dll");
        dotNetFrameworkLibraries.add("system.identitymodel.dll");
        dotNetFrameworkLibraries.add("system.web.abstractions.dll");
        dotNetFrameworkLibraries.add("system.web.extensions.dll");
        dotNetFrameworkLibraries.add("system.runtime.serialization.dll");
        dotNetFrameworkLibraries.add("system.xml.linq.dll");
        dotNetFrameworkLibraries.add("system.data.linq.dll");
        dotNetFrameworkLibraries.add("system.core.dll");
        dotNetFrameworkLibraries.add("smdiagnostics.dll");
        dotNetFrameworkLibraries.add("microsoft.visualc.dll");
        dotNetFrameworkLibraries.add("system.servicemodel.dll");
    }
}

