/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.lang;

import com.ibm.wala.andromeda.cg.util.SALogger;
import com.ibm.wala.andromeda.util.SignatureUtil;
import com.ibm.wala.classLoader.BytecodeClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.classLoader.ShrikeClass;
import com.ibm.wala.dotnet.loader.CLRClass;
import com.ibm.wala.dotnet.loader.CLRMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class WebServiceUtils {
    private static final Logger logger = SALogger.logger;
    private static final TypeReference javaWebServiceAnnotation = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Application, (String)"Ljavax/jws/WebService");

    public static Set<CGNode> getWebServiceMethodNodes(CallGraph cg) {
        Set<BytecodeClass<? extends IClassLoader>> webServiceClasses = WebServiceUtils.getWebServiceClasses(cg.getClassHierarchy());
        HashSet webServiceMethodNodes = HashSetFactory.make();
        for (BytecodeClass<? extends IClassLoader> sc : webServiceClasses) {
            Collection allMethods = sc.getDeclaredMethods();
            for (IMethod m : allMethods) {
                if (!WebServiceUtils.isWebMethod(m)) continue;
                webServiceMethodNodes.addAll(cg.getNodes(m.getReference()));
            }
        }
        return webServiceMethodNodes;
    }

    public static boolean isWebMethod(IMethod m) {
        if (m instanceof ShrikeCTMethod) {
            return m.isPublic() && !m.isStatic() && !m.isInit();
        }
        if (m instanceof CLRMethod) {
            CLRMethod clrMethod = (CLRMethod)m;
            Collection annotations = clrMethod.getAnnotations();
            for (Annotation a : annotations) {
                if (!a.getType().getName().toString().equals("LSystem/Web/Services/WebMethodAttribute")) continue;
                return true;
            }
            return false;
        }
        Assertions.UNREACHABLE();
        return false;
    }

    private static Set<BytecodeClass<? extends IClassLoader>> getWebServiceClasses(IClassHierarchy ch) {
        CLRClass webServiceClass = (CLRClass)SignatureUtil.findClass((IClassHierarchy)ch, (String)"LSystem/Web/Services/WebService");
        HashSet webServiceClasses = HashSetFactory.make();
        for (IClassLoader l : ch.getLoaders()) {
            if (!ch.getScope().isApplicationLoader(l)) continue;
            Iterator iter = l.iterateAllClasses();
            while (iter.hasNext()) {
                IClass c = (IClass)iter.next();
                if (!WebServiceUtils.isWebService(c, (CLRClass<Integer, Integer, Integer, Integer, Integer>)webServiceClass)) continue;
                webServiceClasses.add((BytecodeClass)c);
            }
        }
        return webServiceClasses;
    }

    private static boolean isWebService(IClass c, CLRClass<Integer, Integer, Integer, Integer, Integer> dotNetWebServiceClassHint) {
        if (c instanceof ShrikeClass) {
            return WebServiceUtils.isJavaWebService((ShrikeClass)c);
        }
        if (c instanceof CLRClass) {
            CLRClass clrClass = (CLRClass)c;
            return WebServiceUtils.isDotNetWebService((CLRClass<Integer, Integer, Integer, Integer, Integer>)clrClass, dotNetWebServiceClassHint);
        }
        Assertions.UNREACHABLE();
        return false;
    }

    public static boolean isWebService(IClass c) {
        CLRClass webServiceClass = (CLRClass)SignatureUtil.findClass((IClassHierarchy)c.getClassHierarchy(), (String)"LSystem/Web/Services/WebService");
        return WebServiceUtils.isWebService(c, (CLRClass<Integer, Integer, Integer, Integer, Integer>)webServiceClass);
    }

    private static boolean isDotNetWebService(CLRClass<Integer, Integer, Integer, Integer, Integer> c, CLRClass<Integer, Integer, Integer, Integer, Integer> webServiceClass) {
        if (webServiceClass != null && c.getClassHierarchy().isAssignableFrom(webServiceClass, c)) {
            return true;
        }
        for (Annotation annotation : c.getAttributes()) {
            if (!annotation.getType().getName().toString().equals("LSystem/Web/Services/WebServiceAttribute")) continue;
            return true;
        }
        return false;
    }

    private static boolean isJavaWebService(ShrikeClass sc) {
        try {
            Collection runtimeVisibleAnnotations;
            try {
                runtimeVisibleAnnotations = sc.getRuntimeVisibleAnnotations();
            }
            catch (IllegalArgumentException e) {
                logger.warn((Object)("problem reading annotation for type: " + sc + " : " + e.getMessage()));
                return false;
            }
            for (Annotation ann : runtimeVisibleAnnotations) {
                if (!ann.getType().equals((Object)javaWebServiceAnnotation)) continue;
                return true;
            }
        }
        catch (InvalidClassFileException runtimeVisibleAnnotations) {
        }
        catch (UnimplementedError e) {
            logger.warn((Object)("problem reading annotation for type: " + sc + " : " + e.getMessage()));
        }
        return false;
    }
}

