/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.progress;

import com.ibm.wala.andromeda.progress.ProgressManager;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import java.util.HashSet;
import java.util.Set;

public class Step<T> {
    private Step<T> parent;
    private int weight = -1;
    private int progress = 0;
    private final T content;
    private final StepSize stepSize;
    private Step<T>[] substeps;
    private static final double SHORT_2_MEDIUM = 0.5;
    private static final double MEDIUM_2_LONG_RATIO = 0.5;
    private static final double SHORT_2_LONG_RATIO = 0.25;

    public Step(T content, StepSize stepSize) {
        this.content = content;
        this.stepSize = stepSize;
    }

    protected Step(T content, StepSize stepSize, int weight) {
        this(content, stepSize);
        this.weight = weight;
    }

    public double getProgress() {
        return this.progress;
    }

    private void setWeight(int weight) {
        this.weight = weight;
    }

    public int getWeight() {
        return this.weight;
    }

    protected void setParent(Step<T> parent) {
        assert (this.parent == null);
        this.parent = parent;
    }

    protected void updateProgress(double progress) {
        this.progress = (int)((double)this.progress + progress);
        if (this.progress == this.weight) {
            this.markDone();
        }
        if (this.parent != null) {
            this.parent.updateProgress(progress);
        }
    }

    private void markDone() {
        assert (this.weight == this.progress);
        if (this.substeps != null) {
            this.substeps = null;
        }
    }

    public void done() {
        this.updateProgress(this.weight - this.progress);
    }

    public Step<T> getChild(int index) {
        if (index < 0 || this.substeps == null || index >= this.substeps.length) {
            return null;
        }
        return this.substeps[index];
    }

    public void refine(int numSubsteps) {
        HashSet substepsSet = HashSetFactory.make();
        for (int index = 0; index < numSubsteps; ++index) {
            substepsSet.add(new Step<Object>(null, StepSize.MEDIUM));
        }
        this.refine(substepsSet);
    }

    public void refine(Step<T> ... substeps) {
        HashSet substepsSet = HashSetFactory.make();
        for (Step<T> s : substeps) {
            substepsSet.add(s);
        }
        this.refine(substepsSet);
    }

    public void refine(Set<Step<T>> substeps) {
        if (this.substeps == null) {
            this.substeps = new Step[substeps.size()];
            substeps.toArray(this.substeps);
            double numberOfLongUnits = 0.0;
            for (Step<T> s : this.substeps) {
                if (super.getSize() == StepSize.LONG) {
                    numberOfLongUnits += 1.0;
                    continue;
                }
                if (super.getSize() == StepSize.MEDIUM) {
                    numberOfLongUnits += 0.5;
                    continue;
                }
                if (super.getSize() == StepSize.SHORT) {
                    numberOfLongUnits += 0.25;
                    continue;
                }
                Assertions.UNREACHABLE();
            }
            double longWeightUnit = (double)this.weight / numberOfLongUnits;
            int weightLeft = this.substeps.length == 0 ? 0 : this.weight;
            int longWeightUnitInt = (int)Math.floor(longWeightUnit);
            int mediumWeightUnitInt = (int)Math.floor(longWeightUnit * 0.5);
            int shortWeightUnitInt = (int)Math.floor(longWeightUnit * 0.25);
            for (Step<T> s : this.substeps) {
                s.setParent(this);
                if (super.getSize() == StepSize.LONG) {
                    super.setWeight(longWeightUnitInt);
                } else if (super.getSize() == StepSize.MEDIUM) {
                    super.setWeight(mediumWeightUnitInt);
                } else if (super.getSize() == StepSize.SHORT) {
                    super.setWeight(shortWeightUnitInt);
                } else {
                    Assertions.UNREACHABLE();
                }
                weightLeft -= s.getWeight();
            }
            int index = 0;
            while (weightLeft > 0) {
                super.setWeight(this.substeps[index].getWeight() + 1);
                --weightLeft;
                index = (index + 1) % this.substeps.length;
            }
        } else {
            throw new IllegalStateException("Already initialized child steps!");
        }
    }

    public T getContent() {
        return this.content;
    }

    private StepSize getSize() {
        return this.stepSize;
    }

    public static enum StepSize {
        LONG,
        MEDIUM,
        SHORT;

    }

    public static class Root<T>
    extends Step<T> {
        private final ProgressManager progressManager;

        public Root(ProgressManager progressManager, T content, StepSize stepSize, int initialWeight) {
            super(content, stepSize, initialWeight);
            this.progressManager = progressManager;
        }

        @Override
        protected void setParent(Step<T> parent) {
            Assertions.UNREACHABLE();
        }

        @Override
        protected void updateProgress(double progress) {
            super.updateProgress(progress);
            this.progressManager.increment(progress);
        }
    }
}

