/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.util;

import com.ibm.wala.andromeda.util.Combine;
import com.ibm.wala.andromeda.util.Output;
import com.ibm.wala.util.collections.Factory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.intset.OrdinalSet;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CollectionsUtil {
    public static boolean DEBUG = false;

    public static <T, U extends Combine<U>> void combineMapsOfCombine(Map<T, U> m1, Map<T, U> m2, Factory<U> factory) {
        for (Map.Entry<T, U> e : m2.entrySet()) {
            ((Combine)MapUtil.findOrCreateValue(m1, e.getKey(), factory)).combine((Combine)e.getValue());
        }
    }

    public static <T, U, V> void combineMapsOfMapsOfSets(Map<T, Map<U, Set<V>>> m1, Map<T, Map<U, Set<V>>> m2) {
        for (Map.Entry<T, Map<U, Set<V>>> e : m2.entrySet()) {
            CollectionsUtil.combineMapsOfSets(MapUtil.findOrCreateMap(m1, e.getKey()), e.getValue());
        }
    }

    public static <T, U> void combineMapsOfSets(Map<T, Set<U>> m1, Map<T, Set<U>> m2) {
        for (Map.Entry<T, Set<U>> e : m2.entrySet()) {
            MapUtil.findOrCreateSet(m1, e.getKey()).addAll((Collection)e.getValue());
        }
    }

    public static <T, U> void printMap(Map<T, U> m, Output o) {
        for (Map.Entry<T, U> e : m.entrySet()) {
            o.writeln(e.getKey() + "  -->  " + e.getValue());
        }
    }

    public static <T> Pair<Collection<T>, Collection<T>> compareCollections(Collection<T> a, Collection<T> b) {
        HashSet aCopy = HashSetFactory.make(a);
        HashSet bCopy = HashSetFactory.make(b);
        aCopy.removeAll(b);
        bCopy.removeAll(a);
        if (aCopy.isEmpty() && bCopy.isEmpty()) {
            System.out.println("a and b are equal");
        } else if (aCopy.isEmpty()) {
            System.out.println("b is a superset of a");
        } else if (bCopy.isEmpty()) {
            System.out.println("a is a superset of b");
        } else {
            System.out.println("a and b each contain unique elements");
        }
        return Pair.make((Object)aCopy, (Object)bCopy);
    }

    public static <T> boolean compareCollectionsWriteToFile(Collection<T> a, Collection<T> b, String outputFilename) {
        return CollectionsUtil.compareCollectionsWriteToFile(a, b, outputFilename, true);
    }

    public static <T> boolean compareCollectionsWriteToFile(Collection<T> a, Collection<T> b, String outputFilename, boolean append) {
        HashSet aClone = HashSetFactory.make();
        HashSet bClone = HashSetFactory.make();
        aClone.addAll(a);
        bClone.addAll(b);
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(outputFilename, append));
            out.write("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n");
            out.write("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n");
            if (a.containsAll(b) && b.containsAll(a)) {
                out.write("+++Sets are the same\n");
                out.write(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n");
                out.write(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n");
                out.write("\n");
                out.flush();
                out.close();
                return true;
            }
            out.write("---Sets are different\n");
            aClone.removeAll(b);
            bClone.removeAll(a);
            out.write("\nIn new but not old [" + aClone.size() + "]\n");
            out.write(((Object)aClone).toString());
            out.write("\n");
            out.write("\nIn old but not new [" + bClone.size() + "]\n");
            out.write(((Object)bClone).toString());
            out.write("\n");
            out.write(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n");
            out.write(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n");
            out.write("\n");
            out.flush();
            out.close();
            return false;
        }
        catch (IOException ioe) {
            if (DEBUG) {
                System.err.println("error printing debug info");
                System.err.println(ioe.toString());
                ioe.printStackTrace(System.err);
            }
            return false;
        }
    }

    public static <T> Collection<T> ordinalSetToCollection(OrdinalSet<T> os) {
        HashSet ret = HashSetFactory.make();
        for (Object t : os) {
            ret.add(t);
        }
        return ret;
    }

    public static <T> void addIteratorToSet(Iterator<T> t, Collection<T> workList) {
        while (t.hasNext()) {
            workList.add(t.next());
        }
    }
}

