/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.util;

import com.ibm.wala.andromeda.util.dependencyAnalysis.DAGraph;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.Decoder;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Iterator2Set;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.traverse.DFS;
import com.ibm.wala.util.graph.traverse.SlowDFSFinishTimeIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ScopePartitioning {
    public static Collection<Set<IClass>> partition(IClassHierarchy cha) throws InvalidClassFileException, Decoder.InvalidBytecodeException {
        AnalysisScope scope = cha.getScope();
        HashSet roots = HashSetFactory.make();
        HashSet appEntries = HashSetFactory.make();
        for (Module m : scope.getModules(ClassLoaderReference.Application)) {
            Iterator2Set S = Iterator2Collection.toSet((Iterator)m.getEntries());
            roots.addAll(S);
            appEntries.addAll(S);
        }
        for (Module m : scope.getModules(ClassLoaderReference.Extension)) {
            roots.addAll(Iterator2Collection.toSet((Iterator)m.getEntries()));
        }
        for (Module m : scope.getModules(ClassLoaderReference.Primordial)) {
            roots.addAll(Iterator2Collection.toSet((Iterator)m.getEntries()));
        }
        DAGraph daGraph = new DAGraph(roots);
        Graph<DAGraph.TypeNode> dependenciesGraph = daGraph.getTypeDependencyGraph();
        Graph<DAGraph.TypeNode> applicationOnlyBidirectionalEdgesGraph = ScopePartitioning.restrictToApplicationAndMakeBidirectional(cha, dependenciesGraph);
        HashSet rootTypes = HashSetFactory.make();
        for (ModuleEntry rootEntry : roots) {
            if (!appEntries.contains(rootEntry)) continue;
            rootTypes.add(daGraph.getNode(daGraph.getTypeForModuleEntry(rootEntry)));
        }
        SlowDFSFinishTimeIterator dfsIterator = new SlowDFSFinishTimeIterator(applicationOnlyBidirectionalEdgesGraph, rootTypes.iterator());
        ArrayList<Object> allNodes = new ArrayList<Object>();
        while (dfsIterator.hasNext()) {
            allNodes.add(dfsIterator.next());
        }
        HashSet SCCs = HashSetFactory.make();
        while (!allNodes.isEmpty()) {
            DAGraph.TypeNode current = (DAGraph.TypeNode)((Object)allNodes.get(allNodes.size() - 1));
            Set reachableNodes = DFS.getReachableNodes(applicationOnlyBidirectionalEdgesGraph, Collections.singleton(current));
            HashSet SCC = HashSetFactory.make();
            for (DAGraph.TypeNode tn : reachableNodes) {
                IClass c = ScopePartitioning.typeNode2class(cha, tn);
                if (c == null || !c.getClassLoader().getReference().equals((Object)ClassLoaderReference.Application)) continue;
                SCC.add(c);
            }
            SCCs.add(SCC);
            allNodes.removeAll(reachableNodes);
        }
        return SCCs;
    }

    private static IClass typeNode2class(IClassHierarchy cha, DAGraph.TypeNode tn) {
        String rawTypeName = tn.getType().getName().toString();
        TypeName name = TypeName.findOrCreate((String)rawTypeName.substring(0, rawTypeName.length() - 1));
        return cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Application, (TypeName)name));
    }

    private static Graph<DAGraph.TypeNode> restrictToApplicationAndMakeBidirectional(final IClassHierarchy cha, final Graph<DAGraph.TypeNode> dependenciesGraph) {
        Graph<DAGraph.TypeNode> bidirectionalAppOnly = new Graph<DAGraph.TypeNode>(){

            public void removeNodeAndEdges(DAGraph.TypeNode n) throws UnsupportedOperationException {
                Assertions.UNREACHABLE();
            }

            public void addNode(DAGraph.TypeNode n) {
                Assertions.UNREACHABLE();
            }

            public boolean containsNode(DAGraph.TypeNode n) {
                Assertions.UNREACHABLE();
                return dependenciesGraph.containsNode((Object)n);
            }

            public int getNumberOfNodes() {
                Assertions.UNREACHABLE();
                return dependenciesGraph.getNumberOfNodes();
            }

            public Iterator<DAGraph.TypeNode> iterator() {
                Assertions.UNREACHABLE();
                return dependenciesGraph.iterator();
            }

            public void removeNode(DAGraph.TypeNode n) {
                Assertions.UNREACHABLE();
            }

            public void addEdge(DAGraph.TypeNode src, DAGraph.TypeNode dst) {
                Assertions.UNREACHABLE();
            }

            public int getPredNodeCount(DAGraph.TypeNode n) {
                return Iterator2Collection.toSet(this.getPredNodes(n)).size();
            }

            public Iterator<DAGraph.TypeNode> getPredNodes(DAGraph.TypeNode n) {
                return this.getAppNeighborsIterator(n);
            }

            private Iterator<DAGraph.TypeNode> getAppNeighborsIterator(DAGraph.TypeNode n) {
                IClass c;
                Iterator2Set origPreds = Iterator2Collection.toSet((Iterator)dependenciesGraph.getPredNodes((Object)n));
                Iterator2Set origSuccs = Iterator2Collection.toSet((Iterator)dependenciesGraph.getSuccNodes((Object)n));
                HashSet result = HashSetFactory.make();
                for (DAGraph.TypeNode tn : origPreds) {
                    c = ScopePartitioning.typeNode2class(cha, tn);
                    if (c == null || !c.getClassLoader().getReference().equals((Object)ClassLoaderReference.Application)) continue;
                    result.add(tn);
                }
                for (DAGraph.TypeNode tn : origSuccs) {
                    c = ScopePartitioning.typeNode2class(cha, tn);
                    if (c == null || !c.getClassLoader().getReference().equals((Object)ClassLoaderReference.Application)) continue;
                    result.add(tn);
                }
                return result.iterator();
            }

            public int getSuccNodeCount(DAGraph.TypeNode N) {
                return Iterator2Collection.toSet(this.getSuccNodes(N)).size();
            }

            public Iterator<DAGraph.TypeNode> getSuccNodes(DAGraph.TypeNode n) {
                return this.getAppNeighborsIterator(n);
            }

            public boolean hasEdge(DAGraph.TypeNode src, DAGraph.TypeNode dst) {
                Assertions.UNREACHABLE();
                return Iterator2Collection.toSet(this.getAppNeighborsIterator(src)).contains((Object)dst);
            }

            public void removeAllIncidentEdges(DAGraph.TypeNode node) throws UnsupportedOperationException {
                Assertions.UNREACHABLE();
            }

            public void removeEdge(DAGraph.TypeNode src, DAGraph.TypeNode dst) throws UnsupportedOperationException {
                Assertions.UNREACHABLE();
            }

            public void removeIncomingEdges(DAGraph.TypeNode node) throws UnsupportedOperationException {
                Assertions.UNREACHABLE();
            }

            public void removeOutgoingEdges(DAGraph.TypeNode node) throws UnsupportedOperationException {
                Assertions.UNREACHABLE();
            }
        };
        return bidirectionalAppOnly;
    }
}

