/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.util;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.strings.StringStuff;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class SignatureUtil {
    private static final Map<String, Character> ounce2javaPrimitiveNames = HashMapFactory.make();

    public static String ounce2java(String methodSignature) {
        int index;
        String strippedReturnValue;
        int startIndex;
        int indexOfSquareBrackets;
        StringBuilder sb = new StringBuilder();
        int indexOfArgumentsStart = methodSignature.indexOf(40) + 1;
        sb.append(methodSignature.substring(0, indexOfArgumentsStart));
        int indexOfArgumentsEnd = methodSignature.indexOf(41);
        String argumentsString = methodSignature.substring(indexOfArgumentsStart, indexOfArgumentsEnd);
        String[] arguments = argumentsString.split(";");
        for (int i = 0; i < arguments.length; ++i) {
            String strippedArgument;
            if (arguments[i].isEmpty()) continue;
            indexOfSquareBrackets = -1;
            startIndex = 0;
            while ((indexOfSquareBrackets = arguments[i].indexOf("[]", startIndex)) >= 0) {
                startIndex = indexOfSquareBrackets + 1;
                sb.append('[');
            }
            String string = strippedArgument = arguments[i].indexOf(91) >= 0 ? arguments[i].substring(0, arguments[i].indexOf(91)) : arguments[i];
            if (ounce2javaPrimitiveNames.containsKey(strippedArgument)) {
                sb.append(ounce2javaPrimitiveNames.get(strippedArgument));
                continue;
            }
            sb.append("L" + strippedArgument + ";");
        }
        sb.append(')');
        String returnValue = methodSignature.substring(indexOfArgumentsEnd + 2);
        indexOfSquareBrackets = -1;
        startIndex = 0;
        while ((indexOfSquareBrackets = returnValue.indexOf("[]", startIndex)) >= 0) {
            startIndex = indexOfSquareBrackets + 1;
            sb.append('[');
        }
        String string = strippedReturnValue = returnValue.indexOf(91) >= 0 ? returnValue.substring(0, returnValue.indexOf(91)) : returnValue;
        if (ounce2javaPrimitiveNames.containsKey(strippedReturnValue)) {
            sb.append(ounce2javaPrimitiveNames.get(strippedReturnValue));
        } else {
            sb.append("L" + strippedReturnValue + ";");
        }
        int from = 0;
        int indexOfLeftParenthesis = sb.indexOf("(");
        while ((index = sb.indexOf(".", from++)) >= 0) {
            if (index <= indexOfLeftParenthesis) continue;
            sb.replace(index, index + 1, "/");
        }
        return sb.toString();
    }

    public static IMethod parseMethod(String methodSig, IClassHierarchy cha) {
        int paren = methodSig.indexOf(40);
        String typeAndName = methodSig.substring(0, paren);
        int lastDot = typeAndName.lastIndexOf(46);
        String type = methodSig.substring(0, lastDot);
        String selector = methodSig.substring(lastDot + 1);
        type = "L" + type.replace('.', '/');
        TypeName t = TypeName.findOrCreate((String)type);
        Selector s = SignatureUtil.toSelector(selector);
        for (IClassLoader l : cha.getLoaders()) {
            IMethod m;
            IClass klass;
            if (!cha.getScope().isApplicationLoader(l) || (klass = cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)l.getReference(), (TypeName)t))) == null || (m = klass.getMethod(s)) == null) continue;
            return m;
        }
        return null;
    }

    public static Selector toSelector(String s) {
        String name = s.substring(0, s.indexOf(40));
        String desc = s.substring(s.indexOf(40));
        Descriptor d = Descriptor.findOrCreateUTF8((String)desc);
        return new Selector(Atom.findOrCreateUnicodeAtom((String)name), d);
    }

    public static void main(String[] args) {
        String ounceSig1 = "java.lang.CharacterDataPrivateUse.isWhitespace(int):boolean";
        String javaSig1 = SignatureUtil.ounce2java(ounceSig1);
        System.out.println(javaSig1);
        String ounceSig2 = "java.lang.ClassNotFoundException.<init>(java.lang.String;java.lang.Throwable):void";
        String javaSig2 = SignatureUtil.ounce2java(ounceSig2);
        System.out.println(javaSig2);
        String ounceSig3 = "java.lang.EnumConstantNotPresentException.constantName():java.lang.String";
        String javaSig3 = SignatureUtil.ounce2java(ounceSig3);
        System.out.println(javaSig3);
        String ounceSig4 = "java.lang.ExceptionInInitializerError.<init>(java.lang.String):void";
        String javaSig4 = SignatureUtil.ounce2java(ounceSig4);
        System.out.println(javaSig4);
        String ounceSig5 = "org.apache.log4j.spi.VectorWriter.write(char[];java.lang.Throwable[]):void";
        String javaSig5 = SignatureUtil.ounce2java(ounceSig5);
        System.out.println(javaSig5);
        String ounceSig6 = "java.lang.EnumConstantNotPresentException.constantName():java.lang.String[][]";
        String javaSig6 = SignatureUtil.ounce2java(ounceSig6);
        System.out.println(javaSig6);
    }

    public static IClass getDeclaringClass(String sig, IClassHierarchy cha) {
        String declaringClass = sig.indexOf(46) >= 0 ? sig.substring(0, sig.lastIndexOf("..") == -1 ? sig.lastIndexOf(46) : sig.lastIndexOf("..")) : sig;
        declaringClass = StringStuff.deployment2CanonicalTypeString((String)declaringClass);
        for (IClassLoader l : cha.getLoaders()) {
            IClass klass;
            if (!cha.getScope().isApplicationLoader(l) || (klass = cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)l.getReference(), (String)declaringClass))) == null) continue;
            return klass;
        }
        return null;
    }

    public static IClass getDeclaringClassAllLoaders(String sig, IClassHierarchy cha) {
        String declaringClass = sig.substring(0, sig.lastIndexOf("..") == -1 ? sig.lastIndexOf(46) : sig.lastIndexOf(".."));
        declaringClass = StringStuff.deployment2CanonicalTypeString((String)declaringClass);
        return SignatureUtil.findClass(cha, declaringClass);
    }

    public static IClass findClass(IClassHierarchy cha, String typeName) {
        for (IClassLoader l : cha.getLoaders()) {
            TypeReference tr = TypeReference.findOrCreate((ClassLoaderReference)l.getReference(), (String)typeName);
            IClass c = cha.lookupClass(tr);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    public static boolean containsCompatibleSignature(Collection<String> signatures, Collection<IClass> concreteTypes, MethodReference mr) {
        String methodName = mr.getName().toString();
        String fullMethodSignature = methodName + mr.getDescriptor().toString();
        for (String sig : signatures) {
            if (SignatureUtil.isPartialSig(sig)) {
                if (!sig.endsWith(methodName)) continue;
                for (IClass concreteType : concreteTypes) {
                    if (!SignatureUtil.hasCompatibleMethod(concreteType, sig)) continue;
                    return true;
                }
                continue;
            }
            if (!sig.endsWith(fullMethodSignature)) continue;
            for (IClass concreteType : concreteTypes) {
                if (!SignatureUtil.hasCompatibleMethod(concreteType, sig)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasCompatibleMethod(IClass c, String signature) {
        IClassHierarchy cha = c.getClassHierarchy();
        IClass declaringClass = SignatureUtil.getDeclaringClass(signature, cha);
        return declaringClass != null && cha.isAssignableFrom(declaringClass, c);
    }

    public static Selector getSelector(String methodSig) {
        int paren = methodSig.indexOf(40);
        String typeAndName = methodSig.substring(0, paren);
        int lastDot = typeAndName.lastIndexOf(46);
        String selectorName = methodSig.substring(lastDot + 1);
        return SignatureUtil.toSelector(selectorName);
    }

    public static TypeReference getTypeReference(String methodSig) {
        String typeName = methodSig.substring(0, methodSig.lastIndexOf(46));
        return TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Application, (String)typeName);
    }

    public static boolean isPartialSig(String sourceSig) {
        return !sourceSig.contains("(");
    }

    public static boolean canBeReturnTypeOf(IClass c, IMethod m) {
        IClassHierarchy cha = m.getClassHierarchy();
        IClass returnTypeClass = cha.lookupClass(m.getReturnType());
        if (null == returnTypeClass) {
            return false;
        }
        return cha.isAssignableFrom(returnTypeClass, c) || cha.isAssignableFrom(c, returnTypeClass);
    }

    public static boolean isNestedInType(IClass klass, TypeReference t) {
        return klass.getName().toString().startsWith(t.getName().toString() + "$");
    }

    public static boolean isCompatibleWithSignature(IMethod method, String sig, Language l) {
        IClassHierarchy cha = method.getClassHierarchy();
        IClass declaringClass = method.getDeclaringClass();
        Set<IMethod> matches = SignatureUtil.findMatchingMethods(cha, Collections.singleton(sig), l);
        for (IMethod currentMethod : matches) {
            IClass currentDeclaringClass;
            if (!currentMethod.getName().equals((Object)method.getName()) || !currentMethod.getDescriptor().equals((Object)method.getDescriptor()) || !(currentDeclaringClass = currentMethod.getDeclaringClass()).equals(declaringClass) && !cha.isAssignableFrom(currentDeclaringClass, declaringClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCompatibleWithAny(IMethod method, Collection<String> methodSigs, Language l) {
        for (String methodSig : methodSigs) {
            if (!SignatureUtil.isCompatibleWithSignature(method, methodSig, l)) continue;
            return true;
        }
        return false;
    }

    private static IMethod getMostDerivedImplementation(Collection<IMethod> methods) {
        if (null == methods || methods.size() == 0) {
            return null;
        }
        IMethod result = methods.iterator().next();
        for (IMethod m : methods) {
            IClass curDeclaringClass = m.getDeclaringClass();
            IClass resultDeclaringClass = result.getDeclaringClass();
            assert (curDeclaringClass.getClassHierarchy().equals(resultDeclaringClass.getClassHierarchy()));
            IClassHierarchy cha = curDeclaringClass.getClassHierarchy();
            if (!cha.isAssignableFrom(resultDeclaringClass, curDeclaringClass)) continue;
            result = m;
        }
        return result;
    }

    public static Collection<Selector> partialSig2Selectors(String sig, IClassHierarchy cha) {
        HashSet result = HashSetFactory.make();
        IClass c = SignatureUtil.getDeclaringClass(sig, cha);
        if (c != null) {
            String methodName = sig.substring(sig.lastIndexOf(46) + 1, sig.length());
            Collection allMethods = c.getAllMethods();
            for (IMethod m : allMethods) {
                if (!m.getName().toString().equals(methodName)) continue;
                result.add(m.getSelector());
            }
        }
        return result;
    }

    public static Selector sig2Selector(String sig, IClassHierarchy cha, Language l) {
        IMethod m = SignatureUtil.sig2Method(sig, cha, l);
        return m == null ? null : m.getSelector();
    }

    public static Collection<Selector> sig2Selectors(String sig, IClassHierarchy cha, Language l) {
        Selector s;
        Collection<Object> ret = SignatureUtil.isPartialSig(sig) ? SignatureUtil.partialSig2Selectors(sig, cha) : ((s = SignatureUtil.sig2Selector(sig, cha, l)) == null ? Collections.emptySet() : Collections.singleton(s));
        return ret;
    }

    public static Collection<IMethod> partialSig2Methods(String sig, IClassHierarchy cha, Filter<IMethod> f) {
        HashSet result = HashSetFactory.make();
        IClass klass = SignatureUtil.getDeclaringClass(sig, cha);
        if (klass != null) {
            String methodName = sig.substring(sig.lastIndexOf(46) + 1, sig.length());
            Collection methods = null;
            methods = klass.getAllMethods();
            if (methods != null) {
                HashMap sortedMethods = HashMapFactory.make();
                for (IMethod method : methods) {
                    if (!method.getName().toString().equals(methodName)) continue;
                    String fullSig = method.getName().toString() + method.getDescriptor().toString();
                    if (!sortedMethods.containsKey(fullSig)) {
                        sortedMethods.put(fullSig, new HashSet());
                    }
                    ((Collection)sortedMethods.get(fullSig)).add(method);
                }
                for (Collection c : sortedMethods.values()) {
                    IMethod mostDerived = SignatureUtil.getMostDerivedImplementation(c);
                    if (mostDerived.isInit() && !mostDerived.getDeclaringClass().equals(klass) || !f.accepts((Object)mostDerived)) continue;
                    result.add(mostDerived);
                }
            }
        }
        return result;
    }

    public static synchronized IMethod sig2Method(String sig, IClassHierarchy cha, Language l) {
        IClass klass = SignatureUtil.getDeclaringClass(sig, cha);
        if (klass == null) {
            return null;
        }
        int methodNameStartIndex = (sig.contains("..") ? sig.lastIndexOf("..") : sig.lastIndexOf(46)) + 1;
        String selector = sig.substring(methodNameStartIndex);
        String name = selector.substring(0, selector.indexOf(40));
        String d = selector.substring(selector.indexOf(40));
        Atom a = Atom.findOrCreateUnicodeAtom((String)name);
        Descriptor dd = Descriptor.findOrCreateUTF8((Language)l, (String)d);
        IMethod m = klass.getMethod(new Selector(a, dd));
        return m;
    }

    public static synchronized IMethod sig2MethodAllLoaders(String sig, IClassHierarchy cha, Language l) {
        IClass klass = SignatureUtil.getDeclaringClassAllLoaders(sig, cha);
        if (klass == null) {
            return null;
        }
        int methodNameStartIndex = (sig.contains("..") ? sig.lastIndexOf("..") : sig.lastIndexOf(46)) + 1;
        String selector = sig.substring(methodNameStartIndex);
        String name = selector.substring(0, selector.indexOf(40));
        String d = selector.substring(selector.indexOf(40));
        Atom a = Atom.findOrCreateUnicodeAtom((String)name);
        Descriptor dd = Descriptor.findOrCreateUTF8((Language)l, (String)d);
        IMethod m = klass.getMethod(new Selector(a, dd));
        return m;
    }

    public static String sanitizeSignature(String methodSig) {
        return "L" + methodSig.replaceAll("\\.", "/");
    }

    public static Set<IMethod> findMatchingMethods(IClassHierarchy cha, Collection<String> sigs, Language l) {
        return SignatureUtil.findMatchingMethods(cha, sigs, new Filter<IMethod>(){

            public boolean accepts(IMethod m) {
                return true;
            }
        }, l);
    }

    public static Set<IMethod> findMatchingMethods(IClassHierarchy cha, String sig, Language l) {
        return SignatureUtil.findMatchingMethods(cha, sig, new Filter<IMethod>(){

            public boolean accepts(IMethod m) {
                return true;
            }
        }, l);
    }

    public static Set<IMethod> findMatchingMethods(IClassHierarchy cha, Collection<String> sigs, Filter<IMethod> f, Language l) {
        HashSet methods = HashSetFactory.make();
        for (String sig : sigs) {
            methods.addAll(SignatureUtil.findMatchingMethods(cha, sig, f, l));
        }
        return methods;
    }

    public static Set<IMethod> findMatchingMethods(IClassHierarchy cha, String sig, Filter<IMethod> f, Language l) {
        HashSet methods = HashSetFactory.make();
        if (SignatureUtil.isPartialSig(sig)) {
            Collection<IMethod> matches = SignatureUtil.partialSig2Methods(sig, cha, f);
            methods.addAll(matches);
        } else {
            IMethod matchingMethod = SignatureUtil.sig2Method(sig, cha, l);
            if (matchingMethod != null) {
                methods.add(matchingMethod);
            }
        }
        return methods;
    }

    static {
        ounce2javaPrimitiveNames.put("int", Character.valueOf('I'));
        ounce2javaPrimitiveNames.put("char", Character.valueOf('C'));
        ounce2javaPrimitiveNames.put("long", Character.valueOf('J'));
        ounce2javaPrimitiveNames.put("boolean", Character.valueOf('Z'));
        ounce2javaPrimitiveNames.put("double", Character.valueOf('D'));
        ounce2javaPrimitiveNames.put("float", Character.valueOf('F'));
        ounce2javaPrimitiveNames.put("short", Character.valueOf('S'));
        ounce2javaPrimitiveNames.put("void", Character.valueOf('V'));
        ounce2javaPrimitiveNames.put("byte", Character.valueOf('B'));
    }
}

