/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.thirdpartylib.dependency;

import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.utils.FileUtil;
import com.ibm.appscan.discovery.thirdpartylib.IThirdPartyLibConstants;
import com.ibm.appscan.discovery.thirdpartylib.dependency.IDependencyCollector;
import com.ibm.appscan.discovery.thirdpartylib.dependency.composer.ComposerDependencyCollector;
import com.ibm.appscan.discovery.thirdpartylib.dependency.conan.ConanDependencyCollector;
import com.ibm.appscan.discovery.thirdpartylib.dependency.dotnet.DotNetDependencyCollector;
import com.ibm.appscan.discovery.thirdpartylib.dependency.golang.GoDependencyCollector;
import com.ibm.appscan.discovery.thirdpartylib.dependency.gradle.GradleDependencyCollector;
import com.ibm.appscan.discovery.thirdpartylib.dependency.maven.MavenDependencyCollector;
import com.ibm.appscan.discovery.thirdpartylib.dependency.npm.NpmDependencyCollector;
import com.ibm.appscan.discovery.thirdpartylib.dependency.python.PythonDependencyCollector;
import java.io.File;

public class DependencyCollectorFactory
implements IThirdPartyLibConstants {
    public static IDependencyCollector getDependencyCollector(String file, ILogManager logManager) {
        return DependencyCollectorFactory.getDependencyCollector(new File(file), logManager);
    }

    public static IDependencyCollector getDependencyCollector(File file, ILogManager logManager) {
        IDependencyCollector collector = null;
        switch (file.getName().toLowerCase()) {
            case "build.gradle": 
            case "build.gradle.kts": {
                collector = new GradleDependencyCollector(file, logManager);
                break;
            }
            case "composer.json": {
                collector = new ComposerDependencyCollector(file, logManager);
                break;
            }
            case "package.json": {
                collector = new NpmDependencyCollector(file, logManager);
                break;
            }
            case "pom.xml": {
                collector = new MavenDependencyCollector(file, logManager);
                break;
            }
            case "go.mod": {
                collector = new GoDependencyCollector(file, logManager);
                break;
            }
            case "pyproject.toml": 
            case "requirements.txt": 
            case "setup.py": {
                collector = new PythonDependencyCollector(file, logManager);
                break;
            }
            case "conanfile.txt": 
            case "conanfile.py": {
                collector = new ConanDependencyCollector(file, logManager);
                break;
            }
        }
        if (collector == null) {
            switch (FileUtil.getFileExtension((File)file).toLowerCase()) {
                case "csproj": 
                case "vbproj": 
                case "vcxproj": 
                case "sln": {
                    collector = new DotNetDependencyCollector(file, logManager);
                    break;
                }
            }
        }
        return collector;
    }
}

