/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.thirdpartylib.dependency.maven;

import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.discovery.thirdpartylib.Messages;
import com.ibm.appscan.discovery.thirdpartylib.dependency.IDependencyCollector;
import com.ibm.appscan.discovery.thirdpartylib.utils.ThirdPartyLibUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MavenDependencyCollector
implements IDependencyCollector {
    private File m_pom;
    private ILogManager m_log;

    public MavenDependencyCollector(File pom, ILogManager logManager) {
        this.m_pom = pom;
        this.m_log = logManager;
    }

    @Override
    public String getExecutableName() {
        return "mvn";
    }

    @Override
    public String getStagingDirectoryName() {
        return "trivy";
    }

    @Override
    public File getWorkingDirectory() {
        return this.m_pom.getParentFile();
    }

    @Override
    public String getToolName() {
        return "Maven";
    }

    @Override
    public Map<File, String> getDependencies(File location, String uuid) throws IOException {
        HashMap<File, String> files = new HashMap<File, String>();
        ArrayList<String> args = new ArrayList();
        String outputFile = uuid + "_trivy_cyclon_report.json";
        ThirdPartyLibUtils.createTrivyStagingDir(location, this.m_log);
        if (this.resolvedMvnDependency()) {
            args = ThirdPartyLibUtils.getTrivyConfigArgs(location, this.m_pom, outputFile);
            try {
                this.m_log.log(new Message(1, Messages.getMessage("executing.trivy.command", new Object[0])));
                this.run(ThirdPartyLibUtils.getTrivyExe(), args, null);
            }
            catch (IOException e) {
                this.m_log.log((Exception)e);
            }
            files.put(new File(location, outputFile), this.m_pom.getAbsolutePath());
        }
        return files;
    }

    private boolean resolvedMvnDependency() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("dependency:resolve");
        args.add("-U");
        try {
            return this.run(this.getExecutableName(), args, null) == 0;
        }
        catch (IOException e) {
            this.m_log.log((Exception)e);
            return false;
        }
    }

    @Override
    public boolean shouldProcessDependencies() {
        return true;
    }
}

