/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.thirdpartylib.dependency.python;

import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.thirdpartylib.Messages;
import com.ibm.appscan.discovery.thirdpartylib.dependency.IDependencyCollector;
import com.ibm.appscan.discovery.thirdpartylib.dependency.poetry.PoetryDependencyCollector;
import com.ibm.appscan.discovery.thirdpartylib.dependency.pypi.PipDependencyCollector;
import com.ibm.appscan.discovery.thirdpartylib.utils.PythonUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class PythonDependencyCollector
implements IDependencyCollector {
    private IDependencyCollector m_collector;
    private File m_pythonConfigFile;
    private ILogManager m_log;

    public PythonDependencyCollector(File pythonConfigFile, ILogManager logManager) {
        this.m_pythonConfigFile = pythonConfigFile;
        this.m_log = logManager;
        this.m_collector = null;
    }

    @Override
    public String getExecutableName() {
        if (PythonUtils.isTomlFile(this.m_pythonConfigFile, this.getWorkingDirectory())) {
            return "Poetry".toLowerCase();
        }
        if (SystemUtil.isWindows()) {
            return "Python".toLowerCase();
        }
        return "Python3".toLowerCase();
    }

    @Override
    public String getStagingDirectoryName() {
        return this.m_collector.getStagingDirectoryName();
    }

    @Override
    public File getWorkingDirectory() {
        return this.m_pythonConfigFile.getParentFile();
    }

    @Override
    public String getToolName() {
        if (PythonUtils.isTomlFile(this.m_pythonConfigFile, this.getWorkingDirectory())) {
            return "Poetry";
        }
        return "Python";
    }

    @Override
    public Map<File, String> getDependencies(File location, String name) throws IOException {
        return this.m_collector.getDependencies(location, name);
    }

    @Override
    public boolean isToolInstalled() {
        return this.m_collector.isToolInstalled();
    }

    @Override
    public boolean shouldProcessDependencies() {
        ArrayList<String> args = new ArrayList<String>();
        if (PythonUtils.isTomlFile(this.m_pythonConfigFile, this.getWorkingDirectory())) {
            args.add("Version".toLowerCase());
            try {
                if (this.run(args, null) == 0) {
                    this.m_collector = new PoetryDependencyCollector(this.m_pythonConfigFile, this.m_log);
                    return this.m_collector.shouldProcessDependencies();
                }
            }
            catch (IOException e) {
                if (PythonUtils.requirementsTxtFileExists(this.getWorkingDirectory())) {
                    this.m_pythonConfigFile = new File(this.getWorkingDirectory(), "requirements.txt");
                    this.m_collector = new PipDependencyCollector(this.m_pythonConfigFile, this.m_log);
                    return this.m_collector.shouldProcessDependencies();
                }
                if (PythonUtils.setupPyFileExists(this.getWorkingDirectory())) {
                    this.m_pythonConfigFile = new File(this.getWorkingDirectory(), "setup.py");
                    this.m_collector = new PipDependencyCollector(this.m_pythonConfigFile, this.m_log);
                    return this.m_collector.shouldProcessDependencies();
                }
                this.m_log.log((Exception)e);
            }
            return false;
        }
        if (PythonUtils.isPythonVersionSupported()) {
            this.m_collector = new PipDependencyCollector(this.m_pythonConfigFile, this.m_log);
            return this.m_collector.shouldProcessDependencies();
        }
        this.m_log.log(new Message(1, Messages.getMessage("python.version.not.supported", PythonUtils.getPythonVersion(), "3.8")));
        return false;
    }
}

