/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.cloud.commands;

import com.ibm.appscan.cli.cloud.Messages;
import com.ibm.appscan.cli.cloud.handlers.QueueAnalysisHandler;
import com.ibm.appscan.cli.common.components.Command;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class QueueAnalysisCommand
extends Command {
    private QueueAnalysisHandler m_handler = new QueueAnalysisHandler();

    public QueueAnalysisCommand() {
    }

    public QueueAnalysisCommand(String[] args) {
        super(args);
    }

    public void configure() {
        this.setNamespace(Messages.getMessage("command.analyze.namespace", new Object[0]));
        this.setName("queue_analysis");
        this.setDescription(Messages.getMessage("command.queueanalysis.description", new Object[0]));
        this.setOptions(this.buildOptions(), false);
    }

    public Command createCommand(String[] args) {
        return new QueueAnalysisCommand(args);
    }

    public void execute() {
        CommandLine cmd = this.getCommandLine();
        if (cmd == null) {
            return;
        }
        String scanName = null;
        String scanFile = null;
        String appId = null;
        if (cmd.hasOption("n")) {
            scanName = cmd.getOptionValue("n");
        }
        if (cmd.hasOption("f")) {
            scanFile = cmd.getOptionValue("f");
        }
        if (cmd.hasOption("a")) {
            appId = cmd.getOptionValue("a");
        }
        if (cmd.hasOption("c")) {
            this.m_handler.setComment(cmd.getOptionValue("c"));
        }
        if (cmd.hasOption("ps")) {
            this.m_handler.setPersonalScan(true);
        }
        if (cmd.hasOption("e") && cmd.getOptionValue("e").equalsIgnoreCase("false")) {
            this.m_handler.setEmail(false);
        }
        if (cmd.hasOption("nen")) {
            this.m_handler.setEmail(false);
        }
        if (cmd.hasOption("di")) {
            this.m_handler.setDisableIntervention(true);
        }
        if (cmd.hasOption("oso")) {
            System.setProperty("OPENSOURCE_ONLY", "");
        }
        if (cmd.hasOption("sao")) {
            System.setProperty("STATIC_ANALYSIS_ONLY", "");
        }
        this.m_handler.queueAnalysis(scanName, scanFile, appId);
    }

    protected Options getVisibleOptions(Options options) {
        Options visibleOptions = new Options();
        for (Object obj : options.getOptions()) {
            Option opt = (Option)obj;
            if ("c".equals(opt.getOpt())) continue;
            visibleOptions.addOption(opt);
        }
        return visibleOptions;
    }

    protected Options buildOptions() {
        Options options = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)Messages.getMessage("option.scanName.argument", new Object[0]));
        OptionBuilder.withDescription((String)Messages.getMessage("option.scanName.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"n"));
        options.addOption("f", true, Messages.getMessage("option.scanFile.description", new Object[0]));
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withArgName((String)Messages.getMessage("option.appid.argument", new Object[0]));
        OptionBuilder.withDescription((String)Messages.getMessage("option.appid.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"a"));
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withArgName((String)Messages.getMessage("option.scanComment.argument", new Object[0]));
        OptionBuilder.withDescription((String)Messages.getMessage("option.scanComment.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withArgName((String)Messages.getMessage("option.emailnotification.argument", new Object[0]));
        OptionBuilder.withDescription((String)Messages.getMessage("option.emailnotification.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"e"));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)Messages.getMessage("option.noemailnotification.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"nen"));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)Messages.getMessage("option.personalscan.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"ps"));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)Messages.getMessage("option.openSourceOnly.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"oso"));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)Messages.getMessage("option.staticAnalysisOnly.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"sao"));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)Messages.getMessage("option.disable.intervention.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"di"));
        return options;
    }
}

