/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.cloud.handlers;

import com.ibm.appscan.cli.cloud.Messages;
import com.ibm.appscan.cli.cloud.auth.providers.AuthenticationProvider;
import com.ibm.appscan.cli.cloud.handlers.ReportHandler;
import com.ibm.appscan.cli.cloud.handlers.SAHandler;
import com.ibm.appscan.cli.cloud.reports.SecurityReport;
import com.ibm.appscan.cli.common.ProgressAdapter;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.FileUtil;
import com.ibm.appscan.common.utils.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.json.JSONException;

public class GetReportHandler
extends SAHandler {
    private String m_scope = null;
    private String m_type = null;
    private String m_format = null;
    private File m_destination = null;
    private String m_reportTitle = "AppScan Security Report";
    private String m_reportLocale = "en";
    private String m_regReportType = null;
    private boolean m_applyPolicies = false;
    private String REG_REPORT_PATTERN = "^[a-zA-z0-9_]*$";
    private String REPORT_TITLE_PATTERN = "^[a-zA-z0-9_\\s]*$";
    private String REPORT_LOCALE_PATTERN = "^[a-zA-z_]*$";
    private String[] reportTypes = new String[]{"issues", "security", "regulation", "license"};
    private String[] reportScopes = new String[]{"application", "scan"};
    private String[] reportFormats = new String[]{"pdf", "html", "xml", "csv"};
    private AuthenticationProvider m_authProvider = AuthenticationProvider.getInstance();

    public void setApplyPolicies(boolean applyPolicies) {
        this.m_applyPolicies = applyPolicies;
    }

    private boolean validateString(String stringToValidate, String pattern) {
        return stringToValidate.matches(pattern);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getResult(String scanId, String reportType, String reportScope, String saveLocation, String reportFormat, String regReportType, String reportTitle, String reportLocale) throws AppScanException, JSONException {
        SecurityReport reportJSONOptions;
        Integer timeToSleep;
        block40: {
            block41: {
                block39: {
                    ArrayList<String> validOptions;
                    block38: {
                        block36: {
                            block37: {
                                block35: {
                                    this.setProgressAdapter((IProgress)new ProgressAdapter());
                                    scanId = StringUtil.getCleanUuid((String)scanId);
                                    timeToSleep = 10000;
                                    validOptions = null;
                                    try {
                                        if (this.m_authProvider.isTokenExpired()) {
                                            return;
                                        }
                                    }
                                    catch (SSLHandshakeException e) {
                                        this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("err.ssl", this.m_authProvider.getServer())));
                                    }
                                    catch (IOException e) {
                                        this.getProgressAdapter().setStatus(new Message((Throwable)e));
                                    }
                                    validOptions = new ArrayList<String>(Arrays.asList(this.reportScopes));
                                    if (reportScope == null || !validOptions.contains(reportScope.toLowerCase())) break block35;
                                    this.m_scope = reportScope;
                                    validOptions = new ArrayList<String>(Arrays.asList(this.reportFormats));
                                    if (!"issues".equalsIgnoreCase(reportType)) break block36;
                                    break block37;
                                }
                                this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("job.getreport.unknown.scope", reportScope)));
                                return;
                            }
                            this.m_format = "json";
                            break block38;
                        }
                        if (reportFormat != null) {
                            if (!validOptions.contains(reportFormat.toLowerCase())) {
                                this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("job.getreport.unknown.format", reportFormat)));
                                return;
                            }
                            this.m_format = reportFormat;
                        } else {
                            this.m_format = "pdf";
                        }
                    }
                    if (regReportType != null) {
                        if (this.validateString(regReportType, this.REG_REPORT_PATTERN)) {
                            this.m_regReportType = regReportType;
                        } else {
                            this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("job.getreport.unknown.regformat", regReportType)));
                        }
                    }
                    if (reportTitle != null) {
                        if (this.validateString(reportTitle = reportTitle.replace("\"", ""), this.REPORT_TITLE_PATTERN)) {
                            this.m_reportTitle = reportTitle;
                        } else {
                            this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("job.getreport.invalid.reporttitle", reportTitle)));
                        }
                    }
                    if (reportLocale != null) {
                        if (this.validateString(reportLocale, this.REPORT_LOCALE_PATTERN)) {
                            this.m_reportLocale = reportLocale;
                        } else {
                            this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("job.getreport.invalid.reportlocale", reportLocale)));
                        }
                    }
                    this.m_destination = saveLocation != null ? new File(saveLocation) : new File(System.getProperty("user.dir"));
                    if (!FileUtil.isValidFilename((String)this.m_destination.getName())) {
                        this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("err.invalid.characters", saveLocation)));
                        return;
                    }
                    validOptions = new ArrayList<String>(Arrays.asList(this.reportTypes));
                    if (reportType == null || !validOptions.contains(reportType.toLowerCase())) break block39;
                    this.m_type = reportType.toLowerCase();
                    reportJSONOptions = new SecurityReport(this.m_format, this.m_applyPolicies, this.m_reportTitle, this.m_reportLocale, this.m_regReportType, this.m_type);
                    if (FileUtil.getFileExtension((File)this.m_destination).isEmpty()) break block40;
                    break block41;
                }
                this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("job.getreport.unknown.type", reportType)));
                return;
            }
            if (!FileUtil.getFileExtension((File)this.m_destination).equals(reportJSONOptions.getFormat())) {
                this.m_destination = new File(this.m_destination.getPath().substring(0, this.m_destination.getPath().length() - FileUtil.getFileExtension((File)this.m_destination).length()) + reportJSONOptions.getFormat());
            }
        }
        try {
            String reportJobID = this.queueReportJob(scanId, this.m_type, this.m_scope, reportJSONOptions.options().toString(), this.m_regReportType);
            if (reportJobID == null) throw new IOException(Messages.getMessage("err.report.id.null", new Object[0]));
            ReportHandler reportUtil = new ReportHandler();
            this.getProgressAdapter().setStatus(new Message(1, Messages.getMessage("job.getreport.queuesuccess", reportJobID)));
            this.getProgressAdapter().setStatus(new Message(1, Messages.getMessage("job.getreport.waiting", new Object[0])));
            String jobStatus = null;
            int loop = 30;
            int i = 0;
            while (true) {
                if (i >= loop) {
                    reportUtil.downloadReport(reportJobID, this.setDownloadLocation(this.m_destination, reportJSONOptions.getFormat()));
                    if (!this.m_destination.exists()) throw new IOException(Messages.getMessage("err.report.download", new Object[0]));
                    this.getProgressAdapter().setStatus(new Message(1, Messages.getMessage("job.getreport.success", new Object[0])));
                    this.getProgressAdapter().setStatus(new Message(1, Messages.getMessage("job.getreport.location", this.m_destination.getCanonicalPath())));
                    return;
                }
                try {
                    jobStatus = reportUtil.getReportStatus(reportJobID).get("Status").toString();
                    switch (jobStatus.toUpperCase()) {
                        case "READY": {
                            i = loop;
                            break;
                        }
                        case "FAILED": 
                        case "DELETED": {
                            throw new IOException(Messages.getMessage("err.report.generation", new Object[0]));
                        }
                        default: {
                            try {
                                Thread.sleep(timeToSleep.intValue());
                            }
                            catch (InterruptedException e) {
                                this.getProgressAdapter().setStatus(new Message(1, "Unable to Sleep"));
                            }
                            break;
                        }
                    }
                }
                catch (IOException e) {
                    this.getProgressAdapter().setStatus(new Message(1, Messages.getMessage("err.checking.status", e.getMessage())));
                }
                ++i;
            }
        }
        catch (IOException | JSONException e) {
            this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("job.getreport.error", e.getMessage())));
        }
    }
}

