/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.cloud.handlers;

import com.ibm.appscan.cli.cloud.handlers.SAHandler;
import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.common.ProgressAdapter;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.StringUtil;
import java.io.IOException;
import org.apache.commons.json.JSON;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class InfoHandler
extends SAHandler {
    public void info(String scanId, boolean jsonOutput) throws AppScanException {
        this.doInfo(StringUtil.getCleanUuid((String)scanId), jsonOutput);
    }

    private void doInfo(String jobID, boolean jsonOutput) {
        this.setProgressAdapter((IProgress)new ProgressAdapter());
        try {
            if (this.isTokenExpired()) {
                return;
            }
            JSONObject content = this.getScanDetails(jobID);
            if (jsonOutput) {
                CommonCLICore.getIOConsole().println(content.toString());
            } else if (content != null) {
                if (content.keySet().contains("Message")) {
                    Message errorMessage = new Message(4, content.getString("Message"));
                    this.getProgressAdapter().setStatus(errorMessage);
                } else {
                    JSONArray keys = content.names();
                    for (int i = 0; i < keys.size(); ++i) {
                        String value = "";
                        if (content.get(keys.getString(i)) != JSON.NULL) {
                            value = content.getString(keys.getString(i));
                        }
                        String message = keys.getString(i) + "=" + value;
                        CommonCLICore.getIOConsole().println(message);
                    }
                }
            }
        }
        catch (JSONException e) {
            this.getProgressAdapter().setStatus(new Message((Throwable)e));
        }
        catch (IOException e) {
            this.getProgressAdapter().setStatus(new Message((Throwable)e));
        }
    }
}

