/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.cloud.reports;

import com.ibm.appscan.cli.cloud.Messages;
import com.ibm.appscan.cli.cloud.reports.IReportConfig;
import com.ibm.appscan.cli.common.ProgressAdapter;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.SaaSConstants;
import com.ibm.appscan.common.logging.Message;
import java.util.Map;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class SecurityReport
implements IReportConfig,
SaaSConstants {
    private String m_format;
    private String m_regulationReportType;
    private String m_reportTitle;
    private String m_reportLocale;
    private boolean m_applyPolicies;
    private IProgress m_progress = new ProgressAdapter();

    public SecurityReport(String format, boolean applyPolicies, String reportTitle, String reportLocale, String regReportType, String reportType) {
        this.m_format = this.getReportFormat(format, reportType);
        this.m_regulationReportType = regReportType;
        this.m_applyPolicies = applyPolicies;
        this.m_reportTitle = reportTitle;
        this.m_reportLocale = reportLocale;
    }

    @Override
    public JSONObject options() throws JSONException {
        JSONObject reportOptions = this.getPolicyOptions();
        JSONObject reportConfigOptions = new JSONObject();
        reportConfigOptions.put("Summary", true);
        reportConfigOptions.put("Details", true);
        reportConfigOptions.put("Discussion", true);
        reportConfigOptions.put("Overview", true);
        reportConfigOptions.put("TableOfContents", true);
        reportConfigOptions.put("Advisories", true);
        reportConfigOptions.put("FixRecommendation", true);
        reportConfigOptions.put("History", true);
        reportConfigOptions.put("Coverage", true);
        reportConfigOptions.put("MinimizeDetails", true);
        reportConfigOptions.put("Articles", true);
        reportConfigOptions.put("ReportFileType", (Object)this.m_format);
        reportConfigOptions.put("Title", (Object)this.m_reportTitle);
        reportConfigOptions.put("Locale", (Object)this.m_reportLocale);
        reportConfigOptions.put("RegulationReportType", (Object)this.m_regulationReportType);
        reportOptions.put("Configuration", (Map)reportConfigOptions);
        return reportOptions;
    }

    @Override
    public String getFormat() throws JSONException {
        return this.m_format;
    }

    private JSONObject getPolicyOptions() throws JSONException {
        JSONObject policyData = new JSONObject();
        policyData.put("ApplyPolicies", (Object)(this.m_applyPolicies ? "All" : "None"));
        return policyData;
    }

    private String getReportFormat(String format, String reportType) {
        if ("issues".equalsIgnoreCase(reportType)) {
            this.m_progress.setStatus(new Message(4, Messages.getMessage("issues.report.changed.format", new Object[0])));
            return "json";
        }
        if ("regulation".equalsIgnoreCase(reportType) && !"html".equalsIgnoreCase(format) & !"pdf".equalsIgnoreCase(format)) {
            this.m_progress.setStatus(new Message(4, Messages.getMessage("regualtion.report.changed.format", new Object[0])));
            return "pdf";
        }
        return format;
    }
}

