/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.callgraph.fieldbased;

import com.ibm.wala.cast.js.callgraph.fieldbased.FieldBasedCallGraphBuilder;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.FlowGraph;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.CallVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.FuncVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.VarVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.VertexFactory;
import com.ibm.wala.cast.js.ipa.callgraph.JSAnalysisOptions;
import com.ibm.wala.cast.js.ssa.JavaScriptInvoke;
import com.ibm.wala.cast.js.types.JavaScriptMethods;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.intset.OrdinalSet;
import java.util.HashSet;
import java.util.Set;

public class OptimisticCallgraphBuilder
extends FieldBasedCallGraphBuilder {
    public int ITERATION_CUTOFF = Integer.MAX_VALUE;
    private final boolean handleCallApply;

    public OptimisticCallgraphBuilder(IClassHierarchy cha, AnalysisOptions options, AnalysisCache cache, boolean supportFullPointerAnalysis) {
        super(cha, options, cache, supportFullPointerAnalysis);
        this.handleCallApply = options instanceof JSAnalysisOptions && ((JSAnalysisOptions)options).handleCallApply();
    }

    @Override
    public FlowGraph buildFlowGraph(MonitorUtil.IProgressMonitor monitor) throws CancelException {
        FlowGraph flowgraph = this.flowGraphFactory();
        HashSet knownEdges = HashSetFactory.make();
        boolean changed = true;
        int iter = 0;
        while (iter++ < this.ITERATION_CUTOFF && changed) {
            MonitorUtil.throwExceptionIfCanceled((MonitorUtil.IProgressMonitor)monitor);
            changed = false;
            Set<Pair<CallVertex, FuncVertex>> newEdges = this.extractCallGraphEdges(flowgraph, monitor);
            for (Pair<CallVertex, FuncVertex> edge : newEdges) {
                MonitorUtil.throwExceptionIfCanceled((MonitorUtil.IProgressMonitor)monitor);
                boolean newEdge = knownEdges.add(edge);
                boolean bl = changed = changed || newEdge;
                if (!newEdge) continue;
                this.addEdge(flowgraph, (CallVertex)edge.fst, (FuncVertex)edge.snd, monitor);
                if (!this.handleCallApply || !((FuncVertex)edge.snd).getFullName().equals("Lprologue.js/Function_prototype_call") && !((FuncVertex)edge.snd).getFullName().equals("Lprologue.js/Function_prototype_apply")) continue;
                this.addReflectiveCallEdge(flowgraph, (CallVertex)edge.fst, monitor);
            }
        }
        return flowgraph;
    }

    private void addEdge(FlowGraph flowgraph, CallVertex c, FuncVertex callee, MonitorUtil.IProgressMonitor monitor) throws CancelException {
        VertexFactory factory = flowgraph.getVertexFactory();
        JavaScriptInvoke invk = c.getInstruction();
        FuncVertex caller = c.getCaller();
        int offset = 0;
        if (invk.getDeclaredTarget().getSelector().equals((Object)JavaScriptMethods.ctorReference.getSelector())) {
            offset = 1;
        }
        for (int i = 0; i < invk.getNumberOfParameters(); ++i) {
            flowgraph.addEdge(factory.makeVarVertex(caller, invk.getUse(i)), factory.makeArgVertex(callee));
            flowgraph.addEdge(factory.makeVarVertex(caller, invk.getUse(i)), factory.makeParamVertex(callee, i + offset));
        }
        flowgraph.addEdge(factory.makeRetVertex(callee), factory.makeVarVertex(caller, invk.getDef()));
    }

    private void addReflectiveCallEdge(FlowGraph flowgraph, CallVertex c, MonitorUtil.IProgressMonitor monitor) throws CancelException {
        VertexFactory factory = flowgraph.getVertexFactory();
        FuncVertex caller = c.getCaller();
        JavaScriptInvoke invk = c.getInstruction();
        VarVertex receiverVertex = factory.makeVarVertex(caller, invk.getUse(1));
        OrdinalSet<FuncVertex> realCallees = flowgraph.getReachingSet(receiverVertex, monitor);
        for (FuncVertex realCallee : realCallees) {
            for (int i = 2; i < invk.getNumberOfParameters(); ++i) {
                flowgraph.addEdge(factory.makeVarVertex(caller, invk.getUse(i)), factory.makeParamVertex(realCallee, i - 1));
            }
            flowgraph.addEdge(factory.makeRetVertex(realCallee), factory.makeVarVertex(caller, invk.getDef()));
        }
    }
}

