/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction;

import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.ChildPos;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.ExtractionRegion;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.LabelPos;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.NodePos;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.PosSwitch;
import com.ibm.wala.cast.js.ipa.callgraph.correlations.extraction.RootPos;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ExtractionPos
extends NodePos {
    private final CAstNode parent;
    private final ExtractionRegion region;
    private final NodePos parent_pos;
    private boolean contains_return;
    private boolean contains_this;
    private final Set<Pair<String, CAstNode>> goto_targets = HashSetFactory.make();
    private boolean contains_outer_goto;
    private final Set<ExtractionPos> nested_loops = HashSetFactory.make();
    private CAstEntity extracted_entity;
    private CAstNode callsite;

    public ExtractionPos(CAstNode parent, ExtractionRegion region, NodePos parent_pos) {
        this.parent = parent;
        this.region = region;
        this.parent_pos = parent_pos;
    }

    public CAstNode getParent() {
        return this.parent;
    }

    public int getStart() {
        return this.region.getStart();
    }

    public int getEnd() {
        return this.region.getEnd();
    }

    public ExtractionRegion getRegion() {
        return this.region;
    }

    public boolean contains(CAstNode node) {
        for (int i = this.getStart(); i < this.getEnd(); ++i) {
            if (!NodePos.inSubtree(node, this.parent.getChild(i))) continue;
            return true;
        }
        return false;
    }

    public List<String> getParameters() {
        return this.region.getParameters();
    }

    public void addGotoTarget(String label, CAstNode node) {
        ExtractionPos outer = ExtractionPos.getEnclosingExtractionPos(this.parent_pos);
        if (outer != null && !outer.contains(node)) {
            outer.addGotoTarget(label, node);
            this.contains_outer_goto = true;
        } else {
            this.goto_targets.add((Pair<String, CAstNode>)Pair.make((Object)label, (Object)node));
        }
    }

    public boolean containsReturn() {
        return this.contains_return;
    }

    public void addReturn() {
        this.contains_return = true;
    }

    public Set<Pair<String, CAstNode>> getGotoTargets() {
        return Collections.unmodifiableSet(this.goto_targets);
    }

    public void addThis() {
        this.contains_this = true;
    }

    public boolean containsThis() {
        return this.contains_this;
    }

    public boolean containsGoto() {
        return !this.getGotoTargets().isEmpty();
    }

    public boolean containsOuterGoto() {
        return this.contains_outer_goto;
    }

    public boolean containsJump() {
        return this.containsGoto() || this.containsReturn() || this.containsOuterGoto();
    }

    public String getThisParmName() {
        return "thi$";
    }

    public void addNestedPos(ExtractionPos loop) {
        this.nested_loops.add(loop);
    }

    public Iterator<ExtractionPos> getNestedLoops() {
        return this.nested_loops.iterator();
    }

    public void setExtractedEntity(CAstEntity entity) {
        assert (this.extracted_entity == null) : "Cannot reset extracted entity.";
        this.extracted_entity = entity;
    }

    public CAstEntity getExtractedEntity() {
        assert (this.extracted_entity != null) : "Extracted entity not set.";
        return this.extracted_entity;
    }

    public void setCallSite(CAstNode callsite) {
        assert (this.callsite == null) : "Cannot reset call site.";
        this.callsite = callsite;
    }

    public CAstNode getCallSite() {
        assert (this.callsite != null) : "Call site not set.";
        return this.callsite;
    }

    @Override
    public <A> A accept(PosSwitch<A> ps) {
        return ps.caseForInLoopBodyPos(this);
    }

    public static ExtractionPos getOutermostEnclosingExtractionPos(NodePos pos) {
        return pos.accept(new PosSwitch<ExtractionPos>(){

            @Override
            public ExtractionPos caseRootPos(RootPos pos) {
                return null;
            }

            @Override
            public ExtractionPos caseChildPos(ChildPos pos) {
                int kind = pos.getParent().getKind();
                if (kind == 13 || kind == 100) {
                    return null;
                }
                return ExtractionPos.getOutermostEnclosingExtractionPos(pos.getParentPos());
            }

            @Override
            public ExtractionPos caseForInLoopBodyPos(ExtractionPos pos) {
                ExtractionPos outer = ExtractionPos.getEnclosingExtractionPos(pos.getParentPos());
                return outer == null ? pos : outer;
            }

            @Override
            public ExtractionPos caseLabelPos(LabelPos pos) {
                return ExtractionPos.getOutermostEnclosingExtractionPos(pos.getParentPos());
            }
        });
    }

    public static ExtractionPos getEnclosingExtractionPos(NodePos pos) {
        return pos.accept(new PosSwitch<ExtractionPos>(){

            @Override
            public ExtractionPos caseRootPos(RootPos pos) {
                return null;
            }

            @Override
            public ExtractionPos caseChildPos(ChildPos pos) {
                int kind = pos.getParent().getKind();
                if (kind == 13 || kind == 100) {
                    return null;
                }
                return ExtractionPos.getEnclosingExtractionPos(pos.getParentPos());
            }

            @Override
            public ExtractionPos caseForInLoopBodyPos(ExtractionPos pos) {
                return pos;
            }

            @Override
            public ExtractionPos caseLabelPos(LabelPos pos) {
                return ExtractionPos.getEnclosingExtractionPos(pos.getParentPos());
            }
        });
    }

    public boolean isOutermost() {
        return ExtractionPos.getEnclosingExtractionPos(this.parent_pos) == null;
    }

    public NodePos getParentPos() {
        return this.parent_pos;
    }
}

