/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.vs.utils;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.vs.Messages;
import com.ibm.appscan.discovery.vs.targets.AspNetTargetAdapter;
import com.ibm.appscan.discovery.vs.targets.AssemblyTargetAdapter;
import com.ibm.appscan.discovery.vs.targets.CppSourceTargetAdapter;
import com.ibm.appscan.discovery.vs.targets.CppTargetAdapter;
import com.ibm.appscan.discovery.vs.targets.DotNetSourceTargetAdapter;
import com.ibm.appscan.discovery.vs.targets.IDotNetTargetAdapter;
import com.ibm.appscan.discovery.vs.targets.PublishedCoreTargetAdapter;
import java.io.File;
import java.util.Properties;

public class VSAdapterFactory {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IDotNetTargetAdapter createTarget(Properties props, IProgress progress) throws AppScanException {
        void var2_11;
        String output = (String)props.remove("output");
        if (SystemUtil.isSourceCodeOnly()) {
            String projectFile = (String)props.remove("project_file");
            if (System.getProperty("enableSingleZip") != null && (projectFile.toLowerCase().endsWith(".vcxproj") || projectFile.toLowerCase().endsWith(".vcproj"))) {
                CppSourceTargetAdapter cppSourceTargetAdapter = new CppSourceTargetAdapter(new File(projectFile), props);
                return var2_11;
            } else {
                DotNetSourceTargetAdapter dotNetSourceTargetAdapter = new DotNetSourceTargetAdapter(new File(projectFile), props);
            }
            return var2_11;
        } else if (output == null) {
            String projectFile = (String)props.remove("project_file");
            if (projectFile == null) throw new AppScanException("");
            CppTargetAdapter cppTargetAdapter = new CppTargetAdapter(new File(projectFile), props);
            return var2_11;
        } else {
            File file = new File(output);
            if (file.isFile() && file.getName().endsWith(".deps.json")) {
                PublishedCoreTargetAdapter publishedCoreTargetAdapter = new PublishedCoreTargetAdapter(file.getParentFile(), props);
                return var2_11;
            } else if (file.isFile()) {
                AssemblyTargetAdapter assemblyTargetAdapter = new AssemblyTargetAdapter(file, props);
                return var2_11;
            } else if (file.isDirectory() && !output.trim().isEmpty()) {
                AspNetTargetAdapter aspNetTargetAdapter = new AspNetTargetAdapter(file, props);
                return var2_11;
            } else {
                String log = new File(CommonCore.getDirectoryLocator().getLogs(), "vs.log").getAbsolutePath();
                String error = Messages.getMessage("output.missing.error", file.getPath(), log);
                throw new AppScanException(error);
            }
        }
    }
}

