/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.vs;

import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.ScanModelFactory;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.Strategy;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;

public class CppProjectStrategy
extends Strategy {
    private File m_projectFile;
    private Properties m_props = null;

    public CppProjectStrategy() {
    }

    public CppProjectStrategy(File file) {
        this.init(file, null);
    }

    public CppProjectStrategy(File projectFile, Properties props) {
        this(projectFile);
        this.m_props = props;
    }

    public void init(File file, IStrategyFactoryRegistry registry) {
        this.m_projectFile = file;
    }

    public String getName() {
        return this.m_projectFile.getName();
    }

    public String getType() {
        return "cpp";
    }

    public String getLanguageType() {
        return "cpp";
    }

    public String getPath() {
        return this.m_projectFile.getPath();
    }

    public String getStrategyClass() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void findScanTargets(IScanTargetProxy proxy, IProgress progress) {
        if (this.m_props != null) {
            for (String key : this.m_props.stringPropertyNames()) {
                proxy.getBuildInfo().setProperty(key, this.m_props.getProperty(key));
            }
        }
    }

    protected Set<IScanFile> findScanFiles(IScanTargetMinProxy proxy, IProgress progress) {
        LinkedHashSet<IScanFile> scanFiles = new LinkedHashSet<IScanFile>();
        String sources = proxy.getBuildInfo().getProperty("sources");
        if (sources != null) {
            for (String file : sources.split(";")) {
                IScanFile scanFile = ScanModelFactory.newScanFile((File)new File(file));
                scanFile.setExcluded(!this.shouldAddFile(file, proxy.getIncludes(), proxy.getExcludes()));
                scanFiles.add(scanFile);
            }
        }
        return scanFiles;
    }
}

