/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.vs;

import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.DiscoveryCore;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.vs.Messages;
import com.ibm.appscan.discovery.vs.utils.VSUtil;
import com.ibm.appscan.discovery.vs.utils.VsDiscoveryRunner;
import com.ibm.appscan.internal.discovery.StrategyFactoryRegistry;
import com.ibm.appscan.internal.discovery.dir.DirectoryStrategy;
import com.ibm.appscan.internal.discovery.vs.VSSolutionStrategy;
import com.ibm.appscan.internal.discovery.vs.VSStrategy;
import com.ibm.appscan.internal.discovery.vs.solution.SolutionSourceCodeStrategy;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SLNStrategy
extends VSStrategy {
    private File m_directory;
    private File m_solutionFile = null;
    private StrategyFactoryRegistry m_registry;

    public SLNStrategy() {
    }

    SLNStrategy(File directory, File solutionFile, IStrategyFactoryRegistry registry) {
        this.init(directory, registry);
        this.m_solutionFile = solutionFile;
        this.m_registry = (StrategyFactoryRegistry)registry;
    }

    public void init(File fileOrDirectory, IStrategyFactoryRegistry registry) {
        this.m_directory = fileOrDirectory;
        this.m_registry = (StrategyFactoryRegistry)registry;
    }

    public String getName() {
        return this.m_directory.getName();
    }

    public String getType() {
        return "Visual Studio Solutions";
    }

    public String getPath() {
        return this.m_directory.getAbsolutePath();
    }

    public String getStrategyClass() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected Set<IScanFile> findScanFiles(IScanTargetMinProxy proxy, IProgress progress) {
        return null;
    }

    public void findScanTargets(IScanTargetProxy proxy, IProgress progress) {
        for (File sln : this.getSolutionFiles()) {
            try {
                this.findScanTargetsInternal(proxy, progress, sln);
            }
            catch (IOException e) {
                this.handleFailedSolutionRead(sln, proxy);
            }
        }
        if (VSUtil.useNewDotNetFrontend()) {
            proxy.newScanTarget((ScanTargetStrategy)new SolutionSourceCodeStrategy(this.m_directory, (IStrategyFactoryRegistry)this.m_registry));
        }
    }

    protected Map<String, Properties> runDiscoveryManager(File solutionFile, boolean shouldBuild, IScanTargetProxy proxy) throws AppScanException {
        String config;
        ArrayList<String> args = new ArrayList<String>();
        args.add(solutionFile.getAbsolutePath());
        if (!shouldBuild) {
            args.add("-no_build");
        }
        if ((config = proxy.getBuildInfo().getProperty("configuration")) != null) {
            args.add("-c");
            args.add(config);
        }
        args.add("-l");
        args.add(SLNStrategy.getLogDir(proxy));
        try {
            return new VsDiscoveryRunner(args.toArray(new String[0])).run(proxy);
        }
        catch (AppScanException e) {
            throw new AppScanException(Messages.getMessage("solution.read.error", solutionFile.getAbsolutePath(), e.getLocalizedMessage()));
        }
    }

    protected StrategyFactoryRegistry getRegistry() {
        return this.m_registry;
    }

    private void findScanTargetsInternal(IScanTargetProxy proxy, IProgress progress, File solutionFile) throws IOException {
        if (!VSUtil.useNewDotNetFrontend()) {
            proxy.newScanTarget((ScanTargetStrategy)new VSSolutionStrategy(solutionFile, (IStrategyFactoryRegistry)this.m_registry));
            return;
        }
        String fileContents = IOUtil.readFileIntoString((File)solutionFile);
        if (SystemUtil.isWindows() && (fileContents.contains(".vcxproj") || fileContents.contains(".vcproj"))) {
            proxy.newScanTarget((ScanTargetStrategy)new VSSolutionStrategy(solutionFile, (IStrategyFactoryRegistry)this.m_registry));
        }
    }

    private File[] getSolutionFiles() {
        if (this.m_solutionFile != null) {
            return new File[]{this.m_solutionFile};
        }
        return this.m_directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String fileName) {
                return fileName.endsWith(".sln");
            }
        });
    }

    protected void handleFailedSolutionRead(File sln, IScanTargetProxy proxy) {
        if (SystemUtil.isSourceCodeOnly()) {
            proxy.getLogManager().log(new Message(2, Messages.getMessage("solution.read.warning", sln.getAbsolutePath())));
            proxy.newScanTarget((ScanTargetStrategy)new DirectoryStrategy(sln.getParentFile(), DiscoveryCore.getThirdPartyLibTarget(), this.m_registry));
        }
    }
}

