/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.vs;

import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.model.CustomTargetInfo;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.Strategy;
import com.ibm.appscan.discovery.vs.Messages;
import com.ibm.appscan.discovery.vs.utils.VSAdapterFactory;
import com.ibm.appscan.discovery.vs.utils.VSUtil;
import com.ibm.appscan.internal.discovery.vs.NullStrategy;
import com.ibm.appscan.internal.discovery.vs.SLNStrategy;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class VSSolutionStrategy
extends SLNStrategy {
    private File m_solution;
    private String m_languageType;
    protected static final String DEFAULT_LANUGAGE_TYPE = "DotNet";

    public VSSolutionStrategy() {
    }

    public VSSolutionStrategy(File file, IStrategyFactoryRegistry registry) {
        super(file.getParentFile(), file, registry);
        this.init(file, registry);
    }

    @Override
    public void init(File file, IStrategyFactoryRegistry registry) {
        this.m_solution = file;
        this.m_languageType = DEFAULT_LANUGAGE_TYPE;
    }

    @Override
    public String getName() {
        return this.m_solution.getName();
    }

    public String getLanguageType() {
        return this.m_languageType;
    }

    @Override
    public String getType() {
        return Messages.getMessage("solution", new Object[0]);
    }

    @Override
    public String getPath() {
        return this.m_solution.getPath();
    }

    @Override
    public String getStrategyClass() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @Override
    public void findScanTargets(IScanTargetProxy proxy, IProgress progress) {
        boolean addedTargets = false;
        Map<String, Properties> targets = null;
        try {
            targets = this.runDiscoveryManager(this.m_solution, true, proxy);
        }
        catch (AppScanException e) {
            proxy.getErrorManager().reportError(Messages.getMessage("solution.read.error", this.m_solution.getAbsolutePath(), e.getLocalizedMessage()));
        }
        if (targets != null && targets.size() > 0) {
            boolean isFirstPass = true;
            for (String target : targets.keySet()) {
                Properties properties = targets.get(target);
                if (this.shouldSkipProject(properties)) continue;
                try {
                    Map<Strategy, Properties> strategies = VSAdapterFactory.createTarget(properties, progress).toStrategies();
                    for (Strategy strategy : strategies.keySet()) {
                        if (strategy instanceof NullStrategy) {
                            proxy.getErrorManager().reportError(((NullStrategy)strategy).getMessage());
                            continue;
                        }
                        Map buildInfos = strategies.get(strategy);
                        CustomTargetInfo info = new CustomTargetInfo();
                        info.getBuildInfos().putAll(buildInfos);
                        if (!proxy.newScanTarget((ScanTargetStrategy)strategy, info)) continue;
                        addedTargets = true;
                        if (isFirstPass) {
                            this.m_languageType = strategy.getLanguageType();
                            isFirstPass = false;
                            continue;
                        }
                        if (this.m_languageType == strategy.getLanguageType()) continue;
                        this.m_languageType = DEFAULT_LANUGAGE_TYPE;
                    }
                }
                catch (AppScanException e) {
                    proxy.getErrorManager().reportError(e.getMessage());
                }
            }
        }
        if (!addedTargets) {
            this.handleFailedSolutionRead(this.m_solution, proxy);
        }
    }

    @Override
    protected Set<IScanFile> findScanFiles(IScanTargetMinProxy proxy, IProgress progress) {
        return null;
    }

    private boolean shouldSkipProject(Properties properties) {
        File projectFile = new File(properties.getProperty("project_file"));
        return VSUtil.useNewDotNetFrontend() && VSUtil.isDotNetProject(projectFile);
    }
}

