/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.vs.solution;

import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.ScanModelFactory;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.model.xml.IpvaXmlReader;
import com.ibm.appscan.common.utils.DirectoryUtil;
import com.ibm.appscan.common.utils.PathUtil;
import com.ibm.appscan.discovery.DiscoveryCore;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.vs.Messages;
import com.ibm.appscan.discovery.vs.utils.IpvaGenerator;
import com.ibm.appscan.internal.discovery.dir.DirectoryStrategy;
import com.ibm.appscan.internal.discovery.vs.VSSolutionStrategy;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;

public class SolutionSourceCodeStrategy
extends VSSolutionStrategy {
    private File m_solutionDirectory;

    public SolutionSourceCodeStrategy(File directory, IStrategyFactoryRegistry registry) {
        super(directory, registry);
        this.m_solutionDirectory = directory;
    }

    @Override
    public void findScanTargets(IScanTargetProxy proxy, IProgress progress) {
        DirectoryStrategy strategy = new DirectoryStrategy(this.m_solutionDirectory, DiscoveryCore.getThirdPartyLibTarget(), this.getRegistry()){

            protected boolean handle(File file, String path, IScanTargetMinProxy proxy) {
                return file.getName().toLowerCase().endsWith(".dll") || file.getName().toLowerCase().endsWith(".exe");
            }
        };
        strategy.setOutputsOnly(true);
        proxy.newScanTarget((ScanTargetStrategy)strategy);
    }

    @Override
    protected Set<IScanFile> findScanFiles(IScanTargetMinProxy proxy, IProgress progress) {
        File outputDirectory = new File(proxy.getScanHome().getAbsoluteFile(), "dotnet");
        outputDirectory.mkdirs();
        try {
            new IpvaGenerator(this.m_solutionDirectory, outputDirectory).run(progress);
            return this.getScanFilesFromIpva(outputDirectory);
        }
        catch (IOException | XMLStreamException e) {
            progress.setStatus(new Message(Messages.getMessage("error.frontend", e.getMessage()), (Throwable)e));
            return null;
        }
    }

    @Override
    public String getLanguageType() {
        return ".NET";
    }

    @Override
    public String getType() {
        return "SourceCodeSolution";
    }

    private Set<IScanFile> getScanFilesFromIpva(File outputDirectory) throws IOException, XMLStreamException {
        HashSet<IScanFile> scanFiles = new HashSet<IScanFile>();
        for (File ipvaFile : DirectoryUtil.getFiles((File)outputDirectory, (String)".ipva.xml")) {
            IpvaXmlReader reader = new IpvaXmlReader(ipvaFile);
            reader.read();
            scanFiles.addAll(this.processFiles(reader.getFiles()));
        }
        return scanFiles;
    }

    private Set<IScanFile> processFiles(List<String> files) {
        HashSet<IScanFile> scanFiles = new HashSet<IScanFile>();
        for (String file : files) {
            IScanFile scanFile = ScanModelFactory.newScanFile((String)file);
            String relativePath = PathUtil.makeRelative((File)this.m_solutionDirectory, (File)this.m_solutionDirectory, (String)file);
            scanFile.setSourcePath(relativePath);
            scanFiles.add(scanFile);
        }
        return scanFiles;
    }
}

