/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.condition;

import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IUnaryOpInstruction;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAComparisonInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAUnaryOpInstruction;
import com.ibm.wala.ssa.Value;
import com.ibm.wala.stringAnalysis.condition.CaseCondition;
import com.ibm.wala.stringAnalysis.condition.IPathCondition;
import com.ibm.wala.stringAnalysis.condition.ISymbolicCondition;
import com.ibm.wala.stringAnalysis.condition.NotCaseCondition;
import com.ibm.wala.stringAnalysis.condition.PathCondition;
import com.ibm.wala.stringAnalysis.condition.RangeCondition;
import com.ibm.wala.stringAnalysis.condition.VarCondition;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;

public abstract class SymbolicSSACondition<T extends SSAInstruction>
implements ISymbolicCondition {
    private CGNode node;
    private T instruction;

    public SymbolicSSACondition(CGNode node, T instruction) {
        this.node = node;
        this.instruction = instruction;
    }

    public CGNode getCorrespondingCGNode() {
        return this.node;
    }

    public T getCorrespondingInstruction() {
        return this.instruction;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.instruction == null ? 0 : this.instruction.hashCode());
        result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SymbolicSSACondition other = (SymbolicSSACondition)obj;
        if (this.instruction == null ? other.instruction != null : !this.instruction.equals(other.instruction)) {
            return false;
        }
        return !(this.node == null ? other.node != null : !this.node.equals(other.node));
    }

    protected static IPathCondition calculatePathCondition(CGNode node, SSAConditionalBranchInstruction bi, boolean taken) {
        boolean base;
        IR ir = node.getIR();
        int condVar0 = bi.getUse(0);
        int condVar1 = bi.getUse(1);
        Value val0 = ir.getSymbolTable().getValue(bi.getUse(0));
        Value val1 = ir.getSymbolTable().getValue(bi.getUse(1));
        IConditionalBranchInstruction.IOperator op = bi.getOperator();
        PathCondition pathCond = new PathCondition();
        if (val0 instanceof ConstantValue) {
            Value t = val0;
            val0 = val1;
            val1 = t;
            int v = condVar0;
            condVar0 = condVar1;
            condVar1 = v;
            if (op.equals(IConditionalBranchInstruction.Operator.GE)) {
                op = IConditionalBranchInstruction.Operator.LE;
            } else if (op.equals(IConditionalBranchInstruction.Operator.GT)) {
                op = IConditionalBranchInstruction.Operator.LT;
            } else if (op.equals(IConditionalBranchInstruction.Operator.LE)) {
                op = IConditionalBranchInstruction.Operator.GE;
            } else if (op.equals(IConditionalBranchInstruction.Operator.LT)) {
                op = IConditionalBranchInstruction.Operator.GT;
            }
        }
        if (!(val1 instanceof ConstantValue)) {
            return pathCond;
        }
        ConstantValue cval = (ConstantValue)val1;
        Object obj = cval.getValue();
        if (obj instanceof Integer) {
            Integer ival = (Integer)obj;
            int i = ival;
            if (i != 0 && op.equals(IConditionalBranchInstruction.Operator.EQ)) {
                if (taken) {
                    pathCond.and(new CaseCondition(condVar0, i));
                } else {
                    pathCond.and(new NotCaseCondition(condVar0, i));
                }
                return pathCond;
            }
            if (i != 0 && op.equals(IConditionalBranchInstruction.Operator.NE)) {
                if (taken) {
                    pathCond.and(new NotCaseCondition(condVar0, i));
                } else {
                    pathCond.and(new CaseCondition(condVar0, i));
                }
                return pathCond;
            }
            if (op.equals(IConditionalBranchInstruction.Operator.GE)) {
                if (taken) {
                    pathCond.and(new RangeCondition(condVar0, i, RangeCondition.Operator.GE));
                } else {
                    pathCond.and(new RangeCondition(condVar0, i, RangeCondition.Operator.LT));
                }
                return pathCond;
            }
            if (op.equals(IConditionalBranchInstruction.Operator.GT)) {
                if (taken) {
                    pathCond.and(new RangeCondition(condVar0, i, RangeCondition.Operator.GT));
                } else {
                    pathCond.and(new RangeCondition(condVar0, i, RangeCondition.Operator.LE));
                }
                return pathCond;
            }
            if (op.equals(IConditionalBranchInstruction.Operator.LE)) {
                if (taken) {
                    pathCond.and(new RangeCondition(condVar0, i, RangeCondition.Operator.LE));
                } else {
                    pathCond.and(new RangeCondition(condVar0, i, RangeCondition.Operator.GT));
                }
                return pathCond;
            }
            if (op.equals(IConditionalBranchInstruction.Operator.LT)) {
                if (taken) {
                    pathCond.and(new RangeCondition(condVar0, i, RangeCondition.Operator.LT));
                } else {
                    pathCond.and(new RangeCondition(condVar0, i, RangeCondition.Operator.GE));
                }
                return pathCond;
            }
            if (i == 0) {
                base = false;
            } else {
                Assertions.UNREACHABLE();
                base = true;
            }
        } else if (obj instanceof Boolean) {
            Boolean bval = (Boolean)obj;
            base = bval;
        } else {
            return pathCond;
        }
        DefUse du = node.getDU();
        if (op.equals(IConditionalBranchInstruction.Operator.EQ)) {
            if (taken) {
                return SymbolicSSACondition.calculatePathCondition(condVar0, base, pathCond, ir, du);
            }
            return SymbolicSSACondition.calculatePathCondition(condVar0, !base, pathCond, ir, du);
        }
        if (op.equals(IConditionalBranchInstruction.Operator.NE)) {
            if (taken) {
                return SymbolicSSACondition.calculatePathCondition(condVar0, !base, pathCond, ir, du);
            }
            return SymbolicSSACondition.calculatePathCondition(condVar0, base, pathCond, ir, du);
        }
        return pathCond;
    }

    private static PathCondition calculatePathCondition(int v, boolean b, PathCondition pathCond, IR ir, DefUse du) {
        SSAInstruction instruction = du.getDef(v);
        if (instruction instanceof SSAAbstractInvokeInstruction) {
            SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)instruction;
            if (invoke.getDeclaredResultType().equals((Object)TypeReference.Boolean)) {
                pathCond.and(new VarCondition(b ? v : -v));
                return pathCond;
            }
            return pathCond;
        }
        if (instruction instanceof SSAUnaryOpInstruction) {
            SSAUnaryOpInstruction uop = (SSAUnaryOpInstruction)instruction;
            if (uop.getOpcode().equals(IUnaryOpInstruction.Operator.NEG)) {
                return SymbolicSSACondition.calculatePathCondition(uop.getUse(0), !b, pathCond, ir, du);
            }
            return pathCond;
        }
        if (instruction instanceof SSAComparisonInstruction) {
            return pathCond;
        }
        if (instruction instanceof SSAPhiInstruction) {
            return pathCond;
        }
        return pathCond;
    }

    public String toString() {
        return this.getClass().toString() + "(" + this.instruction.toString(this.node.getIR().getSymbolTable()) + ")";
    }
}

