/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.condition.dnf;

import com.ibm.wala.stringAnalysis.condition.dnf.Term;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

class Formula {
    private List<Term> termList;
    private List<Term> originalTermList;

    public Formula(List<Term> termList) {
        this.termList = termList;
    }

    public String toString() {
        String result = "";
        result = result + this.termList.size() + " terms, " + this.termList.get(0).getNumVars() + " variables\t";
        for (int i = 0; i < this.termList.size(); ++i) {
            result = result + this.termList.get(i) + "\t";
        }
        return result;
    }

    public void reduceToPrimeImplicants() {
        int ones;
        int dontKnows;
        this.originalTermList = new ArrayList<Term>(this.termList);
        int numVars = this.termList.get(0).getNumVars();
        ArrayList[][] table = new ArrayList[numVars + 1][numVars + 1];
        for (dontKnows = 0; dontKnows <= numVars; ++dontKnows) {
            for (ones = 0; ones <= numVars; ++ones) {
                table[dontKnows][ones] = new ArrayList();
            }
        }
        for (int i = 0; i < this.termList.size(); ++i) {
            int dontCares = this.termList.get(i).countValues((byte)2);
            int ones2 = this.termList.get(i).countValues((byte)1);
            table[dontCares][ones2].add(this.termList.get(i));
        }
        for (dontKnows = 0; dontKnows <= numVars - 1; ++dontKnows) {
            for (ones = 0; ones <= numVars - 1; ++ones) {
                ArrayList left = table[dontKnows][ones];
                ArrayList right = table[dontKnows][ones + 1];
                ArrayList out = table[dontKnows + 1][ones];
                for (int leftIdx = 0; leftIdx < left.size(); ++leftIdx) {
                    for (int rightIdx = 0; rightIdx < right.size(); ++rightIdx) {
                        Term combined = ((Term)left.get(leftIdx)).combine((Term)right.get(rightIdx));
                        if (combined == null) continue;
                        if (!out.contains(combined)) {
                            out.add(combined);
                        }
                        this.termList.remove(left.get(leftIdx));
                        this.termList.remove(right.get(rightIdx));
                        if (this.termList.contains(combined)) continue;
                        this.termList.add(combined);
                    }
                }
            }
        }
    }

    public void reducePrimeImplicantsToSubset() {
        int numPrimeImplicants = this.termList.size();
        int numOriginalTerms = this.originalTermList.size();
        boolean[][] table = new boolean[numPrimeImplicants][numOriginalTerms];
        for (int impl = 0; impl < numPrimeImplicants; ++impl) {
            for (int term = 0; term < numOriginalTerms; ++term) {
                table[impl][term] = this.termList.get(impl).implies(this.originalTermList.get(term));
            }
        }
        ArrayList<Term> newTermList = new ArrayList<Term>();
        boolean done = false;
        while (!done) {
            int impl = this.extractEssentialImplicant(table);
            if (impl != -1) {
                newTermList.add(this.termList.get(impl));
                continue;
            }
            impl = this.extractLargestImplicant(table);
            if (impl != -1) {
                newTermList.add(this.termList.get(impl));
                continue;
            }
            done = true;
        }
        this.termList = newTermList;
        this.originalTermList = null;
    }

    public static Formula read(Reader reader) throws IOException {
        Term term;
        ArrayList<Term> terms = new ArrayList<Term>();
        while ((term = Term.read(reader)) != null) {
            terms.add(term);
        }
        return new Formula(terms);
    }

    private int extractEssentialImplicant(boolean[][] table) {
        for (int term = 0; term < table[0].length; ++term) {
            int lastImplFound = -1;
            for (int impl = 0; impl < table.length; ++impl) {
                if (!table[impl][term]) continue;
                if (lastImplFound == -1) {
                    lastImplFound = impl;
                    continue;
                }
                lastImplFound = -1;
                break;
            }
            if (lastImplFound == -1) continue;
            this.extractImplicant(table, lastImplFound);
            return lastImplFound;
        }
        return -1;
    }

    private void extractImplicant(boolean[][] table, int impl) {
        for (int term = 0; term < table[0].length; ++term) {
            if (!table[impl][term]) continue;
            for (int impl2 = 0; impl2 < table.length; ++impl2) {
                table[impl2][term] = false;
            }
        }
    }

    private int extractLargestImplicant(boolean[][] table) {
        int maxNumTerms = 0;
        int maxNumTermsImpl = -1;
        for (int impl = 0; impl < table.length; ++impl) {
            int numTerms = 0;
            for (int term = 0; term < table[0].length; ++term) {
                if (!table[impl][term]) continue;
                ++numTerms;
            }
            if (numTerms <= maxNumTerms) continue;
            maxNumTerms = numTerms;
            maxNumTermsImpl = impl;
        }
        if (maxNumTermsImpl != -1) {
            this.extractImplicant(table, maxNumTermsImpl);
            return maxNumTermsImpl;
        }
        return -1;
    }

    public List<Term> getTerms() {
        return this.termList;
    }
}

