/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.grammar;

import com.ibm.wala.automaton.grammar.string.IRuleVisitor;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.stringAnalysis.grammar.GR;
import com.ibm.wala.stringAnalysis.grammar.GRule;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GInvocationRule
extends GRule {
    private Set<GR> grammars;
    private Set<GRule> aliasRules;
    private Map<ISymbol, ISymbol> aliasMap;

    public GInvocationRule(Set<GR> grammars, IR ir, SSAInstruction ssai, IVariable left, ISymbol[] right) {
        super(ir, ssai, left, right);
        this.grammars = new HashSet<GR>(grammars);
        this.aliasRules = new HashSet<GRule>();
        this.aliasMap = new HashMap<ISymbol, ISymbol>();
    }

    public GInvocationRule(Set<GR> grammars, IR ir, SSAInstruction ssai, IVariable left, List<ISymbol> right) {
        super(ir, ssai, left, right);
        this.grammars = new HashSet<GR>(grammars);
        this.aliasRules = new HashSet<GRule>();
        this.aliasMap = new HashMap<ISymbol, ISymbol>();
    }

    public GInvocationRule(Set<GR> grammars, GRule instruction) {
        super(instruction);
        this.grammars = new HashSet<GR>(grammars);
        this.aliasRules = new HashSet<GRule>();
        this.aliasMap = new HashMap<ISymbol, ISymbol>();
    }

    public GInvocationRule(GInvocationRule instruction) {
        super(instruction);
        this.grammars = new HashSet<GR>(instruction.getGrammars());
        this.aliasRules = new HashSet<GRule>();
        this.aliasMap = new HashMap<ISymbol, ISymbol>();
    }

    public Set<GR> getGrammars() {
        return this.grammars;
    }

    public Set<GRule> getAliasRules() {
        return this.aliasRules;
    }

    public Map<ISymbol, ISymbol> getAliasMap() {
        return this.aliasMap;
    }

    public void addAliasRule(IR ir, SSAInstruction instruction, int paramIndex, IVariable param, ISymbol value) {
        this.aliasMap.put((ISymbol)param, value);
        GRule grule1 = new GRule(ir, null, param, value);
        this.aliasRules.add(grule1);
        if (paramIndex >= 0 && value instanceof IVariable) {
            GRule grule2 = new GRule(ir, instruction, (IVariable)value, new ISymbol[]{param});
            this.aliasRules.add(grule2);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        GInvocationRule grule = (GInvocationRule)((Object)obj);
        return this.aliasRules.equals(grule.aliasRules) && this.grammars.equals(grule.grammars);
    }

    public void traverse(IRuleVisitor visitor) {
        for (GRule r : this.aliasRules) {
            r.traverse(visitor);
        }
        for (GR g : this.grammars) {
            g.traverseRules(visitor);
        }
    }

    public String toString(Set<GR> history) {
        StringBuffer callees = new StringBuffer();
        Iterator<GR> i = this.grammars.iterator();
        while (i.hasNext()) {
            GR g = i.next();
            String s = g.toString();
            callees.append(s);
            if (!i.hasNext()) continue;
            callees.append(", ");
        }
        return "{rule:" + super.toString() + ", callees:" + callees + "}";
    }

    @Override
    public String toString() {
        return this.toString(new HashSet<GR>());
    }
}

