/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.irx.stage.java;

import com.hcl.appscan.discovery.java.classpathManager.ClasspathManager;
import com.hcl.appscan.discovery.java.utils.JDKHelper;
import com.hcl.appscan.discovery.java.utils.Util;
import com.hcl.clazz.info.ClassInfo;
import com.hcl.irx.stage.JavaStageListener;
import com.hcl.irx.stage.Messages;
import com.hcl.irx.stage.StageEventManager;
import com.hcl.irx.stage.Stager;
import com.hcl.irx.stage.java.FileJarAnalyzer;
import com.hcl.irx.stage.java.Jar;
import com.hcl.irx.stage.java.JarAnalyzer;
import com.hcl.irx.stage.java.JavaTargetValidator;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.common.build.BuilderDefinition;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.StringPattern;
import com.ibm.appscan.common.model.validation.CompileError;
import com.ibm.appscan.common.model.validation.IValidationIssue;
import com.ibm.appscan.common.utils.ClasspathBuilder;
import com.ibm.appscan.common.utils.ClasspathUtil;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.DiscoveryCore;
import com.ibm.appscan.discovery.dir.ICollector;
import com.ibm.appscan.discovery.dir.ICustomCollector;
import com.ibm.appscan.discovery.jsp.compilers.BaseJSPCompiler;
import com.ibm.appscan.discovery.util.PackageNameUtil;
import com.ibm.appscan.exclude.exclusions.ExclusionException;
import com.ibm.appscan.internal.discovery.dir.CollectorFactoryRegistry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class JavaStager
extends Stager
implements JavaStageListener {
    private static String WEB_INF = "WEB-INF";
    private static String WEB_XML = "web.xml";
    private static String LIB = "lib";
    private boolean m_has_web_content = false;
    private HashSet<String> m_analysis_packages = new HashSet();
    private HashSet<String> m_analysis_classes = new HashSet();
    private HashMap<String, Integer> m_name_to_int = new HashMap();
    private HashSet<String> m_dependency_packages_encountered = new HashSet();
    private JSONObject m_memory_stats = new JSONObject();
    private ArrayList<String> m_compressed_files_staged = new ArrayList();
    private List<ICollector> m_collectors = new ArrayList<ICollector>();
    private Jar m_user_jar;
    private Jar m_dependency_jar;

    public JavaStager(File base_dir, IScanTargetMinProxy proxy, IProgress progress, Set<StringPattern> includes, Set<StringPattern> excludes) {
        super(base_dir, proxy, progress, includes, excludes);
        StageEventManager.removeAllListeners();
        StageEventManager.addJavaStageListener(this);
        StageEventManager.addStageListener(this);
        for (ICollector c : CollectorFactoryRegistry.getCollectors(null, (File)this.getStageDirectory(), (IScanTargetProxy)((IScanTargetProxy)this.getProxy()))) {
            if (c.getClass().getSimpleName().equals("JavaStagerCollector") || c.getClass().getSimpleName().equals("ThirdPartyLibCollector")) continue;
            this.m_collectors.add(c);
        }
    }

    protected synchronized Jar getUserJar() throws FileNotFoundException, IOException {
        if (this.m_user_jar == null) {
            this.m_user_jar = new Jar(new File(this.getStagedDependencyRoot().getAbsolutePath(), "user.code.staged.jar"), this.getProgress());
        }
        return this.m_user_jar;
    }

    protected synchronized Jar getDependencyJar() throws FileNotFoundException, IOException {
        if (this.m_dependency_jar == null) {
            this.m_dependency_jar = new Jar(new File(this.getStagedDependencyRoot().getAbsolutePath(), "dependency_class_files.jar"), this.getProgress());
        }
        return this.m_dependency_jar;
    }

    @Override
    protected void setupStaging() throws IOException, ExclusionException {
    }

    @Override
    public void finalizeStaging() throws IOException, ExclusionException {
        try {
            if (this.getDependencyJar().closeJar()) {
                this.getDependencies().add(this.getDependencyJar().getFile());
            }
            if (this.getUserJar().closeJar()) {
                this.getDependencies().add(this.getUserJar().getFile());
            }
            this.printOutStageInformation();
            this.printOutNumberToPathReference();
            this.setUpClassPath();
            if (this.getStageDirectory() != null && this.containsWebContent()) {
                this.processWebContentRoot();
            }
            for (ICollector c : this.m_collectors) {
                if (!(c instanceof ICustomCollector)) continue;
                ((ICustomCollector)c).createScanTarget((IScanTargetProxy)this.getProxy(), null);
            }
        }
        finally {
            StageEventManager.removeJavaStageListener(this);
            StageEventManager.removeStageListener(this);
        }
    }

    protected File getClassDirectory() {
        return this.getStageDirectory();
    }

    @Override
    protected Language.LANGUAGE getLanguage() {
        return Language.LANGUAGE.JAVA;
    }

    @Override
    protected void stageFileForLanguage(File f) throws IOException, ExclusionException {
        if (JavaStager.isJavaCompressedFile(f.getName())) {
            this.processCompressedFile(f);
        } else {
            this.handleFile(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFile(File f) throws ExclusionException, IOException {
        File target = new File(f.getAbsolutePath().substring(this.getProxy().getPath().length() + 1));
        if (f.getPath().contains(WEB_INF)) {
            this.m_has_web_content = true;
        }
        FileInputStream in = null;
        try {
            if (!this.isUserExcluded(f.getPath())) {
                in = new FileInputStream(f);
                if (JavaStager.isJavaClass(f.getName())) {
                    if (JavaStager.isSupportedClassVersion(f.toString())) {
                        StageEventManager.fireStageLooseClassInfoEvent(new ClassInfo(f));
                    } else {
                        Message message = new Message(2, Messages.getMessage("err.skipping.file", f.getName()));
                        CommonCore.getLogManager().log(message);
                    }
                } else if (JavaStager.isJavaCompressedFile(f.getPath())) {
                    this.processCompressedFile(f);
                } else if (JavaStager.isSmapFile(f.getPath())) {
                    if (target.getPath().contains(WEB_INF)) {
                        target = new File(target.getPath().substring(target.getPath().indexOf(WEB_INF) + 16));
                    }
                    StageEventManager.fireStageSmapFileEvent(target, in);
                } else if (JavaStager.isJsp(f.getName()) || JavaStager.isTld(f.getName())) {
                    this.m_has_web_content = true;
                    StageEventManager.fireStageFileEvent(target, in);
                } else {
                    StageEventManager.fireStageFileEvent(target, in);
                }
            }
        }
        finally {
            IOUtil.close(in);
        }
    }

    private void processCompressedFile(File f) throws IOException, ExclusionException {
        this.processCompressedFile(null, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCompressedFile(String parent_name, File f) throws IOException, ExclusionException {
        block14: {
            if (parent_name == null) {
                this.resetCurrentParent(f.getName());
            } else {
                this.appendParent(f.getName());
            }
            if (JavaStager.isJavaWebArchive(f.getPath())) {
                this.m_has_web_content = true;
            }
            JarAnalyzer j = null;
            try {
                j = parent_name != null ? new FileJarAnalyzer(parent_name, this.m_memory_stats, f) : new FileJarAnalyzer(f, this.m_memory_stats);
                this.getProgress().setStatus(new Message(1, Messages.getMessage("staging.file", j.getNameOfArchive())));
                this.m_compressed_files_staged.add(f.getAbsolutePath());
                j.processJarFile(this.isUserExcluded(f.getPath()));
                if (!j.hasUserCode()) {
                    StageEventManager.fireAddDependencyFileReferenceEvent(f);
                }
                if (!j.hasTldInManifest()) break block14;
                this.m_has_web_content = true;
                FileInputStream in = new FileInputStream(f);
                try {
                    StageEventManager.fireStageFileEvent(Paths.get(WEB_INF, LIB, f.getName()).toFile(), in);
                }
                finally {
                    IOUtil.close((Closeable)in);
                }
            }
            catch (Exception e) {
                if (this.getProxy() != null) {
                    this.getProxy().getLogManager().log(e);
                }
            }
            finally {
                if (j != null) {
                    j.close();
                }
                this.removeParent(f.getName());
            }
        }
    }

    public boolean containsWebContent() {
        return this.m_has_web_content;
    }

    public static boolean isJsp(String entry) {
        return entry.endsWith(".jsp") || entry.endsWith(".jspi") || entry.endsWith(".jspx");
    }

    public static boolean isTld(String entry) {
        return entry.endsWith(".tld");
    }

    public static boolean isJavaArtifact(String entry) {
        return JavaStager.isJavaClass(entry) || JavaStager.isJavaJar(entry) || JavaStager.isJavaRar(entry) || JavaStager.isJavaWebArchive(entry) || JavaStager.isJsp(entry) || JavaStager.isSmapFile(entry) || JavaStager.isTld(entry);
    }

    public static boolean isJavaClass(String entry) {
        return entry.endsWith(".class") && !entry.endsWith("module-info.class");
    }

    public static boolean isSmapFile(String entry) {
        return entry.endsWith("smap");
    }

    public static boolean isJavaSourceFile(String entry) {
        return entry.endsWith(".java");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isUserExcluded(String path) {
        if (JavaStager.isJavaCompressedFile(path)) {
            FileInputStream in;
            block6: {
                boolean bl;
                in = null;
                try {
                    in = new FileInputStream(new File(path));
                    if (!this.jarHasIncludes(path, in)) break block6;
                    bl = false;
                }
                catch (Exception e) {
                    try {
                        if (this.getProxy() != null) {
                            this.getProxy().getLogManager().log(e);
                        }
                        CommonCore.getLogManager().log(e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(in);
                        throw throwable;
                    }
                    IOUtil.close((Closeable)in);
                }
                IOUtil.close((Closeable)in);
                return bl;
            }
            IOUtil.close((Closeable)in);
        }
        return super.isUserExcluded(path);
    }

    private boolean jarHasIncludes(String path, InputStream in) throws IOException {
        ZipEntry entry;
        ZipInputStream stream = null;
        stream = new ZipInputStream(in);
        while ((entry = stream.getNextEntry()) != null) {
            if (JavaStager.isJavaCompressedFile(entry.getName()) && this.jarHasIncludes(new File(path, entry.getName()).getAbsolutePath(), stream)) {
                return true;
            }
            if (!this.isUserIncluded(new File(path, entry.getName()).getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    public static boolean isJspFile(String entry) {
        return entry.endsWith(".jsp") || entry.endsWith(".jspx");
    }

    public static boolean isJavaCompressedFile(String entry) {
        return JavaStager.isJavaRar(entry) || JavaStager.isJavaJar(entry) || JavaStager.isJavaWebArchive(entry);
    }

    public static boolean isJavaDependencyfile(String entry) {
        return JavaStager.isJavaJar(entry) || JavaStager.isJavaRar(entry);
    }

    public static boolean isJavaRar(String entry) {
        return entry.endsWith(".rar");
    }

    public static boolean isJavaJar(String entry) {
        return entry.endsWith(".jar");
    }

    public static boolean isJavaWebArchive(String entry) {
        return entry.endsWith(".ear") || entry.endsWith(".war");
    }

    private void setUpClassPath() throws IOException {
        if (this.getProxy() == null) {
            return;
        }
        JDKHelper.setJDKProperties((IScanTargetMinProxy)this.getProxy());
        if (this.getProxy() != null) {
            if (this.getProxy().getBuildInfo().getProperty("web_content_dir") != null) {
                this.getProxy().getBuildInfo().setProperty("web_content_dir", this.getProxy().getBuildInfo().getProperty("web_content_dir"));
            }
            if (this.getProxy().getBuildInfo().getProperty("jsp_compiler") != null) {
                this.getProxy().getBuildInfo().setProperty("jsp_compiler", this.getProxy().getBuildInfo().getProperty("jsp_compiler"));
            }
            if (this.getProxy().getBuildInfo().getProperty("jsp_compiler_args") != null) {
                this.getProxy().getBuildInfo().setProperty("jsp_compiler_args", this.getProxy().getBuildInfo().getProperty("jsp_compiler_args"));
            }
            if (this.getProxy().getBuildInfo().getProperty("src_root") != null) {
                this.getProxy().getBuildInfo().setProperty("src_root", this.getProxy().getBuildInfo().getProperty("src_root"));
            }
        }
        ClasspathBuilder builder = new ClasspathBuilder(this.getProxy());
        builder.appendToClasspath(CommonCore.getDirectoryLocator().getProductRoot() + "/annotation/com.static.analyzer.annotation.jar");
        builder.appendToClasspath(ClasspathManager.getParentClasspath((IScanTargetMinProxy)this.getProxy()));
        for (File f : this.getDependencies()) {
            builder.appendToClasspath(f.getAbsolutePath());
        }
        builder.appendToClasspath(ClasspathManager.getParentClasspath((IScanTargetMinProxy)this.getProxy()));
        builder.appendToClasspath(this.getStageDirectory().getAbsolutePath());
        builder.commit();
    }

    private void processWebContentRoot() throws FileNotFoundException, IOException {
        final File webxml = new File(this.getStageDirectory(), WEB_INF + File.separator + WEB_XML);
        if (!webxml.exists()) {
            Path path = Paths.get(this.getStageDirectory().toURI());
            try {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (!attrs.isDirectory() && file.endsWith(WEB_XML)) {
                            webxml.getParentFile().mkdirs();
                            IOUtil.copy((File)file.toFile(), (File)webxml);
                            return FileVisitResult.TERMINATE;
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                this.getProxy().getErrorManager().reportError(e.getMessage(), (Throwable)e);
            }
        }
        if (this.getProxy() != null) {
            if (this.getProxy().getBuildInfo().getProperty("web_content_dir") == null) {
                this.getProxy().getBuildInfo().setProperty("web_content_dir", this.getStageDirectory().getAbsolutePath());
            }
            this.compielJspFiles();
        }
    }

    private void printOutStageInformation() {
        if (SystemUtil.isPropertySet((String)"STAGE_INFO") && !this.getStageDirectory().getPath().endsWith("user.code.staged.jar") && this.m_analysis_packages.size() > 0) {
            this.getProgress().setStatus(new Message(1, ""));
            this.getProgress().setStatus(new Message(1, Messages.getMessage("staged.packages", this.getStageDirectory().getName())));
            ArrayList<String> packs = new ArrayList<String>(this.m_analysis_packages);
            Collections.sort(packs);
            for (String p : packs) {
                this.getProgress().setStatus(new Message(1, Messages.getMessage("package", p)));
            }
            this.getProgress().setStatus(new Message(1, ""));
        }
    }

    private void printOutNumberToPathReference() throws IOException {
        if (this.m_name_to_int.keySet().size() > 0) {
            ArrayList<Integer> conversions = new ArrayList<Integer>(this.m_name_to_int.values());
            Collections.sort(conversions);
            ArrayList<String> result = new ArrayList<String>();
            block0: for (int i : conversions) {
                for (String key : this.m_name_to_int.keySet()) {
                    if (this.m_name_to_int.get(key) != i) continue;
                    result.add(i + "=" + key);
                    continue block0;
                }
            }
            IOUtil.write(result, (File)new File(this.getStageDirectory().getAbsolutePath(), "number_to_path_conversions.txt"));
        }
    }

    private File getSmallName(File root, String name) {
        return this.getSmallName(root, null, name);
    }

    private File getSmallName(File root, String archive, String name) {
        File ret = new File(root, name);
        if (archive != null) {
            ret = new File(new File(root, archive), name);
        }
        if (ret.getParentFile() != null && ret.getAbsolutePath().toString().length() > 254) {
            if (archive == null) {
                File temp = new File(name);
                if (temp.getParentFile() != null) {
                    ret = new File(new File(root, this.getNamePart(temp.getPath())), temp.getName());
                }
            } else {
                ret = new File(new File(root, this.getNamePart(archive)), ret.getName());
            }
        }
        return ret;
    }

    private String getNamePart(String name) {
        File temp = new File(name);
        if (!this.m_name_to_int.containsKey(temp.getPath())) {
            this.m_name_to_int.put(temp.getPath(), this.m_name_to_int.keySet().size() + 1);
        }
        return Integer.toString(this.m_name_to_int.get(temp.getPath()));
    }

    @Override
    public void handleStageInternalJavaCompressedFile(String relative_path, ZipEntry entry, InputStream in) throws IOException, ExclusionException {
        File jar = this.getSmallName(this.getStagedDependencyRoot().getAbsoluteFile(), relative_path);
        StageEventManager.fireStageFileEvent(jar, in);
        this.processCompressedFile(relative_path, jar);
    }

    @Override
    public boolean handleStageClassFile(ClassInfo ci) throws IOException, ExclusionException {
        if (this.isUserExcluded(ci.getOriginalFileLocation().getPath()) || !SystemUtil.isThirdParty() && this.getExcluder().isClassExcluded(ci.getClassName())) {
            if (ci.getPackageName() != null) {
                this.m_dependency_packages_encountered.add(ci.getPackageName());
            }
            return false;
        }
        this.processUserCodeClass(ci);
        return true;
    }

    protected void processUserCodeClass(ClassInfo ci) throws IOException {
        File out = new File(this.getStageDirectory().getAbsolutePath(), ci.getClassName().replace(".", File.separator) + ".class");
        if (out.getParentFile() != null) {
            out.getParentFile().mkdirs();
        }
        StageEventManager.fireStageFileEvent(out, new ByteArrayInputStream(ci.getData()));
        if (ci.getPackageName() != null) {
            this.m_analysis_packages.add(ci.getPackageName());
        }
        this.m_analysis_classes.add(ci.getClassName());
        this.getUserJar().addClassToJar(ci);
        this.getUserCodeFiles().add(out);
        this.addFileToStagedMap(out, ci);
    }

    @Override
    public void handleStageLooseClassFile(ClassInfo ci) throws IOException, ExclusionException {
        if (this.isUserExcluded(ci.getOriginalFileLocation().getPath()) || this.getExcluder().isClassExcluded(ci.getClassName())) {
            this.getDependencyJar().addClassToJar(ci);
            if (ci.getPackageName() != null) {
                this.m_dependency_packages_encountered.add(ci.getPackageName());
            }
        } else {
            this.handleStageClassFile(ci);
        }
    }

    @Override
    public void handleStageJspFile(String archive, String path, InputStream in) throws IOException {
        this.m_has_web_content = true;
        StageEventManager.fireStageExtraFileEvent(archive, path, in);
    }

    @Override
    public void handleStageSmapFile(File relative_path, InputStream in) throws IOException {
        this.m_has_web_content = true;
        StageEventManager.fireStageFileEvent(this.getSmallName(this.getStageDirectory().getAbsoluteFile(), relative_path.getPath()), in);
    }

    @Override
    public void handleStageExtraFile(String archive, String entry_name, InputStream in) throws IOException {
        File out = this.getSmallName(this.getStageDirectory().getAbsoluteFile(), entry_name);
        if (out.exists() || out.getParentFile() != null && out.getParentFile().exists() && out.getParentFile().isFile()) {
            out = this.getSmallName(this.getStageDirectory().getAbsoluteFile(), archive, entry_name);
        }
        StageEventManager.fireStageFileEvent(out, in);
        for (ICollector c : this.m_collectors) {
            c.process(out, this.getStageDirectory().getAbsolutePath(), this.getProgress());
        }
    }

    public static byte[] getDataFromStream(InputStream stream) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[65536];
        int len = 0;
        while ((len = stream.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
        out.flush();
        byte[] ret = out.toByteArray();
        IOUtil.close((Closeable)out);
        return ret;
    }

    @Override
    protected Language.LANGUAGE getStagerLanguage() {
        return Language.LANGUAGE.JAVA;
    }

    @Override
    protected void addStagerSpecificStats() throws JSONException {
        ArrayList<String> packs = new ArrayList<String>(this.m_analysis_packages);
        Collections.sort(packs);
        this.getStagerStats().put("user_code_to_be_analyzed", packs);
        packs = new ArrayList<String>(this.m_dependency_packages_encountered);
        Collections.sort(packs);
        this.getStagerStats().put("dependency_packages", packs);
        Collections.sort(this.m_compressed_files_staged);
        ArrayList<String> staged_file_names = new ArrayList<String>();
        for (String file : this.m_compressed_files_staged) {
            staged_file_names.add(new File(file).getName());
        }
        this.getStagerStats().put("files_staged", staged_file_names);
        this.getStagerStats().put("memory_footprint", (Map)this.m_memory_stats);
    }

    public List<String> getCompressedFilesStaged() {
        return this.m_compressed_files_staged;
    }

    private void addFileToStagedMap(File file, ClassInfo info) {
        this.addFileToStagedMap(file, info, null);
    }

    private void addFileToStagedMap(File file, ClassInfo info, String jsp) {
        String class_name = null;
        if (jsp != null) {
            class_name = jsp;
        } else {
            String packageName = info.getPackageName();
            String className = Util.getJavaFile((String)file.getName());
            class_name = packageName.replace('.', File.separatorChar) + File.separator + className;
        }
        IScanTargetMinProxy proxy = this.getProxy();
        if (proxy != null) {
            class_name = proxy.getSourceAbsolutePath(class_name);
        }
        this.getStagedFilesMap().put(file.getAbsolutePath(), class_name);
    }

    protected void addAnalysisClassesToThirdPartyLib(File dir) {
        if (dir.isDirectory()) {
            for (File f : dir.listFiles()) {
                this.addAnalysisClassesToThirdPartyLib(f);
            }
        }
    }

    public HashSet<String> getAnalysisPackages() {
        return this.m_analysis_packages;
    }

    public HashSet<String> getAnalysisPackagesTrimmed() {
        return this.trimAnalysisPackages();
    }

    public HashSet<String> getAnalysisClasses() {
        return this.m_analysis_classes;
    }

    public HashSet<String> trimAnalysisPackages() {
        HashSet<String> analysis_packages_trimmed = new HashSet<String>();
        for (String packageName : this.m_analysis_packages) {
            if ((packageName = PackageNameUtil.trimPackageName((String)packageName)).contains("org.apache")) continue;
            analysis_packages_trimmed.add(packageName);
        }
        return analysis_packages_trimmed;
    }

    protected void compielJspFiles() throws FileNotFoundException, IOException {
        Object builder;
        this.getProxy().inheritedSetBuildInfo("additional_classpath", null);
        this.getProxy().inheritedSetBuildInfo("classpath", null);
        this.getProxy().inheritedSetBuildInfo("jsp_compiler", "Default Tomcat JSP Compiler");
        String compilerName = this.getProxy().getBuildInfo().getProperty("jsp_compiler");
        if (compilerName == null) {
            return;
        }
        BuilderDefinition definition = CommonCore.getBuildManager().getBuilder(compilerName);
        if (definition != null && (builder = definition.newBuilder()) instanceof BaseJSPCompiler) {
            BaseJSPCompiler compiler = (BaseJSPCompiler)builder;
            ClasspathUtil.appendToClasspath((String)this.getStageDirectory().getAbsolutePath(), (IScanTargetMinProxy)this.getProxy(), (boolean)true);
            compiler.init(this.getProxy(), new File(this.getProxy().getBuildInfo().getProperty("web_content_dir")), this.getStageDirectory());
            compiler.exec(this.getProgress());
            this.getProxy().getProperties().put("jsp_compiler", compiler);
            this.getProxy().getBuildInfo().setProperty("web_server_type", compiler.getServerType());
            this.processCompiledJsps(compiler, new File(this.getProxy().getBuildInfo().getProperty("web_content_dir")), this.getProxy(), this.getProgress());
            String cp = compiler.getServerClasspath();
            if (cp != null) {
                String[] splittedPaths;
                for (String path : splittedPaths = cp.split(File.pathSeparator)) {
                    if (path.contains("user.code.staged.jar") && path.contains(File.separator + "jre" + File.separator + "lib")) continue;
                    this.getDependencies().add(new File(path));
                }
            }
            return;
        }
        this.getProxy().getErrorManager().reportError(Messages.getMessage("err.jsp.compiler", compilerName), "jsp_compiler");
    }

    private void processCompiledJsps(BaseJSPCompiler compiler, File jsp_root, IScanTargetMinProxy proxy, IProgress progress) throws IOException {
        if (compiler.isSuccess()) {
            for (File jsp : this.getJspFiles(jsp_root)) {
                Message message;
                String path = jsp_root.toURI().relativize(jsp.toURI()).getPath();
                File[] compiledClasses = compiler.getCompiledClasses(path, progress);
                if (compiledClasses.length != 0) {
                    for (File compiledClass : compiledClasses) {
                        ClassInfo ci = new ClassInfo(compiledClass);
                        if (ci.getClassName().contains("stage._2.Java.analyze.")) continue;
                        this.addFileToStagedMap(compiledClass, ci, path);
                        this.getUserCodeFiles().add(compiledClass);
                        if (ci.getPackageName() != null) {
                            this.m_analysis_packages.add(ci.getPackageName());
                        }
                        DiscoveryCore.addScanFileParent((File)compiledClass, (String)this.getCurrentParent());
                    }
                    continue;
                }
                String error = Messages.getMessage("err.jsp.compile", path);
                proxy.getValidationIssues().add(new CompileError(jsp, error, IValidationIssue.SEVERITY.SEVERE));
                Message message2 = message = new Message(2, error);
                message2.getClass();
                message.setMessageSource(new Message.MessageSource(message2, proxy.getPath(), path, 0));
                proxy.getLogManager().log(message);
            }
        }
    }

    private List<File> getJspFiles(File directory) {
        ArrayList<File> jsps = new ArrayList<File>();
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    jsps.addAll(this.getJspFiles(file));
                    continue;
                }
                if (!file.isFile() || this.isUserExcluded(file.getPath()) || !file.getName().toLowerCase().endsWith(".jsp") && !file.getName().toLowerCase().endsWith(".jspx")) continue;
                jsps.add(file);
            }
        }
        return jsps;
    }

    @Override
    public void validateScanFiles(IScanTargetMinProxy proxy, IProgress progress, Set<IScanFile> files) {
        if (this.getProxy() != null) {
            this.getProxy().getValidationIssues().addAll(new JavaTargetValidator((Collection<File>)this.getUserCodeFiles(), this.getProxy()).validate(this.getProgress()));
        }
    }

    private static boolean isSupportedClassVersion(String fileName) throws IOException, FileNotFoundException {
        DataInputStream cName = new DataInputStream(new FileInputStream(fileName));
        cName.skip(6L);
        boolean supported = true;
        String supportedVersion = System.getProperty("java.class.version");
        int currentVersion = Integer.parseInt(supportedVersion.substring(0, supportedVersion.indexOf(".")));
        int targetMajorVersion = cName.readUnsignedShort();
        cName.close();
        if (targetMajorVersion > currentVersion) {
            supported = false;
        }
        return supported;
    }
}

