/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dotnet.cil;

import com.ibm.wala.dotnet.cil.Bytecode;
import com.ibm.wala.dotnet.cil.Translator;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import java.util.Set;

public class CILBinaryOpInstruction
implements IBinaryOpInstruction {
    private final boolean isUnsigned;
    private final boolean isOverflow;
    private final IBinaryOpInstruction.IOperator op;
    private final Translator.RuntimeType type;

    CILBinaryOpInstruction(boolean isUnsigned, boolean isOverflow, IBinaryOpInstruction.IOperator op, Translator.RuntimeType type) {
        this.isUnsigned = isUnsigned;
        this.isOverflow = isOverflow;
        this.op = op;
        this.type = type;
    }

    CILBinaryOpInstruction(Set<Bytecode.Flag> flags, IBinaryOpInstruction.IOperator op, Translator.RuntimeType type) {
        this(flags.contains((Object)Bytecode.Flag.flag_un), flags.contains((Object)Bytecode.Flag.flag_ovf), op, type);
    }

    public String toString() {
        return "Binary(" + this.op + "," + (Object)((Object)this.type) + ")";
    }

    public boolean isOverflow() {
        return this.isOverflow;
    }

    public boolean isUnsigned() {
        return this.isUnsigned;
    }

    public Translator.RuntimeType getRuntimeType() {
        return this.type;
    }

    public IBinaryOpInstruction.IOperator getOperator() {
        return this.op;
    }

    public String getType() {
        return this.type.toString();
    }

    public int[] getBranchTargets() {
        return Instruction.noInstructions;
    }

    public int getPoppedCount() {
        return 2;
    }

    public String getPushedType(String[] poppedTypesToCheck) {
        return this.type.toString();
    }

    public byte getPushedWordSize() {
        return this.type.size();
    }

    public boolean isFallThrough() {
        return true;
    }

    public boolean isPEI() {
        return this.isOverflow || this.op == IBinaryOpInstruction.Operator.DIV && this.type != Translator.RuntimeType.F;
    }

    public IInstruction redirectTargets(int[] targetMap) {
        return this;
    }

    public void visit(IInstruction.Visitor v) {
        v.visitBinaryOp((IBinaryOpInstruction)this);
    }

    public boolean throwsExceptionOnOverflow() {
        return this.isOverflow;
    }
}

