/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dotnet.loader.csharp;

import com.ibm.wala.classLoader.IBytecodeMethod;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.ShrikeIRFactory;
import com.ibm.wala.dotnet.cil.Translator;
import com.ibm.wala.dotnet.loader.AbstractLowLevelInterface;
import com.ibm.wala.dotnet.loader.CLRAnalysisScope;
import com.ibm.wala.dotnet.loader.CLRLanguage;
import com.ibm.wala.dotnet.loader.CLRMethod;
import com.ibm.wala.dotnet.loader.LowLevelInterface;
import com.ibm.wala.dotnet.types.CLRTypeReference;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class CSharpInterface
extends AbstractLowLevelInterface<Integer, Integer, Integer, Integer, Integer>
implements LowLevelInterface<Integer, Integer, Integer, Integer, Integer> {
    private static final boolean DEBUG = false;
    private final Map<String, Integer> images = HashMapFactory.make();
    private final Map<Key, Integer> classCache = HashMapFactory.make();
    private final Map<Integer, String> imageAssemblyNamesCache = HashMapFactory.make();

    private static native void init();

    public native Integer[] classGetDeclaredInstanceFields(Integer var1);

    public native Integer[] classGetDeclaredInstanceMethods(Integer var1);

    public native Integer[] classGetDeclaredInterfaces(Integer var1);

    public native Integer[] classGetDeclaredStaticFields(Integer var1);

    public native Integer[] classGetDeclaredStaticMethods(Integer var1);

    @Override
    public native Integer classGetParent(Integer var1);

    @Override
    public native String[] classGetSourceFiles(Integer var1);

    @Override
    public native Integer classGetStaticCtor(Integer var1);

    @Override
    public native boolean classIsAbstract(Integer var1);

    @Override
    public native boolean classIsInterface(Integer var1);

    @Override
    public native boolean classIsPublic(Integer var1);

    public native String className(Integer var1);

    @Override
    public Integer findClass(Integer image, String name, String packageName) {
        Key key = new Key(image, name, packageName);
        Integer result = this.classCache.get(key);
        if (result == null) {
            CLRTypeReference.PrimitiveTypeInfo primitiveInfo = CLRTypeReference.getPrimitiveInfo(name);
            if (primitiveInfo != null) {
                String dotnetName = primitiveInfo.getSystemName();
                assert (dotnetName != null);
                result = this.findClassImpl(image, dotnetName, "System");
            } else {
                result = this.findClassImpl(image, name, packageName);
            }
            if (result == -1 && packageName == null) {
                result = this.findClassImpl(image, name, "System");
            }
            this.classCache.put(key, result);
        }
        return result;
    }

    private native Integer findClassImpl(Integer var1, String var2, String var3);

    public native Integer findClassMethod(Integer var1, String var2, Integer[] var3);

    @Override
    public native Integer findField(Integer var1, String var2, Integer var3);

    @Override
    public native Integer findFieldType(Integer var1);

    public native Integer findImage(String var1);

    @Override
    public Integer findImage(String s, boolean isSystemImage) {
        int result = this.findImage(s);
        this.images.put(this.imageGetAssemblyName(result), result);
        if (isSystemImage) {
            this.images.put("Root", result);
            this.images.put("$Synthetic", result);
            this.images.put("Primordial", result);
        }
        return result;
    }

    public native Integer findInstanceMethod(Integer var1, String var2, Integer[] var3);

    @Override
    public String imageGetAssemblyName(Integer image) {
        String result = this.imageAssemblyNamesCache.get(image);
        if (result == null) {
            result = this.imageGetAssemblyNameImpl(image);
            assert (result != null);
            this.imageAssemblyNamesCache.put(image, result);
        }
        return result;
    }

    private native String imageGetAssemblyNameImpl(Integer var1);

    @Override
    public native int numberOfClasses(Integer var1);

    @Override
    public native int numberOfMethods(Integer var1);

    @Override
    public Integer methodGetDeclaringClass(Integer method) {
        return this.methodGetDeclaringClassImpl(method);
    }

    private native Integer methodGetDeclaringClassImpl(Integer var1);

    @Override
    public native int methodGetLineNumber(Integer var1, int var2);

    @Override
    public native int methodGetMaxLocals(Integer var1);

    @Override
    public native int methodGetMaxStackHeight(Integer var1);

    @Override
    public native int methodGetNumberOfParameters(Integer var1);

    @Override
    public native Integer methodGetParameterType(Integer var1, int var2);

    @Override
    public native Integer methodGetReturnType(Integer var1);

    @Override
    public native boolean methodHasExceptionHandler(Integer var1);

    @Override
    public native boolean methodIsAbstract(Integer var1);

    @Override
    public native boolean methodIsClinit(Integer var1);

    @Override
    public native boolean methodIsFinal(Integer var1);

    @Override
    public native boolean methodIsInit(Integer var1);

    @Override
    public native boolean methodIsNative(Integer var1);

    @Override
    public native boolean methodIsPrivate(Integer var1);

    @Override
    public native boolean methodIsPublic(Integer var1);

    @Override
    public native boolean methodIsStatic(Integer var1);

    @Override
    public native boolean methodIsSynchronized(Integer var1);

    @Override
    public native String classGetName(Integer var1);

    @Override
    public native String methodGetName(Integer var1);

    public native Integer[] imageAllClasses(Integer var1);

    @Override
    public native boolean classIsPrimitive(Integer var1);

    @Override
    public String primitiveGetName(Integer classHandle) {
        return this.primitiveGetNameImpl(classHandle);
    }

    private native String primitiveGetNameImpl(Integer var1);

    @Override
    public native boolean classIsArray(Integer var1);

    @Override
    public native Integer arrayGetElement(Integer var1);

    @Override
    public native boolean classIsPointer(Integer var1);

    @Override
    public native Integer pointerGetReferrent(Integer var1);

    @Override
    public Integer getImage(String assemblyName) {
        return this.images.get(assemblyName);
    }

    @Override
    public boolean classNotValid(Integer handle) {
        return handle.equals(-1);
    }

    @Override
    public boolean methodNotValid(Integer method) {
        return method.equals(-1);
    }

    @Override
    public boolean fieldNotValid(Integer field) {
        return field.equals(-1);
    }

    @Override
    public native Integer classGetImage(Integer var1);

    @Override
    public native boolean classIsTypeVar(Integer var1);

    @Override
    public native boolean classIsReference(Integer var1);

    @Override
    public native Integer refGetReferrent(Integer var1);

    @Override
    public native String typeGetName(Integer var1);

    @Override
    public native Integer withGetBase(Integer var1);

    @Override
    public native int withGetNumParams(Integer var1);

    @Override
    public native Integer withGetParam(Integer var1, int var2);

    @Override
    public native boolean classIsWith(Integer var1);

    @Override
    public native byte[] methodGetBytecode(Integer var1);

    @Override
    public Integer resolveTypeToken(Integer methodHandle, int token) {
        int result = this.resolveTypeTokenImpl(methodHandle, token);
        return result;
    }

    public native Integer resolveTypeTokenImpl(Integer var1, int var2);

    @Override
    public Integer resolveMethodToken(Integer methodHandle, int token) {
        int result = 0;
        try {
            result = this.resolveMethodTokenImpl(methodHandle, token);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private native Integer resolveMethodTokenImpl(Integer var1, int var2);

    @Override
    public native Integer resolveFieldToken(Integer var1, int var2);

    @Override
    public Integer fieldDeclaringClass(Integer fieldHandle) {
        return this.fieldDeclaringClassImpl(fieldHandle);
    }

    private native Integer fieldDeclaringClassImpl(Integer var1);

    @Override
    public native String fieldGetName(Integer var1);

    @Override
    public native Integer fieldGetType(Integer var1);

    @Override
    public Integer methodGetLocalVariableType(Integer method, int localNumber) {
        return this.methodGetLocalVariableTypeImpl(method, localNumber);
    }

    private native Integer methodGetLocalVariableTypeImpl(Integer var1, int var2);

    @Override
    public void clearCaches() {
        this.images.clear();
        this.classCache.clear();
        this.imageAssemblyNamesCache.clear();
        this.clearNativeCaches();
    }

    public native void clearNativeCaches();

    @Override
    public native boolean fieldIsFinal(Integer var1);

    @Override
    public native boolean fieldIsProtected(Integer var1);

    @Override
    public native boolean fieldIsPublic(Integer var1);

    @Override
    public native boolean fieldIsStatic(Integer var1);

    @Override
    public native String methodGetSourceFileName(Integer var1, int var2);

    @Override
    public native String resolveStringToken(Integer var1, int var2);

    @Override
    public native int methodGetHeaderSize(Integer var1);

    @Override
    public native CLRMethod.ExceptionEntry[] methodGetHandlers(CLRMethod<Integer, Integer, Integer, Integer, Integer> var1, Integer var2);

    @Override
    public boolean classIsValueType(Integer classHandle) {
        return this.classIsValueTypeImpl(classHandle);
    }

    private void printStack() {
    }

    private native boolean classIsValueTypeImpl(Integer var1);

    @Override
    public native Integer attributeGetType(Integer var1);

    public native Integer[] classGetCustomAttributes(Integer var1);

    public native Integer[] fieldGetCustomAttributes(Integer var1);

    public native Integer[] methodGetCustomAttributes(Integer var1);

    public native Integer[] methodGetCustomParameterAttributes(Integer var1, int var2);

    @Override
    public native int methodGetAccessMask(Integer var1);

    @Override
    public String classHandleToString(Integer classHandle) {
        return classHandle.toString();
    }

    @Override
    public Integer classHandleFromString(String handle) {
        return Integer.valueOf(handle);
    }

    private Integer box(int i) {
        return i;
    }

    private int unbox(Integer i) {
        return i;
    }

    public static void main(String[] args) throws ClassHierarchyException {
        CSharpInterface.test1(args[0]);
        String[] files = new String[args.length - 1];
        for (int index = 1; index < args.length; ++index) {
            files[index - 1] = args[index];
        }
        CSharpInterface.test2(files);
    }

    private static void test1(String path) {
        Integer[] classHandles;
        System.out.println("test1");
        long timeBefore = System.currentTimeMillis();
        CSharpInterface i = new CSharpInterface();
        int imageHandle = i.findImage(path);
        String imageAsmName = i.imageGetAssemblyName(imageHandle);
        System.out.println("Assembly name: " + imageAsmName);
        int numberOfClasses = i.numberOfClasses(imageHandle);
        System.out.println("Number of classes: " + numberOfClasses);
        for (Integer j : classHandles = i.imageAllClasses(imageHandle)) {
            System.out.println("Class handle: " + j);
            System.out.println("Class name: " + i.classGetName(j));
            System.out.println("Class is abstract: " + i.classIsAbstract(j));
            System.out.println("Class is array: " + i.classIsArray(j));
            System.out.println("Class is public: " + i.classIsPublic(j));
            System.out.println("Class is interface: " + i.classIsInterface(j));
            System.out.println("Class is pointer: " + i.classIsPointer(j));
            int k = i.classGetParent(j);
            System.out.println("Parent name: " + i.classGetName(k));
            for (Integer w : i.classGetDeclaredInstanceFields(j)) {
                System.out.println("Instance field name: " + i.classGetName(w));
            }
            for (Integer w : i.classGetDeclaredStaticFields(j)) {
                System.out.println("Static field name: " + i.classGetName(w));
            }
            for (Integer w : i.classGetDeclaredInterfaces(j)) {
                System.out.println("Declared interface: " + i.classGetName(w));
            }
        }
        long timeAfter = System.currentTimeMillis();
        System.out.println("Total time: " + (timeAfter - timeBefore));
    }

    private static void test2(String[] files) throws ClassHierarchyException {
        File sysAssembly = new File(files[0]);
        HashSet assemblies = HashSetFactory.make();
        for (int i = 1; i < files.length; ++i) {
            assemblies.add(new File(files[i]));
        }
        CLRAnalysisScope<Integer, Integer, Integer, Integer, Integer> scope = new CLRAnalysisScope<Integer, Integer, Integer, Integer, Integer>(sysAssembly, HashSetFactory.make(), assemblies, new CSharpInterface());
        ClassHierarchy cha = ClassHierarchy.make(scope, scope, (Language)CLRLanguage.lang);
        ShrikeIRFactory irFactory = new ShrikeIRFactory();
        Iterator clss = cha.iterator();
        File f = new File("c:/temp/IRs.txt");
        FileWriter fw = null;
        try {
            fw = new FileWriter(f);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        while (clss.hasNext()) {
            IClass cls = (IClass)clss.next();
            for (IMethod m : cls.getDeclaredMethods()) {
                CLRMethod mm;
                if (!(m instanceof CLRMethod) || (mm = (CLRMethod)m).getBytecode() == null) continue;
                try {
                    Translator.BCInfo translationResult = Translator.translate(mm);
                    for (IInstruction iInstruction : translationResult.getInstructions()) {
                    }
                    IR ir = irFactory.makeIR((IBytecodeMethod)((CLRMethod)m), (Context)Everywhere.EVERYWHERE, SSAOptions.defaultOptions());
                    System.err.println(ir);
                    fw.append(ir.toString());
                    fw.append(System.getenv("line.separator"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                catch (Error e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int methodGetNumberOfOutParameters(Integer method) {
        return 0;
    }

    @Override
    public native int attributeArgumentCount(Integer var1);

    @Override
    public native Integer attributeArgumentType(Integer var1, int var2);

    @Override
    public native String attributeArgumentValue(Integer var1, int var2);

    @Override
    public native int attributeNamedArgumentCount(Integer var1);

    @Override
    public native Integer attributeNamedArgumentType(Integer var1, int var2);

    @Override
    public native String attributeNamedArgumentValue(Integer var1, int var2);

    @Override
    public native String attributeNamedArgumentName(Integer var1, int var2);

    static {
        System.loadLibrary("MCPP");
        CSharpInterface.init();
    }

    private static final class Key {
        private final String className;
        private final String packageName;
        private final Integer imageIndex;

        public Key(Integer imageIndex, String className, String packageName) {
            this.imageIndex = imageIndex;
            this.className = className;
            this.packageName = packageName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
            result = 31 * result + (this.imageIndex == null ? 0 : this.imageIndex.hashCode());
            result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
                return false;
            }
            if (this.imageIndex == null ? other.imageIndex != null : !this.imageIndex.equals(other.imageIndex)) {
                return false;
            }
            return !(this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName));
        }
    }
}

