/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks;

import com.ibm.appscan.frameworks.FrameworkInfoGenerator;
import com.ibm.appscan.frameworks.FrameworksInput;
import com.ibm.appscan.frameworks.specinfo.IFrameworkInfo;
import com.ibm.appscan.frameworks.specinfo.WAFLSpecSerializer;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import org.apache.log4j.xml.DOMConfigurator;

public class FrameworkGeneratorHarness {
    public static void run(FrameworksInput input, FrameworkInfoGenerator generator) throws Exception {
        FrameworkGeneratorHarness.initializeLogging(input);
        IFrameworkInfo info = generator.generateFrameworkInfo(input);
        FrameworkGeneratorHarness.serializeWAFLSpec(info, input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void serializeWAFLSpec(IFrameworkInfo info, FrameworksInput input) throws FileNotFoundException {
        String outputFileName = input.getFileLocs().getOutputWAFLFileName();
        String serialized = WAFLSpecSerializer.make(true).getFrameworkSpec(info);
        try (PrintWriter writer = null;){
            writer = new PrintWriter(outputFileName);
            writer.write(serialized);
        }
    }

    private static void initializeLogging(FrameworksInput input) {
        String log4JConfigFile = input.getFileLocs().getLogFileConfigName();
        DOMConfigurator.configure((String)log4JConfigFile);
    }
}

