/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.specinfo;

import com.ibm.appscan.frameworks.specinfo.ArgToOrigCallExpr;
import com.ibm.appscan.frameworks.specinfo.NonVoidSyntheticExpr;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.frameworks.util.VDBChecks;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class InvokeExpr
extends NonVoidSyntheticExpr {
    private final String calleeVDBSignature;
    private final Map<Integer, NonVoidSyntheticExpr> actualParameterPos2Value;

    public static InvokeExpr createInvokeExpr(FilePositionInfo filePosInfo, String calleeSignature, Map<Integer, NonVoidSyntheticExpr> actualParameterPos2Value) {
        if (!VDBChecks.isValidVDBSignature(calleeSignature)) {
            throw new IllegalArgumentException("callee signature " + calleeSignature + " must be in VDB format");
        }
        return new InvokeExpr(filePosInfo, calleeSignature, actualParameterPos2Value);
    }

    public static InvokeExpr createInvokeExprWithOrigArgs(FilePositionInfo filePosInfo, String calleeSignature, int numArgs) {
        LinkedHashMap<Integer, NonVoidSyntheticExpr> actualParameterPos2Value = new LinkedHashMap<Integer, NonVoidSyntheticExpr>();
        for (int i = 0; i < numArgs; ++i) {
            actualParameterPos2Value.put(i, ArgToOrigCallExpr.make(i));
        }
        return InvokeExpr.createInvokeExpr(filePosInfo, calleeSignature, actualParameterPos2Value);
    }

    protected InvokeExpr(FilePositionInfo filePosInfo, String calleeSignature, Map<Integer, NonVoidSyntheticExpr> actualParameterPos2Value) {
        super(filePosInfo);
        this.calleeVDBSignature = calleeSignature;
        assert (VDBChecks.isValidVDBSignature(calleeSignature));
        this.actualParameterPos2Value = Collections.unmodifiableMap(actualParameterPos2Value);
    }

    public String getCalleeVDBSignature() {
        return this.calleeVDBSignature;
    }

    public Map<Integer, NonVoidSyntheticExpr> getActualParameterPos2Value() {
        return this.actualParameterPos2Value;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.actualParameterPos2Value == null ? 0 : this.actualParameterPos2Value.hashCode());
        result = 31 * result + (this.calleeVDBSignature == null ? 0 : this.calleeVDBSignature.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InvokeExpr other = (InvokeExpr)obj;
        if (this.actualParameterPos2Value == null ? other.actualParameterPos2Value != null : !this.actualParameterPos2Value.equals(other.actualParameterPos2Value)) {
            return false;
        }
        return !(this.calleeVDBSignature == null ? other.calleeVDBSignature != null : !this.calleeVDBSignature.equals(other.calleeVDBSignature));
    }

    public String toString() {
        return "InvokeExpr [actualParameterPos2Value=" + this.actualParameterPos2Value + ", calleeSignature=" + this.calleeVDBSignature + "]";
    }
}

