/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMParserWithLineNumbers
extends DOMParser {
    public static final String START_LINE_KEY = "startLine";
    public static final String START_COLUMN_KEY = "startColumn";
    private PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "UTF8"));
    private static boolean NotIncludeIgnorableWhiteSpaces = false;
    private XMLLocator locator;

    public DOMParserWithLineNumbers(InputStream is) throws IOException, SAXException {
        this.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        this.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        this.parse(new InputSource(is));
        is.close();
    }

    public DOMParserWithLineNumbers(InputSource is) throws IOException, SAXException {
        this.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        this.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        this.parse(is);
    }

    public DOMParserWithLineNumbers(String filename) throws FileNotFoundException, IOException, SAXException {
        this(new FileInputStream(filename));
    }

    public void print(Node node) {
        if (node == null) {
            return;
        }
        String startLine = (String)node.getUserData(START_LINE_KEY);
        String startColumn = (String)node.getUserData(START_COLUMN_KEY);
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                this.out.println(startLine + "(" + startColumn + "):<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                this.print(((Document)node).getDocumentElement());
                this.out.flush();
                break;
            }
            case 1: {
                this.out.print(startLine + "(" + startColumn + "):" + '<');
                this.out.print(node.getNodeName());
                Attr[] attrs = this.sortAttributes(node.getAttributes());
                for (int i = 0; i < attrs.length; ++i) {
                    Attr attr = attrs[i];
                    this.out.print(' ');
                    this.out.print(attr.getNodeName());
                    this.out.print("=\"");
                    this.out.print(attr.getNodeValue());
                    this.out.print('\"');
                }
                this.out.print('>');
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    this.print(children.item(i));
                }
                break;
            }
            case 5: {
                this.out.print('&');
                this.out.print(node.getNodeName());
                this.out.print(';');
                break;
            }
            case 4: {
                this.out.print("<![CDATA[");
                this.out.print(node.getNodeValue());
                this.out.print("]]>");
                break;
            }
            case 3: {
                this.out.print(node.getNodeValue());
                break;
            }
            case 7: {
                this.out.print("<?");
                this.out.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    this.out.print(' ');
                    this.out.print(data);
                }
                this.out.print("?>");
                break;
            }
        }
        if (type == 1) {
            this.out.print("</");
            this.out.print(node.getNodeName());
            this.out.print('>');
        }
        this.out.flush();
    }

    private Attr[] sortAttributes(NamedNodeMap attrs) {
        int i;
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        for (i = 0; i < len; ++i) {
            array[i] = (Attr)attrs.item(i);
        }
        for (i = 0; i < len - 1; ++i) {
            String name = array[i].getNodeName();
            int index = i;
            for (int j = i + 1; j < len; ++j) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) >= 0) continue;
                name = curName;
                index = j;
            }
            if (index == i) continue;
            Attr temp = array[i];
            array[i] = array[index];
            array[index] = temp;
        }
        return array;
    }

    public void startElement(QName elementQName, XMLAttributes attrList, Augmentations augs) throws XNIException {
        super.startElement(elementQName, attrList, augs);
        this.setCurrentNodeLineAndColumnInfo();
    }

    private void setCurrentNodeLineAndColumnInfo() {
        Node node = null;
        try {
            node = (Node)this.getProperty("http://apache.org/xml/properties/dom/current-element-node");
        }
        catch (SAXException ex) {
            System.err.println("except" + ex);
        }
        if (node != null) {
            node.setUserData(START_LINE_KEY, String.valueOf(this.locator.getLineNumber()), null);
            int columnNumber = this.locator.getColumnNumber();
            node.setUserData(START_COLUMN_KEY, String.valueOf(columnNumber), null);
        }
    }

    public void startDocument(XMLLocator theLocator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        super.startDocument(theLocator, encoding, namespaceContext, augs);
        this.locator = theLocator;
    }

    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        if (!NotIncludeIgnorableWhiteSpaces) {
            super.ignorableWhitespace(text, augs);
        }
    }

    public static void main(String[] argv) throws IOException, SAXException {
        if (argv.length == 0) {
            DOMParserWithLineNumbers.printUsage();
            System.exit(1);
        }
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if (arg.startsWith("-")) {
                if (arg.equals("-h")) {
                    DOMParserWithLineNumbers.printUsage();
                    System.exit(1);
                }
                if (arg.equals("-i")) {
                    NotIncludeIgnorableWhiteSpaces = true;
                    continue;
                }
            }
            DOMParserWithLineNumbers domAddExample = new DOMParserWithLineNumbers(arg);
            Document doc = domAddExample.getDocument();
            domAddExample.print(doc);
        }
    }

    private static void printUsage() {
        System.err.println("usage: jre dom.DOMAddLines (options) uri ...");
        System.err.println();
        System.err.println("  -h       Display help screen.");
        System.err.println("  -i       Don't print ignorable white spaces.");
    }
}

