/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.jaxwshandler;

import com.ibm.appscan.frameworks.FileLocations;
import com.ibm.appscan.frameworks.FrameworksInput;
import com.ibm.appscan.frameworks.highlevelapi.F4FActions;
import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.F4FHandler;
import com.ibm.appscan.frameworks.jaxwshandler.EndPointHandler;
import com.ibm.appscan.frameworks.jaxwshandler.JavaBeanEndPointHandler;
import com.ibm.appscan.frameworks.jaxwshandler.ProviderEndPointHandler;
import com.ibm.appscan.frameworks.util.JavaUtils;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.frameworks.wsdl.util.internal.WSDLReportingUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.types.annotations.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class JAXWSHandler
extends F4FHandler {
    final Logger logger = TaintLogger.i().getLogger();

    public void handleApp(F4FApp app, F4FActions actions) {
        this.logger.info((Object)Messages.getString((String)"framework.handler.running", (Object[])new Object[]{"JAXWS", "handleApp()"}));
        Collection<IClass> webServiceClassList = this.findWebServiceClasses(app);
        if (webServiceClassList.size() <= 0) {
            this.logger.info((Object)Messages.getString((String)"framework.handler.exit", (Object[])new Object[]{"JAXWS"}));
            return;
        }
        String filePath = WSDLReportingUtil.getServicesFilePath((FileLocations)this.getFrameworksInput().getFileLocs());
        if (filePath != null) {
            WSDLReportingUtil.initXmlDocument((String)filePath);
        }
        String scopeFileName = this.getFrameworksInput().getFileLocs().getScopeFileName();
        ArrayList sourceDirectoryList = JavaUtils.retrieveSourceDirectoryList((String)scopeFileName);
        ArrayList<EndPointHandler> handlers = new ArrayList<EndPointHandler>();
        handlers.add(new JavaBeanEndPointHandler(sourceDirectoryList));
        handlers.add(new ProviderEndPointHandler(sourceDirectoryList));
        for (IClass clazz : webServiceClassList) {
            for (EndPointHandler handler : handlers) {
                this.logger.info((Object)Messages.getString((String)"framework.examine", (Object[])new Object[]{"class: " + clazz.getName().toString()}));
                handler.handleClass(clazz, app, actions);
            }
        }
        WSDLReportingUtil.saveXmlDocument();
        this.logger.info((Object)Messages.getString((String)"framework.handler.exit", (Object[])new Object[]{"JAXWS"}));
    }

    private Collection<IClass> findWebServiceClasses(F4FApp app) {
        ArrayList<IClass> jaxWsClassList = new ArrayList<IClass>();
        Collection appClazzList = app.getAllApplicationClasses();
        block0: for (IClass clazz : appClazzList) {
            this.logger.info((Object)Messages.getString((String)"framework.examine", (Object[])new Object[]{"class " + clazz.getName().toString()}));
            if (clazz.isInterface()) continue;
            Collection annotationLists = app.getClassAnnotations(clazz);
            for (Annotation annotation : annotationLists) {
                if (!annotation.getType().getName().toString().equals("Ljavax/jws/WebService") && !annotation.getType().getName().toString().equals("Ljavax/xml/ws/WebServiceProvider")) continue;
                this.logger.info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{"Ljavax/jws/WebService || Ljavax/xml/ws/WebServiceProvider"}));
                jaxWsClassList.add(clazz);
                continue block0;
            }
        }
        return jaxWsClassList;
    }

    public boolean isApplicable() {
        this.logger.info((Object)Messages.getString((String)"framework.handler.running", (Object[])new Object[]{"JAXWS", "isApplicable()"}));
        FrameworksInput input = this.getFrameworksInput();
        if (input.getType().equals("Java")) {
            this.logger.info((Object)Messages.getString((String)"framework.returns", (Object[])new Object[]{"isApplicable()", "true"}));
            return true;
        }
        this.logger.info((Object)Messages.getString((String)"framework.returns", (Object[])new Object[]{"isApplicable()", "false"}));
        this.logger.info((Object)Messages.getString((String)"framework.handler.exit", (Object[])new Object[]{"JAXWS"}));
        return false;
    }
}

