/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.jaxwshandler;

import com.ibm.appscan.frameworks.highlevelapi.F4FActions;
import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.HighLevelSyntheticMethod;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Param;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Taint;
import com.ibm.appscan.frameworks.jaxwshandler.EndPointHandler;
import com.ibm.appscan.frameworks.jaxwshandler.utils.JAXWSUtils;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.frameworks.util.JavaUtils;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.types.annotations.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class ProviderEndPointHandler
extends EndPointHandler {
    private static final String PARAM_NAME = "param";
    private ArrayList<String> sourceDirectoryList = null;
    final Logger logger = TaintLogger.i().getLogger();

    public ProviderEndPointHandler(ArrayList<String> sourceDirectoryList) {
        this.sourceDirectoryList = sourceDirectoryList;
    }

    @Override
    public void handleClass(IClass clazz, F4FApp app, F4FActions actions) {
        Annotation providerAnnotation = JAXWSUtils.getAnnotation(app, clazz, "Ljavax/xml/ws/WebServiceProvider");
        if (providerAnnotation != null) {
            this.logger.info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{"Ljavax/xml/ws/WebServiceProvider"}));
            IMethod invokeMethod = this.findInvokeMethod(clazz, app);
            if (invokeMethod != null) {
                this.createSyntheticMethod(app, actions, invokeMethod, providerAnnotation);
            }
        }
    }

    private IMethod findInvokeMethod(IClass clazz, F4FApp app) {
        IMethod invokeMethod = null;
        Collection methods = clazz.getDeclaredMethods();
        for (IMethod method : methods) {
            if (!"invoke".equals(method.getName().toString()) || !method.isPublic() || method.isStatic()) continue;
            this.logger.info((Object)Messages.getString((String)"framework.method.found", (Object[])new Object[]{"invoke"}));
            invokeMethod = method;
            break;
        }
        return invokeMethod;
    }

    private void createSyntheticMethod(F4FApp app, F4FActions actions, IMethod invokeMethod, Annotation providerAnnotation) {
        if (invokeMethod.getNumberOfParameters() != 2) {
            return;
        }
        String methodVdbSig = "AppScan.Synthetic.JAXWS." + VDBJavaUtil.jvmToVDBSignature((String)invokeMethod.getSignature());
        this.logger.info((Object)Messages.getString((String)"framework.begin.syntheticmethod", (Object[])new Object[]{methodVdbSig}));
        HighLevelSyntheticMethod synthMethod = HighLevelSyntheticMethod.make((String)methodVdbSig);
        Param[] methodParams = new Param[2];
        this.logger.info((Object)Messages.getString((String)"framework.generate.local", (Object[])new Object[]{invokeMethod.getDeclaringClass().getName().toString()}));
        methodParams[0] = synthMethod.newLocal(invokeMethod.getDeclaringClass());
        this.logger.info((Object)Messages.getString((String)"framework.taint.param.found", (Object[])new Object[]{"param0", "1"}));
        methodParams[1] = Taint.taintWithParamName((String)"param0");
        FilePositionInfo filePos = JavaUtils.getMethodPosition((IMethod)invokeMethod, this.sourceDirectoryList);
        this.logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{invokeMethod.getSignature()}));
        synthMethod.addCall(invokeMethod, filePos, methodParams);
        this.logger.info((Object)Messages.getString((String)"framework.generate.syntheticmethod", (Object[])new Object[]{synthMethod.getVdbSignature()}));
        actions.addHighLevelSyntheticMethod(synthMethod, true);
    }
}

